using System;
using System.Collections.Generic;
using System.Drawing;
using System.Media;
using System.Windows.Forms;
using System.Windows.Forms.ColorPicker;
using System.Text.RegularExpressions;
using pcmp.Setting;

namespace pcmp.Forms
{
    public partial class FormFavSetting : Form
    {
        public List<FavSetting> favList;
        private ColorPicker picker = null;
        private int clickedSetColorButton;
        private int selectedIndex = 0;

        // ----------------------------------------------------------
        // \bh
        // ----------------------------------------------------------
        public FormFavSetting()
        {
            InitializeComponent();

            picker = new ColorPicker();
            picker.ColorSelected += new ColorSelectedEventHandler(picker_ColorSelected);
            FavSetting[] favArray = Settings.FavSettings;
            if (favArray == null) favList = new List<FavSetting>();
            else favList = new List<FavSetting>(favArray);
            ListFavorites();
            SetEnableControls();
            if (favList.Count >= 1)
            {
                SetValueToGUI(favList[0]);
                listBoxPageList.SelectedIndex = 0;
            }
        }

        private void ListFavorites()
        {
            if (favList == null) return;

            foreach (FavSetting fav in favList)
            {
                listBoxPageList.Items.Add(fav.Name);
            }

        }

        private void SetValueToGUI(FavSetting Favorite)
        {
            checkBoxNotUseColorSetting.Checked = !Favorite.UseColorSetting;
            checkBoxEnable.Checked = Favorite.Enable;
            textBoxFavName.Text = Favorite.Name;
            textBoxFindText.Text = Favorite.SearchString;
            checkBoxFindChannelName.Checked = Favorite.SearchChannelName;
            checkBoxFindDetail.Checked = Favorite.SearchDetail;
            checkBoxFindContactUrl.Checked = Favorite.SearchContactUrl;
            checkBoxFindYpAddr.Checked = Favorite.SearchYelloPageUrl;
            checkBoxUseRegEx.Checked = Favorite.UseRegex;
            checkBoxAllFind.Checked = Favorite.SerachAfterConcat;
            checkBoxFindComment.Checked = Favorite.SearchComment;
            checkBoxShowBalloon.Checked = Favorite.ShowBalloon;
            listView1.Items[0].SubItems[0].ForeColor = Favorite.TextColor;
            listView1.Items[0].SubItems[1].ForeColor = Favorite.TextColor;
            listView1.Items[0].SubItems[2].ForeColor = Favorite.TextColor;
            listView1.Items[0].SubItems[3].ForeColor = Favorite.TextColor;
            listView1.Items[0].SubItems[0].BackColor = Favorite.BackColor;
            listView1.Items[0].SubItems[1].BackColor = Favorite.BackColor;
            listView1.Items[0].SubItems[2].BackColor = Favorite.BackColor;
            listView1.Items[0].SubItems[3].BackColor = Favorite.BackColor;
            if (Favorite.Font != null)
            {
                listView1.Items[0].SubItems[0].Font = Favorite.Font;
                listView1.Items[0].SubItems[1].Font = Favorite.Font;
                listView1.Items[0].SubItems[2].Font = Favorite.Font;
                listView1.Items[0].SubItems[3].Font = Favorite.Font;
            }
            textBoxSoundPath.Text = Favorite.SoundPath;
        }

        private void SetEnableControls()
        {
            if (listBoxPageList.Items.Count == 0)
            {
                checkBoxEnable.Enabled = false;
                textBoxFavName.Enabled = false;
                textBoxFindText.Enabled = false;
                buttonInsertString.Enabled = false;
                groupBox1.Enabled = false;
                groupBox2.Enabled = false;
                checkBoxUseRegEx.Enabled = false;
                listView1.Enabled = false;
                textBoxSoundPath.Enabled = false;
                checkBoxNotUseColorSetting.Enabled = false;
                checkBoxAllFind.Enabled = false;
                checkBoxShowBalloon.Enabled = false;
                buttonPlayStop.Enabled = false;
                buttonRemoveFav.Enabled = false;
                buttonSoundPath.Enabled = false;
            }
            else
            {
                checkBoxEnable.Enabled = true;
                textBoxFavName.Enabled = true;
                textBoxFindText.Enabled = true;
                buttonInsertString.Enabled = checkBoxUseRegEx.Checked;
                groupBox1.Enabled = true;
                groupBox2.Enabled = true;
                checkBoxUseRegEx.Enabled = true;
                listView1.Enabled = true;
                textBoxSoundPath.Enabled = true;
                checkBoxNotUseColorSetting.Enabled = true;
                checkBoxAllFind.Enabled = true;
                checkBoxShowBalloon.Enabled = true;
                buttonPlayStop.Enabled = true;
                buttonRemoveFav.Enabled = true;
                buttonSoundPath.Enabled = true;
            }
        }

        private void SetValueToSetting(int FavoriteIndex)
        {
            if (favList.Count != 0)
            {
                favList[FavoriteIndex].Enable = checkBoxEnable.Checked;
                favList[FavoriteIndex].Name = textBoxFavName.Text;
                favList[FavoriteIndex].SearchString = textBoxFindText.Text;
                favList[FavoriteIndex].SearchChannelName = checkBoxFindChannelName.Checked;
                favList[FavoriteIndex].SearchDetail = checkBoxFindDetail.Checked;
                favList[FavoriteIndex].SearchContactUrl = checkBoxFindContactUrl.Checked;
                favList[FavoriteIndex].SearchYelloPageUrl = checkBoxFindYpAddr.Checked;
                favList[FavoriteIndex].SearchComment = checkBoxFindComment.Checked;
                favList[FavoriteIndex].UseRegex = checkBoxUseRegEx.Checked;
                favList[FavoriteIndex].SerachAfterConcat = checkBoxAllFind.Checked;
                favList[FavoriteIndex].TextColor = listView1.Items[0].SubItems[0].ForeColor;
                favList[FavoriteIndex].BackColor = listView1.Items[0].SubItems[0].BackColor;
                favList[FavoriteIndex].Font = listView1.Items[0].SubItems[0].Font;
                favList[FavoriteIndex].SoundPath = textBoxSoundPath.Text;
                favList[FavoriteIndex].ShowBalloon = checkBoxShowBalloon.Checked;
                favList[FavoriteIndex].UseColorSetting = !checkBoxNotUseColorSetting.Checked;
            }
        }

        public void AddFavorite(string title)
        {
            FavSetting fav = new FavSetting();
            fav.Name = title;
            fav.SearchString = title;
            fav.TextColor = listView1.Items[0].SubItems[0].ForeColor;
            fav.BackColor = listView1.Items[0].SubItems[0].BackColor;
            fav.Font = listView1.Items[0].Font;
            favList.Add(fav);
            if (listBoxPageList.Items.Count == 0) SetValueToGUI(fav);
            listBoxPageList.Items.Add(fav.Name);
            listBoxPageList.SelectedIndex = listBoxPageList.Items.Count - 1;
            buttonRemoveFav.Enabled = true;
            SetEnableControls();
        }

        public void Save()
        {
            if (favList != null)
            {
                SetValueToSetting(listBoxPageList.SelectedIndex);
                FavSetting.Save(favList.ToArray());
                Settings.FavSettings = favList.ToArray();
            }
        }

        // ----------------------------------------------------------
        // Cxg
        // ----------------------------------------------------------
        private void picker_ColorSelected(object sender, ColorSelectedEventArgs e)
        {
            switch (clickedSetColorButton)
            {
                case 1:
                    listView1.Items[0].SubItems[0].ForeColor = e.ColorSelected;
                    listView1.Items[0].SubItems[1].ForeColor = e.ColorSelected;
                    listView1.Items[0].SubItems[2].ForeColor = e.ColorSelected;
                    listView1.Items[0].SubItems[3].ForeColor = e.ColorSelected;
                    break;
                case 2:
                    listView1.Items[0].SubItems[0].BackColor = e.ColorSelected;
                    listView1.Items[0].SubItems[1].BackColor = e.ColorSelected;
                    listView1.Items[0].SubItems[2].BackColor = e.ColorSelected;
                    listView1.Items[0].SubItems[3].BackColor = e.ColorSelected;
                    break;
            }
        }

        private void listBoxPageList_SelectedIndexChanged(object sender, EventArgs e)
        {
            if (listBoxPageList.SelectedIndex == -1) return;
            if (listBoxPageList.Items.Count == 0) return;
            SetValueToSetting(selectedIndex);
            FavSetting fav = favList[listBoxPageList.SelectedIndex];
            SetValueToGUI(fav);
            selectedIndex = listBoxPageList.SelectedIndex;

            // IꂽACeԏȂA{^𖳌ɂ
            if (listBoxPageList.SelectedIndex == 0) buttonFavUp.Enabled = false;
            else buttonFavUp.Enabled = true;

            // IꂽACeԉȂA{^𖳌ɂ
            if (listBoxPageList.SelectedIndex == favList.Count - 1) buttonFavDown.Enabled = false;
            else buttonFavDown.Enabled = true;
        }

        private void checkBoxUseRegEx_CheckedChanged(object sender, EventArgs e)
        {
            buttonInsertString.Enabled = checkBoxUseRegEx.Checked;
            buttonCheckRegEx.Enabled = checkBoxUseRegEx.Checked;
        }

        private void buttonPCYPTextColor_Click(object sender, EventArgs e)
        {
            Button btn_sender = (Button)sender;
            picker.Color = listView1.Items[0].SubItems[0].ForeColor;
            picker.Location = btn_sender.Parent.PointToScreen(new Point(btn_sender.Right, btn_sender.Top));
            clickedSetColorButton = 1;
            if (!picker.Visible)
                picker.Show();
        }

        private void buttonPCYPBackColor_Click(object sender, EventArgs e)
        {
            Button btn_sender = (Button)sender;
            picker.Color = listView1.Items[0].SubItems[0].BackColor;
            picker.Location = btn_sender.Parent.PointToScreen(new Point(btn_sender.Right, btn_sender.Top));
            clickedSetColorButton = 2;
            if (!picker.Visible)
                picker.Show();
        }

        private void buttonPCYPFont_Click(object sender, EventArgs e)
        {
            fontDialog1.Font = favList[selectedIndex].Font;
            if (fontDialog1.ShowDialog() == DialogResult.OK)
            {
                listView1.Items[0].SubItems[0].Font = fontDialog1.Font;
                listView1.Items[0].SubItems[1].Font = fontDialog1.Font;
                listView1.Items[0].SubItems[2].Font = fontDialog1.Font;
                listView1.Items[0].SubItems[3].Font = fontDialog1.Font;
            }
        }

        private void textBoxFavName_KeyUp(object sender, KeyEventArgs e)
        {
            if (listBoxPageList.Items.Count == 0) return;
            listBoxPageList.Items[listBoxPageList.SelectedIndex]
                = textBoxFavName.Text;
        }

        private void buttonAddFav_Click(object sender, EventArgs e)
        {
            FavSetting fav = new FavSetting();
            fav.Name = "Cɓ";
            fav.TextColor = listView1.Items[0].SubItems[0].ForeColor;
            fav.BackColor = listView1.Items[0].SubItems[0].BackColor;
            fav.Font = listView1.Items[0].Font;
            favList.Add(fav);
            listBoxPageList.Items.Add(fav.Name);
            if (listBoxPageList.Items.Count == 1)
            {
                SetValueToGUI(fav);
                listBoxPageList.SelectedIndex = 0;
            }
            else
            {
                listBoxPageList.SelectedIndex = listBoxPageList.Items.Count - 1;
            }
            buttonRemoveFav.Enabled = true;
            SetEnableControls();
        }

        private void buttonRemoveFav_Click(object sender, EventArgs e)
        {
            if (listBoxPageList.SelectedIndex != -1)
            {
                favList.RemoveAt(listBoxPageList.SelectedIndex);
                listBoxPageList.Items.RemoveAt(listBoxPageList.SelectedIndex);
                if (selectedIndex == 0)
                {
                    if (listBoxPageList.Items.Count != 0)
                    {
                        SetValueToGUI(favList[0]);
                        selectedIndex = 0;
                        listBoxPageList.SelectedIndex = 0;
                    }
                }
                else if (listBoxPageList.Items.Count != 0)
                {
                    selectedIndex--;
                    SetValueToGUI(favList[selectedIndex]);
                    listBoxPageList.SelectedIndex = selectedIndex;
                }
                if (listBoxPageList.Items.Count == 0)
                {
                    buttonRemoveFav.Enabled = false;
                }
            }
            SetEnableControls();
        }

        private void buttonInsertString_Click(object sender, EventArgs e)
        {
            contextMenuStripInsertRegex.Show(MousePosition);
        }

        private void toolStripMenuItem2_Click(object sender, EventArgs e)
        {
            textBoxFindText.AppendText(".");
        }

        private void toolStripMenuItem3_Click(object sender, EventArgs e)
        {
            textBoxFindText.AppendText("*");
        }

        private void toolStripMenuItem4_Click(object sender, EventArgs e)
        {
            textBoxFindText.AppendText("+");
        }

        private void toolStripMenuItem6_Click(object sender, EventArgs e)
        {
            textBoxFindText.AppendText("^");
        }

        private void toolStripMenuItem7_Click(object sender, EventArgs e)
        {
            textBoxFindText.AppendText("$");
        }

        private void toolStripMenuItem8_Click(object sender, EventArgs e)
        {
            textBoxFindText.AppendText("<");
        }

        private void toolStripMenuItem9_Click(object sender, EventArgs e)
        {
            textBoxFindText.AppendText(">");
        }

        private void toolStripMenuItem11_Click(object sender, EventArgs e)
        {
            textBoxFindText.Text = "[" + textBoxFindText.Text + "]";
        }

        private void toolStripMenuItem12_Click(object sender, EventArgs e)
        {
            textBoxFindText.Text = "[^" + textBoxFindText.Text + "]";
        }

        private void toolStripMenuItem13_Click(object sender, EventArgs e)
        {
            textBoxFindText.AppendText("|");
        }

        private void toolStripMenuItem15_Click(object sender, EventArgs e)
        {
            textBoxFindText.Text = "{" + textBoxFindText.Text + "}";
        }

        private void sToolStripMenuItem_Click(object sender, EventArgs e)
        {
            textBoxFindText.AppendText(@"\s");
        }

        private void dToolStripMenuItem_Click(object sender, EventArgs e)
        {
            textBoxFindText.AppendText(@"\d");
        }

        private void buttonOK_Click(object sender, EventArgs e)
        {
            Save();
            DialogResult = DialogResult.OK;
            Close();
        }

        private void buttonCancel_Click(object sender, EventArgs e)
        {
            Close();
        }

        private void buttonFavUp_Click(object sender, EventArgs e)
        {
            listBoxPageList.SelectedIndexChanged -= new EventHandler(listBoxPageList_SelectedIndexChanged);

            // ݂̒lۑ
            SetValueToSetting(selectedIndex);
            selectedIndex--;
            // ɂACeޔ
            FavSetting favPrev = (FavSetting)favList[selectedIndex].Clone();
            //@̃CfbNXɑ
            favList[selectedIndex] = (FavSetting)favList[selectedIndex + 1].Clone();
            listBoxPageList.Items[selectedIndex] = favList[selectedIndex].Name;
            favList[selectedIndex + 1] = favPrev;
            listBoxPageList.Items[selectedIndex + 1] = favList[selectedIndex + 1].Name;
            // ListBox̃CfbNX
            listBoxPageList.SelectedIndex = selectedIndex;

            // IꂽACeԏȂA{^𖳌ɂ
            if (listBoxPageList.SelectedIndex == 0) buttonFavUp.Enabled = false;
            else buttonFavUp.Enabled = true;

            // IꂽACeԉȂA{^𖳌ɂ
            if (listBoxPageList.SelectedIndex == favList.Count - 1) buttonFavDown.Enabled = false;
            else buttonFavDown.Enabled = true;

            listBoxPageList.SelectedIndexChanged += new EventHandler(listBoxPageList_SelectedIndexChanged);
        }

        private void buttonFavDown_Click(object sender, EventArgs e)
        {
            listBoxPageList.SelectedIndexChanged -= new EventHandler(listBoxPageList_SelectedIndexChanged);

            // ݂̒lۑ
            SetValueToSetting(selectedIndex);
            selectedIndex++;
            // ɂACeޔ
            FavSetting favPrev = (FavSetting)favList[selectedIndex].Clone();
            //@̃CfbNXɑ
            favList[selectedIndex] = (FavSetting)favList[selectedIndex - 1].Clone();
            listBoxPageList.Items[selectedIndex] = favList[selectedIndex].Name;
            favList[selectedIndex - 1] = favPrev;
            listBoxPageList.Items[selectedIndex - 1] = favList[selectedIndex - 1].Name;
            // ListBox̃CfbNXグ
            listBoxPageList.SelectedIndex = selectedIndex;

            // IꂽACeԏȂA{^𖳌ɂ
            if (listBoxPageList.SelectedIndex == 0) buttonFavUp.Enabled = false;
            else buttonFavUp.Enabled = true;

            // IꂽACeԉȂA{^𖳌ɂ
            if (listBoxPageList.SelectedIndex == favList.Count - 1) buttonFavDown.Enabled = false;
            else buttonFavDown.Enabled = true;

            listBoxPageList.SelectedIndexChanged += new EventHandler(listBoxPageList_SelectedIndexChanged);
        }

        private void textBoxSoundPath_TextChanged(object sender, EventArgs e)
        {
        }

        private void buttonSoundPath_Click(object sender, EventArgs e)
        {
            if (openFileDialog1.ShowDialog() == DialogResult.OK)
            {
                textBoxSoundPath.Text = openFileDialog1.FileName;
            }
        }

        private SoundPlayer sp = new SoundPlayer();

        private void buttonPlayStop_Click(object sender, EventArgs e)
        {
            sp.Stop();
            sp = new SoundPlayer(textBoxSoundPath.Text);
            sp.Play();
        }

        private void buttonCheckRegEx_Click(object sender, EventArgs e)
        {
            try
            {
                Regex regex = new Regex(textBoxFindText.Text);
                MessageBox.Show("K\ɃG[͂܂B");
            }
            catch
            {
                errorProviderRegex.SetError(textBoxFindText, "K\ɃG[܂");
            }
        }

        private void checkBoxEnable_CheckedChanged(object sender, EventArgs e)
        {
            // SetValueToSetting(listBoxPageList.SelectedIndex);
            listBoxPageList.Refresh();
        }
    }
}