using System;
using System.Collections.Generic;
using System.Drawing;
using System.Media;
using System.Windows.Forms;
using System.Windows.Forms.ColorPicker;
using System.Text.RegularExpressions;
using pcmp.Setting;

namespace pcmp.Forms
{
    public partial class FormNGSetting : Form
    {
        public List<NGSetting> ngList;
        private int selectedIndex = 0;

        // ----------------------------------------------------------
        // \bh
        // ----------------------------------------------------------
        public FormNGSetting()
        {
            InitializeComponent();

            NGSetting[] favArray = Settings.NGSettings;
            if (favArray == null) ngList = new List<NGSetting>();
            else ngList = new List<NGSetting>(favArray);
            ListFavorites();
            SetEnableControls();
            if (ngList.Count >= 1)
            {
                SetValueToGUI(ngList[0]);
                listBoxPageList.SelectedIndex = 0;
            }
        }

        private void ListFavorites()
        {
            if (ngList == null) return;

            foreach (NGSetting fav in ngList)
            {
                listBoxPageList.Items.Add(fav.Name);
            }

        }

        private void SetValueToGUI(NGSetting Favorite)
        {
            checkBoxEnable.Checked = Favorite.Enable;
            textBoxFavName.Text = Favorite.Name;
            textBoxFindText.Text = Favorite.SearchString;
            checkBoxFindChannelName.Checked = Favorite.SearchChannelName;
            checkBoxFindDetail.Checked = Favorite.SearchDetail;
            checkBoxFindContactUrl.Checked = Favorite.SearchContactUrl;
            checkBoxFindYpAddr.Checked = Favorite.SearchYelloPageUrl;
            checkBoxUseRegEx.Checked = Favorite.UseRegex;
            checkBoxAllFind.Checked = Favorite.SerachAfterConcat;
            checkBoxFindComment.Checked = Favorite.SearchComment;
        }

        private void SetEnableControls()
        {
            if (listBoxPageList.Items.Count == 0)
            {
                checkBoxEnable.Enabled = false;
                textBoxFavName.Enabled = false;
                textBoxFindText.Enabled = false;
                buttonInsertString.Enabled = false;
                groupBox1.Enabled = false;
                checkBoxUseRegEx.Enabled = false;
                checkBoxAllFind.Enabled = false;
                buttonRemoveFav.Enabled = false;
            }
            else
            {
                checkBoxEnable.Enabled = true;
                textBoxFavName.Enabled = true;
                textBoxFindText.Enabled = true;
                buttonInsertString.Enabled = checkBoxUseRegEx.Checked;
                groupBox1.Enabled = true;
                checkBoxUseRegEx.Enabled = true;
                checkBoxAllFind.Enabled = true;
                buttonRemoveFav.Enabled = true;
            }
        }

        private void SetValueToSetting(int index)
        {
            if (ngList.Count != 0)
            {
                ngList[index].Enable = checkBoxEnable.Checked;
                ngList[index].Name = textBoxFavName.Text;
                ngList[index].SearchString = textBoxFindText.Text;
                ngList[index].SearchChannelName = checkBoxFindChannelName.Checked;
                ngList[index].SearchDetail = checkBoxFindDetail.Checked;
                ngList[index].SearchContactUrl = checkBoxFindContactUrl.Checked;
                ngList[index].SearchYelloPageUrl = checkBoxFindYpAddr.Checked;
                ngList[index].SearchComment = checkBoxFindComment.Checked;
                ngList[index].UseRegex = checkBoxUseRegEx.Checked;
                ngList[index].SerachAfterConcat = checkBoxAllFind.Checked;
            }
        }

        public void AddFavorite(string title)
        {
            NGSetting fav = new NGSetting();
            fav.Name = title;
            fav.SearchString = title;
            ngList.Add(fav);
            if (listBoxPageList.Items.Count == 0) SetValueToGUI(fav);
            listBoxPageList.Items.Add(fav.Name);
            listBoxPageList.SelectedIndex = listBoxPageList.Items.Count - 1;
            buttonRemoveFav.Enabled = true;
            SetEnableControls();
        }

        public void Save()
        {
            if (ngList != null)
            {
                SetValueToSetting(listBoxPageList.SelectedIndex);
                NGSetting.Save(ngList.ToArray());
                Settings.NGSettings = ngList.ToArray();
            }
        }

        // ----------------------------------------------------------
        // Cxg
        // ----------------------------------------------------------
        private void listBoxPageList_SelectedIndexChanged(object sender, EventArgs e)
        {
            if (listBoxPageList.SelectedIndex == -1) return;
            if (listBoxPageList.Items.Count == 0) return;
            SetValueToSetting(selectedIndex);
            NGSetting fav = ngList[listBoxPageList.SelectedIndex];
            SetValueToGUI(fav);
            selectedIndex = listBoxPageList.SelectedIndex;

            // IꂽACeԏȂA{^𖳌ɂ
            if (listBoxPageList.SelectedIndex == 0) buttonFavUp.Enabled = false;
            else buttonFavUp.Enabled = true;

            // IꂽACeԉȂA{^𖳌ɂ
            if (listBoxPageList.SelectedIndex == ngList.Count - 1) buttonFavDown.Enabled = false;
            else buttonFavDown.Enabled = true;
        }

        private void checkBoxUseRegEx_CheckedChanged(object sender, EventArgs e)
        {
            buttonInsertString.Enabled = checkBoxUseRegEx.Checked;
            buttonCheckRegEx.Enabled = checkBoxUseRegEx.Checked;
        }

        private void textBoxFavName_KeyUp(object sender, KeyEventArgs e)
        {
            if (listBoxPageList.Items.Count == 0) return;
            listBoxPageList.Items[listBoxPageList.SelectedIndex]
                = textBoxFavName.Text;
        }

        private void buttonAddFav_Click(object sender, EventArgs e)
        {
            NGSetting fav = new NGSetting();
            fav.Name = "NG";
            ngList.Add(fav);
            listBoxPageList.Items.Add(fav.Name);
            if (listBoxPageList.Items.Count == 1)
            {
                SetValueToGUI(fav);
                listBoxPageList.SelectedIndex = 0;
            }
            else
            {
                listBoxPageList.SelectedIndex = listBoxPageList.Items.Count - 1;
            }
            buttonRemoveFav.Enabled = true;
            SetEnableControls();
        }

        private void buttonRemoveFav_Click(object sender, EventArgs e)
        {
            if (listBoxPageList.SelectedIndex != -1)
            {
                ngList.RemoveAt(listBoxPageList.SelectedIndex);
                listBoxPageList.Items.RemoveAt(listBoxPageList.SelectedIndex);
                if (selectedIndex == 0)
                {
                    if (listBoxPageList.Items.Count != 0)
                    {
                        SetValueToGUI(ngList[0]);
                        selectedIndex = 0;
                        listBoxPageList.SelectedIndex = 0;
                    }
                }
                else if (listBoxPageList.Items.Count != 0)
                {
                    selectedIndex--;
                    SetValueToGUI(ngList[selectedIndex]);
                    listBoxPageList.SelectedIndex = selectedIndex;
                }
                if (listBoxPageList.Items.Count == 0)
                {
                    buttonRemoveFav.Enabled = false;
                }
            }
            SetEnableControls();
        }

        private void buttonInsertString_Click(object sender, EventArgs e)
        {
            contextMenuStripInsertRegex.Show(MousePosition);
        }

        private void toolStripMenuItem2_Click(object sender, EventArgs e)
        {
            textBoxFindText.AppendText(".");
        }

        private void toolStripMenuItem3_Click(object sender, EventArgs e)
        {
            textBoxFindText.AppendText("*");
        }

        private void toolStripMenuItem4_Click(object sender, EventArgs e)
        {
            textBoxFindText.AppendText("+");
        }

        private void toolStripMenuItem6_Click(object sender, EventArgs e)
        {
            textBoxFindText.AppendText("^");
        }

        private void toolStripMenuItem7_Click(object sender, EventArgs e)
        {
            textBoxFindText.AppendText("$");
        }

        private void toolStripMenuItem8_Click(object sender, EventArgs e)
        {
            textBoxFindText.AppendText("<");
        }

        private void toolStripMenuItem9_Click(object sender, EventArgs e)
        {
            textBoxFindText.AppendText(">");
        }

        private void toolStripMenuItem11_Click(object sender, EventArgs e)
        {
            textBoxFindText.Text = "[" + textBoxFindText.Text + "]";
        }

        private void toolStripMenuItem12_Click(object sender, EventArgs e)
        {
            textBoxFindText.Text = "[^" + textBoxFindText.Text + "]";
        }

        private void toolStripMenuItem13_Click(object sender, EventArgs e)
        {
            textBoxFindText.AppendText("|");
        }

        private void toolStripMenuItem15_Click(object sender, EventArgs e)
        {
            textBoxFindText.Text = "{" + textBoxFindText.Text + "}";
        }

        private void sToolStripMenuItem_Click(object sender, EventArgs e)
        {
            textBoxFindText.AppendText(@"\s");
        }

        private void dToolStripMenuItem_Click(object sender, EventArgs e)
        {
            textBoxFindText.AppendText(@"\d");
        }

        private void buttonOK_Click(object sender, EventArgs e)
        {
            Save();
            DialogResult = DialogResult.OK;
            Close();
        }

        private void buttonCancel_Click(object sender, EventArgs e)
        {
            Close();
        }

        private void buttonFavUp_Click(object sender, EventArgs e)
        {
            listBoxPageList.SelectedIndexChanged -= new EventHandler(listBoxPageList_SelectedIndexChanged);

            // ݂̒lۑ
            SetValueToSetting(selectedIndex);
            selectedIndex--;
            // ɂACeޔ
            NGSetting favPrev = (NGSetting)ngList[selectedIndex].Clone();
            //@̃CfbNXɑ
            ngList[selectedIndex] = (NGSetting)ngList[selectedIndex + 1].Clone();
            listBoxPageList.Items[selectedIndex] = ngList[selectedIndex].Name;
            ngList[selectedIndex + 1] = favPrev;
            listBoxPageList.Items[selectedIndex + 1] = ngList[selectedIndex + 1].Name;
            // ListBox̃CfbNX
            listBoxPageList.SelectedIndex = selectedIndex;

            // IꂽACeԏȂA{^𖳌ɂ
            if (listBoxPageList.SelectedIndex == 0) buttonFavUp.Enabled = false;
            else buttonFavUp.Enabled = true;

            // IꂽACeԉȂA{^𖳌ɂ
            if (listBoxPageList.SelectedIndex == ngList.Count - 1) buttonFavDown.Enabled = false;
            else buttonFavDown.Enabled = true;

            listBoxPageList.SelectedIndexChanged += new EventHandler(listBoxPageList_SelectedIndexChanged);
        }

        private void buttonFavDown_Click(object sender, EventArgs e)
        {
            listBoxPageList.SelectedIndexChanged -= new EventHandler(listBoxPageList_SelectedIndexChanged);

            // ݂̒lۑ
            SetValueToSetting(selectedIndex);
            selectedIndex++;
            // ɂACeޔ
            NGSetting favPrev = (NGSetting)ngList[selectedIndex].Clone();
            //@̃CfbNXɑ
            ngList[selectedIndex] = (NGSetting)ngList[selectedIndex - 1].Clone();
            listBoxPageList.Items[selectedIndex] = ngList[selectedIndex].Name;
            ngList[selectedIndex - 1] = favPrev;
            listBoxPageList.Items[selectedIndex - 1] = ngList[selectedIndex - 1].Name;
            // ListBox̃CfbNXグ
            listBoxPageList.SelectedIndex = selectedIndex;

            // IꂽACeԏȂA{^𖳌ɂ
            if (listBoxPageList.SelectedIndex == 0) buttonFavUp.Enabled = false;
            else buttonFavUp.Enabled = true;

            // IꂽACeԉȂA{^𖳌ɂ
            if (listBoxPageList.SelectedIndex == ngList.Count - 1) buttonFavDown.Enabled = false;
            else buttonFavDown.Enabled = true;

            listBoxPageList.SelectedIndexChanged += new EventHandler(listBoxPageList_SelectedIndexChanged);
        }

        private void textBoxSoundPath_TextChanged(object sender, EventArgs e)
        {
        }

        private void buttonCheckRegEx_Click(object sender, EventArgs e)
        {
            try
            {
                Regex regex = new Regex(textBoxFindText.Text);
                MessageBox.Show("K\ɃG[͂܂B");
            }
            catch
            {
                errorProviderRegex.SetError(textBoxFindText, "K\ɃG[܂");
            }
        }

        private void checkBoxEnable_CheckedChanged(object sender, EventArgs e)
        {
            // SetValueToSetting(listBoxPageList.SelectedIndex);
            listBoxPageList.Refresh();
        }
    }
}