using System;
using System.Collections.Generic;
using System.Windows.Forms;
using System.Drawing;
using pcmp.Setting;

namespace pcmp.Forms
{
    public partial class FormPlayerSetting : Form
    {
        private List<PlayerSetting> playerList;

        public FormPlayerSetting()
        {
            InitializeComponent();

            PlayerSetting[] typeArray = Settings.PlayerSettings;
            if (typeArray != null && typeArray.Length != 0) playerList = new List<PlayerSetting>(typeArray);
            ListTypes();
        }

        #region \bh

        // XgAbv
        private void ListTypes()
        {
            if (playerList != null)
            {
                listViewTypes.Items.Clear();
                foreach (PlayerSetting type in playerList)
                {
                    ListViewItem item = CreateListViewItem(type);
                    listViewTypes.Items.Add(item);
                }
            }
            else
            {
            }
        }

        public void Save()
        {
            playerList = new List<PlayerSetting>();
            foreach (ListViewItem item in listViewTypes.Items)
            {
                PlayerSetting type = new PlayerSetting();
                type.Type = item.SubItems[1].Text;
                type.Path = item.SubItems[2].Text;
                type.Argument = item.SubItems[3].Text;
                playerList.Add(type);
            }

            if (playerList != null)
            {
                PlayerSetting.Save(playerList.ToArray());
                Settings.PlayerSettings = playerList.ToArray();
            }
        }

        private ListViewItem CreateListViewItem(PlayerSetting playType)
        {
            ListViewItem item = new ListViewItem();
            item.SubItems.Add(playType.Type);
            item.SubItems.Add(playType.Path);
            item.SubItems.Add(playType.Argument);
            return item;
        }

        #endregion

        #region Cxg

        private void buttonAddType_Click(object sender, EventArgs e)
        {
            ListViewItem item = (ListViewItem)listViewTypes.Items[0].Clone();
            item.SubItems[1].Text = "^Cv";
            listViewTypes.Items.Add(item);
        }

        private void buttonRemoveType_Click(object sender, EventArgs e)
        {
            if (listViewTypes.SelectedItems != null)
                listViewTypes.Items.RemoveAt(listViewTypes.SelectedIndices[0]);
            buttonApply.Enabled = false;
        }

        private void listViewTypes_SelectedIndexChanged(object sender, EventArgs e)
        {
            if (listViewTypes.SelectedItems == null || listViewTypes.SelectedItems.Count == 0)
                return;

            ListViewItem item = listViewTypes.SelectedItems[0];
            if (item.SubItems[1].Text == "ftHg")
            {
                buttonRemoveType.Enabled = false;
                textBoxType.ReadOnly = true;
            }
            else
            {
                textBoxType.ReadOnly = false;
                buttonRemoveType.Enabled = true;
            }

            textBoxType.Text = item.SubItems[1].Text;
            textBoxPlayerPath.Text = item.SubItems[2].Text;
            comboBoxArg.Text = item.SubItems[3].Text;
            buttonApply.Enabled = true;

        }

        private void buttonApply_Click(object sender, EventArgs e)
        {
            if (listViewTypes.SelectedItems == null || listViewTypes.SelectedItems.Count == 0)
                return;

            if (listViewTypes.SelectedIndices[0] != 0)
            {
                if (textBoxType.Text == "ftHg")
                {
                    MessageBox.Show("^Cv ftHg ͎gpł܂", "x",
                                    MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
                    textBoxType.Select();
                    textBoxType.SelectAll();
                    return;
                }
            }
            listViewTypes.SelectedItems[0].SubItems[1].Text = textBoxType.Text;
            listViewTypes.SelectedItems[0].SubItems[2].Text = textBoxPlayerPath.Text;
            listViewTypes.SelectedItems[0].SubItems[3].Text = comboBoxArg.Text;
        }

        private void buttonFileRef_Click(object sender, EventArgs e)
        {
            if (openFileDialog1.ShowDialog() == DialogResult.OK)
            {
                textBoxPlayerPath.Text = openFileDialog1.FileName;
            }
        }

        private void buttonOK_Click(object sender, EventArgs e)
        {
            Save();
            DialogResult = DialogResult.OK;
            Close();
        }

        private void buttonCancel_Click(object sender, EventArgs e)
        {
            Close();
        }

        #endregion

        private void listViewTypes_DrawSubItem(object sender, DrawListViewSubItemEventArgs e)
        {
            TextFormatFlags formatFlag;
            if (e.ColumnIndex != 2)
                formatFlag = TextFormatFlags.Left;
            else formatFlag = TextFormatFlags.Left | TextFormatFlags.PathEllipsis | TextFormatFlags.SingleLine;

            if ((e.ItemState & ListViewItemStates.Selected) == 0)
            {
                e.DrawBackground();
                TextRenderer.DrawText(e.Graphics, e.SubItem.Text, listViewTypes.Font,
                e.Bounds, listViewTypes.ForeColor, listViewTypes.BackColor,formatFlag);
                return;
            }

            e.Graphics.FillRectangle(new SolidBrush(Color.FromKnownColor(KnownColor.Highlight)),
                e.Bounds);
            TextRenderer.DrawText(e.Graphics, e.SubItem.Text, listViewTypes.Font,
                e.Bounds, Color.FromKnownColor(KnownColor.HighlightText), Color.FromKnownColor(KnownColor.Highlight),
                formatFlag);
        }

        private void listViewTypes_DrawColumnHeader(object sender, DrawListViewColumnHeaderEventArgs e)
        {
            e.DrawDefault = true;
        }

        private void listViewTypes_DrawItem(object sender, DrawListViewItemEventArgs e)
        {
            //e.DrawDefault = true;
        }
    }
}