﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.IO;
using System.Windows.Forms;
using System.Media;

namespace pcmp.Forms
{
    public partial class FormShowFavorite : Form
    {
        int _index = 0;
        List<Channel> FavList;
        SoundPlayer sp = new SoundPlayer();
        FormChannelList frmchlist;

        public FormShowFavorite(FormChannelList f)
        {
            frmchlist = f;
            Application.Idle += new EventHandler(Application_Idle);
        }

        void Application_Idle(object sender, EventArgs e)
        {
            Application.Idle -= new EventHandler(Application_Idle);
            InitializeComponent();
        }

        public void ShowFavorites(List<Channel> favlist)
        {
            if (favlist.Count == 0) return;
            FavList = favlist;
            ShowFavorite(0);
            Size s = Screen.PrimaryScreen.WorkingArea.Size;
            this.Location = new Point(s.Width - 30 - this.Width, s.Height - 30 - this.Height);
            this.Show();
            timer1.Start();
        }

        private void timer1_Tick(object sender, EventArgs e)
        {
            if (_index < FavList.Count - 1)
            {
                ShowFavorite(++_index);
            }
            else if(_index == FavList.Count -1)
            {
                this.Hide();
            }
        }

        private void ShowFavorite(int index)
        {
            _index = index;
            buttonBack.Enabled = !(index == 0);
            buttonForward.Enabled = !(index == FavList.Count - 1);
            sp.Stop();

            if (!string.IsNullOrEmpty(FavList[index].Sound) && File.Exists(FavList[index].Sound))
            {
                sp.SoundLocation = FavList[index].Sound;
                try
                {
                    sp.Play();
                }
                catch { }
            }
            labelChannel.Text = string.Format("{0} ({1})", FavList[index].ChannelName, FavList[index].Status.ToString());
            labelDetail.Text = FavList[index].Detail;
            labelIndex.Text = string.Format("({0}/{1})", index + 1, FavList.Count);
            labelTimeBitrate.Text = string.Format("{0} - {1}", FavList[index].Time.ToString(), FavList[index].BitRate.ToString());
        }

        private void buttonBack_Click(object sender, EventArgs e)
        {
            if(_index != 0) ShowFavorite(_index - 1);
            timer1.Stop();
        }

        private void buttonForward_Click(object sender, EventArgs e)
        {
            if (_index != FavList.Count - 1) ShowFavorite(_index + 1);
            timer1.Stop();
        }

        private void buttonClose_Click(object sender, EventArgs e)
        {
            timer1.Stop();
            this.Hide();
        }

        private void buttonPlay_Click(object sender, EventArgs e)
        {
            frmchlist.PlayChannel(FavList[_index]);
        }
    }
}
