using System;
using System.Collections.Generic;
using System.Text;
using System.Runtime.InteropServices;

namespace pcmp
{
    internal static class PCRaw
    {
        [DllImport("pcraw.dll", CharSet = CharSet.Ansi)]
        public static extern IntPtr PCRawCreate(string url);

        [DllImport("pcraw.dll")]
        public static extern void PCRawClose(IntPtr handle);

        [DllImport("pcraw.dll")]
        public static extern int PCRawGetLength(IntPtr handle);

        [DllImport("pcraw.dll", CharSet = CharSet.Ansi)]
        public static extern int PCRawGetData(IntPtr handle, [Out] byte[] buf, int len);

        [DllImport("pcraw.dll")]
        public static extern int PCRawGetLastError(IntPtr handle);

        [DllImport("pcraw.dll")]
        public static extern uint PCRawGetUpdateTime(IntPtr handle);

        [DllImport("pcraw.dll")]
        public static extern void PCRawDataLock(IntPtr handle);

        [DllImport("pcraw.dll")]
        public static extern void PCRawDataUnlock(IntPtr handle);

        [DllImport("pcraw.dll")]
        public static extern int PCRawCheckVersion(ref uint lpVersion, uint dwAssumedVersion);

        /// <summary>
        /// t_timeDateTime֕ϊ
        /// </summary>
        /// <param name="t_time">ϊt_time</param>
        /// <returns>ϊꂽDateTimeIuWFNg</returns>
        public static DateTime t_timeToDateTime(uint t_time)
        {
            return new DateTime(1970, 1, 1, 0, 0, 0).AddSeconds(t_time);
        }
    }
}
