using System;
using System.Collections.Generic;
using System.Text;
using System.Diagnostics;
using System.IO;
using pcmp.Setting;

namespace pcmp
{
    public static class PeerCast
    {
        /// <summary>
        /// PeerCastN
        /// </summary>
        public static void StartPeerCast()
        {
            Process p = new Process();
            p.StartInfo.FileName = Settings.GeneralSetting.PeerCastPath;
            p.StartInfo.WorkingDirectory = Path.GetDirectoryName(Settings.GeneralSetting.PeerCastPath);
            if (Settings.GeneralSetting.UseMultiOption) p.StartInfo.Arguments = "-multi";

            try
            {
                p.Start();
            }
            catch (FileNotFoundException) { }
            catch (ArgumentException) { }
            catch { }

            p.Dispose();
        }

        /// <summary>
        /// PeerCastI
        /// </summary>
        public static void KillPeerCast(string path)
        {
            Process p = new Process();
            p.StartInfo.FileName = path;
            p.StartInfo.WorkingDirectory = Path.GetDirectoryName(path);
            p.StartInfo.Arguments = "-kill";
            try
            {
                p.Start();
            }
            catch (ArgumentException) { }
            catch (ObjectDisposedException) { }
            catch { }

            p.Dispose();
        }

        public static bool CheckPeerCastProcess()
        {
            Process[] proc = Process.GetProcessesByName(Path.GetFileNameWithoutExtension(Settings.GeneralSetting.PeerCastPath));
            if (proc.Length > 0) return true;
            else return false;
        }
    }
}
