using System;
using System.Collections.Generic;
using System.Text;
using System.Runtime.Serialization;

namespace pcmp.Setting
{
    [Serializable]
    public class PlayerSetting : SerializableSetting
    {
        public PlayerSetting() { }

        public PlayerSetting(SerializationInfo info, StreamingContext context)
        {
            Serializer.Deserialize(this, info);
        }

        const string fileName = "PlayerSetting.xml";
        public static void Save(PlayerSetting[] favSettingList)
        {
            Serializer.Serialize(fileName, favSettingList, true);
        }

        public static PlayerSetting[] Load()
        {
            PlayerSetting[] obj =
                Serializer.Deserialize(fileName, typeof(PlayerSetting[])) as PlayerSetting[];
            return obj;
        }

        public string Type = string.Empty;
        public string Path = string.Empty;
        public string Argument = "<stream /> <channelname />";
    }
}
