using System;
using System.IO;
using System.Windows.Forms;
using System.Runtime.Serialization.Formatters.Soap;
using System.Runtime.Serialization;
using System.Reflection;
using System.Diagnostics;

namespace pcmp.Setting
{
    public static class Serializer
    {
        public static void Serialize(string file, object saveObj, bool filenameonly)
        {
            Trace.WriteLine("ݒ̕ۑJn : " + file);

            if (saveObj == null) throw new ArgumentNullException();
            if (filenameonly)
            {
                file = Path.Combine(Application.StartupPath, "Config\\" + file);
                if (!Directory.Exists(Path.GetDirectoryName(file)))
                    Directory.CreateDirectory(Path.GetDirectoryName(file));
            }
            FileStream fs = null;
            try
            {
                SoapFormatter soapFormatter = new SoapFormatter();
                fs = new FileStream(file, FileMode.Create);
                soapFormatter.Serialize(fs, saveObj);
                Trace.WriteLine("ݒ̕ۑ : " + file);
            }
            catch (Exception ex)
            {
                Trace.WriteLine(ex.Message);
                Trace.WriteLine("ݒ̕ۑs : " + file);
            }
            finally
            {
                if (fs != null) fs.Close();
            }
        }

        public static void Serialize(Object obj, SerializationInfo info)
        {
            FieldInfo[] fields = obj.GetType().GetFields(BindingFlags.Instance | BindingFlags.Public);
            foreach (FieldInfo fi in fields)
            {
                if (fi.GetCustomAttributes(typeof(NonSerializedAttribute), false).Length != 0) continue;
                try
                {
                    object data = fi.GetValue(obj);
                    info.AddValue(fi.Name, data);
                }
                catch (Exception)
                {
                }
            }
        }

        public static object Deserialize(string file, Type objType)
        {
            Trace.WriteLine("ݒ̓ǂݍ݊Jn : " + file);
            string fileName = Path.Combine(Application.StartupPath, "Config\\" + file);
            FileStream fs = null;
            Object obj = null;
            try
            {
                SoapFormatter sf = new SoapFormatter();
                fs = new FileStream(fileName, FileMode.Open);
                obj = sf.Deserialize(fs);
                Trace.WriteLine("ݒ̓ǂݍݐ : " + file);
            }
            catch (Exception ex)
            {
                Trace.WriteLine(ex.Message);
                Trace.WriteLine("ݒ̓ǂݍݎs : " + file);
                return null;
            }
            finally
            {
                if (fs != null) fs.Close();
            }
            return obj;
        }

        public static void Deserialize(object obj, SerializationInfo info)
        {
            FieldInfo[] fields = obj.GetType().GetFields(BindingFlags.Public | BindingFlags.Instance);
            foreach (FieldInfo fi in fields)
            {
                if (fi.GetCustomAttributes(typeof(NonSerializedAttribute), false).Length != 0) continue;
                try
                {
                    object data = info.GetValue(fi.Name, fi.FieldType);
                    fi.SetValue(obj, data);
                }
                catch (Exception)
                {
                }
            }
        }
    }
}
