using System;
using System.Collections.Generic;
using System.Text;
using System.Diagnostics;

namespace pcmp.Setting
{
    internal static class Settings
    {
        private static YpSetting[] _ypSettings = null;

        internal static YpSetting[] YpSettings
        {
            get { return Settings._ypSettings; }
            set { _ypSettings = value; }
        }

        private static FavSetting[] _favSettings = null;

        internal static FavSetting[] FavSettings
        {
            get { return Settings._favSettings; }
            set { _favSettings = value; }
        }

        private static NGSetting[] _ngSettings = null;

        internal static NGSetting[] NGSettings
        {
            get { return Settings._ngSettings; }
            set { _ngSettings = value; }
        }

        private static PlayerSetting[] _playerSettings = null;

        internal static PlayerSetting[] PlayerSettings
        {
            get { return Settings._playerSettings; }
            set { _playerSettings = value; }
        }

        private static GeneralSetting _generalSetting = null;

        internal static GeneralSetting GeneralSetting
        {
            get { return Settings._generalSetting; }
            set { _generalSetting = value; }
        }

        private static TabSetting[] _tabSettings = null;

        internal static TabSetting[] TabSettings
        {
            get { return _tabSettings; }
            set { _tabSettings = value; }
        }

        private static ApplicationSetting _applicationSetting = null;

        internal static ApplicationSetting ApplicationSetting
        {
            get { return _applicationSetting; }
            set { _applicationSetting = value; }
        }

        internal static void LoadYpSetting()
        {
            Settings._ypSettings = YpSetting.Load();
        }

        internal static void LoadFavSetting()
        {
            Settings._favSettings = FavSetting.Load();
            if (Settings._favSettings == null)
                Settings._favSettings = new FavSetting[0];
        }

        internal static void LoadPlayerSetting()
        {
            Settings._playerSettings = PlayerSetting.Load();
        }

        internal static void LoadGeneralSetting()
        {
            Settings._generalSetting = GeneralSetting.Load();
            if (Settings._generalSetting == null)
                Settings._generalSetting = new GeneralSetting();
        }

        internal static void LoadTabSetting()
        {
            Settings._tabSettings = TabSetting.Load();
            if (Settings._tabSettings == null)
                Settings._tabSettings = new TabSetting[0];
        }

        internal static void LoadApplicationSetting()
        {
            _applicationSetting = ApplicationSetting.Load();
        }

        internal static void LoadNGSetting()
        {
            _ngSettings = NGSetting.Load();
            if (_ngSettings == null)
                _ngSettings = new NGSetting[0];
        }

        internal static YpSetting FindYpSetting(string name)
        {
            if (_ypSettings == null) return null;
            foreach (YpSetting yp in _ypSettings)
            {
                if (yp.YpName == name) return yp;
            }
            return null;
        }
    }
}
