using System;
using System.Collections.Generic;
using System.Text;
using System.Runtime.Serialization;

namespace pcmp.Setting
{
    [Serializable]
    public class TabSetting : ICloneable
    {
        const string fileName = "TabSetting.xml";

        public TabSetting() { }

        public TabSetting(SerializationInfo info, StreamingContext context)
        {
            Serializer.Deserialize(this, info);
        }

        public static void Save(TabSetting[] target)
        {
            Serializer.Serialize(fileName, target, true);
        }

        public static TabSetting[] Load()
        {
            TabSetting[] obj =
                Serializer.Deserialize(fileName, typeof(TabSetting[])) as TabSetting[];
            return obj;
        }

        #region ICloneable o

        public object Clone()
        {
            return this.MemberwiseClone();
        }

        #endregion

        public string Name = "tB^";
        public string Condition = ".";
        public bool CheckChannel = true;
        public bool CheckComment = true;
        public bool CheckGenre = true;
        public bool CheckPlaying = true;
        public bool CheckType = true;
        public bool CheckContact = true;
        public bool CheckYpName = true;
        public bool CheckYpUrl = true;
        public bool UseRegex = true;
        public bool Enable = true;
        public int ChannelType = 0;
        public bool IgnoreCase = true;
        public bool ConcatAllStrings = false;
        public bool CheckAllYp;
        public bool CheckBitrate = false;
        public string Bitrate = "0-";
        public TargetYPSetting[] TargetYpList = new TargetYPSetting[0];
    }

    [Serializable]
    public class TargetYPSetting
    {
        public TargetYPSetting() { }

        public TargetYPSetting(SerializationInfo info, StreamingContext context)
        {
            Serializer.Deserialize(this, info);
        }

        public TargetYPSetting(string name, bool isTarget)
        {
            YPName = name;
            IsTargetYP = isTarget;
        }

        public bool IsTargetYP;
        public string YPName;

        public static bool CheckYP(Channel item, TargetYPSetting[] list)
        {
            foreach (TargetYPSetting typ in list)
            {
                if (!typ.IsTargetYP) continue;
                if (item.YPName == typ.YPName) return true;
            }
            return false;
        }

        public static bool CheckYP(string ypname, TargetYPSetting[] list)
        {
            foreach(TargetYPSetting typ in list)
            {
                if (!typ.IsTargetYP) continue;
                if (ypname == typ.YPName) return true;
            }
            return false;
        }
    }
}
