using System;
using System.Collections.Generic;
using System.Text;
using System.Runtime.Serialization;

namespace pcmp.Setting
{
    [Serializable()]
    public class ToolSetting : SerializableSetting
    {
        public ToolSetting() { }

        public ToolSetting(SerializationInfo info, StreamingContext context)
        {
            Serializer.Deserialize(this, info);
        }

        public static void Save(ToolSetting[] target)
        {
            Serializer.Serialize("Tools.xml", target, true);
        }

        public static ToolSetting[] Load()
        {
            ToolSetting[] obj =
                Serializer.Deserialize("Tools.xml", typeof(ToolSetting[])) as ToolSetting[];
            return obj;
        }

        public string Name = string.Empty;
        public string Path = string.Empty;
        public string Argument = string.Empty;
        public int Type = 0; // 0:Executable 1:PythonScript
    }
}
