/*
 * Peercast4jView.java
 */
package peercast4j;

import java.net.MalformedURLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jdesktop.application.Action;
import org.jdesktop.application.SingleFrameApplication;
import org.jdesktop.application.FrameView;
import java.net.URL;
import javax.swing.JDialog;
import javax.swing.JFrame;
import peercast4j.core.BuildChannelDataTableThread;

/**
 * The application's main frame.
 */
public class Peercast4jView extends FrameView {

    public Peercast4jView(SingleFrameApplication app) {
        super(app);

        getChannels();
        initComponents();

    }

    @Action
    public void showAboutBox() {
        if (aboutBox == null) {
            JFrame mainFrame = Peercast4jApp.getApplication().getMainFrame();
            aboutBox = new Peercast4jAboutBox(mainFrame);
            aboutBox.setLocationRelativeTo(mainFrame);
        }
        Peercast4jApp.getApplication().show(aboutBox);
    }
    BuildChannelDataTableThread buildChannelDataTableThread;

    private void getChannels() {
        try {
            buildChannelDataTableThread = new BuildChannelDataTableThread(new URL[]{new URL("http://localhost:8080/http://extremeyp.ath.cx/index.txt")});
            buildChannelDataTableThread.start();
        } catch (MalformedURLException ex) {
            Logger.getLogger(Peercast4jView.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        mainPanel = new javax.swing.JPanel();
        mainTab = new javax.swing.JTabbedPane();
        jScrollPane1 = new javax.swing.JScrollPane();
        mainTable = new javax.swing.JTable();
        menuBar = new javax.swing.JMenuBar();
        javax.swing.JMenu fileMenu = new javax.swing.JMenu();
        javax.swing.JMenuItem exitMenuItem = new javax.swing.JMenuItem();
        javax.swing.JMenu jMenu1 = new javax.swing.JMenu();
        javax.swing.JMenuItem jMenuItem1 = new javax.swing.JMenuItem();
        javax.swing.JMenu helpMenu = new javax.swing.JMenu();
        javax.swing.JMenuItem aboutMenuItem = new javax.swing.JMenuItem();

        mainPanel.setName("mainPanel"); // NOI18N
        mainPanel.setPreferredSize(new java.awt.Dimension(800, 600));

        mainTab.setName("mainTab"); // NOI18N
        mainTab.setPreferredSize(new java.awt.Dimension(800, 600));

        jScrollPane1.setName("jScrollPane1"); // NOI18N
        jScrollPane1.setPreferredSize(new java.awt.Dimension(800, 600));

        //カスタムモデルをセットするために、別スレッドの終了を待つ
        try {
            buildChannelDataTableThread.join();
        } catch (Exception e) {
            e.printStackTrace();
        }
        mainTable.setAutoCreateRowSorter(true);
        mainTable.setModel(new peercast4j.core.ChannelTable() {
            public int getRowCount() {
                return buildChannelDataTableThread.get().length;
            }

            public Object getValueAt(int rowIndex, int columnIndex) {
                return buildChannelDataTableThread.get()[rowIndex].get(columnIndex);
            }
        }
    );
    mainTable.setAutoResizeMode(javax.swing.JTable.AUTO_RESIZE_OFF);
    mainTable.setName("mainTable"); // NOI18N
    mainTable.setPreferredSize(new java.awt.Dimension(800, 600));
    jScrollPane1.setViewportView(mainTable);

    org.jdesktop.application.ResourceMap resourceMap = org.jdesktop.application.Application.getInstance(peercast4j.Peercast4jApp.class).getContext().getResourceMap(Peercast4jView.class);
    mainTab.addTab(resourceMap.getString("jScrollPane1.TabConstraints.tabTitle"), jScrollPane1); // NOI18N

    javax.swing.GroupLayout mainPanelLayout = new javax.swing.GroupLayout(mainPanel);
    mainPanel.setLayout(mainPanelLayout);
    mainPanelLayout.setHorizontalGroup(
        mainPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
        .addComponent(mainTab, javax.swing.GroupLayout.DEFAULT_SIZE, 500, Short.MAX_VALUE)
    );
    mainPanelLayout.setVerticalGroup(
        mainPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
        .addComponent(mainTab, javax.swing.GroupLayout.DEFAULT_SIZE, 479, Short.MAX_VALUE)
    );

    menuBar.setName("menuBar"); // NOI18N

    fileMenu.setText(resourceMap.getString("fileMenu.text")); // NOI18N
    fileMenu.setName("fileMenu"); // NOI18N

    javax.swing.ActionMap actionMap = org.jdesktop.application.Application.getInstance(peercast4j.Peercast4jApp.class).getContext().getActionMap(Peercast4jView.class, this);
    exitMenuItem.setAction(actionMap.get("quit")); // NOI18N
    exitMenuItem.setName("exitMenuItem"); // NOI18N
    fileMenu.add(exitMenuItem);

    menuBar.add(fileMenu);

    jMenu1.setText(resourceMap.getString("jMenu1.text")); // NOI18N
    jMenu1.setName("jMenu1"); // NOI18N

    jMenuItem1.setAction(actionMap.get("showYPSettingsBox")); // NOI18N
    jMenuItem1.setAccelerator(javax.swing.KeyStroke.getKeyStroke(java.awt.event.KeyEvent.VK_Y, java.awt.event.InputEvent.CTRL_MASK));
    jMenuItem1.setText(resourceMap.getString("jMenuItem1.text")); // NOI18N
    jMenuItem1.setName("jMenuItem1"); // NOI18N
    jMenu1.add(jMenuItem1);

    menuBar.add(jMenu1);

    helpMenu.setText(resourceMap.getString("helpMenu.text")); // NOI18N
    helpMenu.setName("helpMenu"); // NOI18N

    aboutMenuItem.setAction(actionMap.get("showAboutBox")); // NOI18N
    aboutMenuItem.setName("aboutMenuItem"); // NOI18N
    helpMenu.add(aboutMenuItem);

    menuBar.add(helpMenu);

    setComponent(mainPanel);
    setMenuBar(menuBar);
    }// </editor-fold>//GEN-END:initComponents
    @Action
    public void showYPSettingsBox() {
        if (ypSettingsBox == null) {
            JFrame mainFrame = Peercast4jApp.getApplication().getMainFrame();
            ypSettingsBox = new Peercast4jYPSettingBox(mainFrame);
            ypSettingsBox.setLocationRelativeTo(mainFrame);
        }
        Peercast4jApp.getApplication().show(ypSettingsBox);
    }

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JPanel mainPanel;
    private javax.swing.JTabbedPane mainTab;
    private javax.swing.JTable mainTable;
    private javax.swing.JMenuBar menuBar;
    // End of variables declaration//GEN-END:variables
    private JDialog aboutBox;
    private JDialog ypSettingsBox;
}
