/*
 * Copyright 2008 nori090
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.coderepos.nori090.lib2chj;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;

/**
 * @author nori090
 * @version $Rev: 85 $ $Date: 2008-06-02 22:18:54 +0900 (Mon, 02 Jun 2008) $
 */
public class ServerImpl
    implements Server {

    private HashMap<String, String> self = new LinkedHashMap<String, String>();

    private LinkedHashMap<String, Ita> v1 = new LinkedHashMap<String, Ita>();

    private LinkedHashMap<String, Ita> v2 = new LinkedHashMap<String, Ita>();

    @Override
    public Server addIta( Ita ita ) {
        v1.put( ita.getItaName(), ita );
        v2.put( ita.getItaName_ja(), ita );
        return this;
    }

    @Override
    public Ita getIta( String key ) {
        Ita ita = v1.get( key );
        return ita != null ? ita : v2.get( key );
    }

    @Override
    public List<Ita> getItaList() {
        ArrayList<Ita> list = new ArrayList<Ita>();
        for ( Ita ita : v1.values() ) {
            list.add( ita );
        }
        return list;
    }

    @Override
    public String getServerName() {
        return self.get( "name" );
    }

    @Override
    public Server setItaList( List<Ita> itaList ) {
        for ( Ita ita : itaList ) {
            addIta( ita );
        }
        return this;
    }

    @Override
    public Server setServerName( String serverName ) {
        self.put( "name", serverName );
        return this;
    }
}
