/*
 * scancode.cpp
 *
 *  Created on: 2009/09/22
 *      Author: uchan
 */

#include <bitnos/scancode.h>

const uint8_t ScanCode::tableMod[128] =
{
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,'<' ,'=' ,'>' ,'?' ,
    0xff,'!' ,'"' ,'#' ,'$' ,'%' ,'&' ,'\'','(' ,')' ,'*' ,'+' ,0x00,0x00,0x00,0x00,
    '`' ,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,'{' ,'|' ,'}' ,'~' ,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
};

int ScanCode::ToAscii(Code code, bool mod)
{
  int result = 0;
  int keyCode = code.code;
  keyCode &= ~ScanCode::Keys::FlagKeypad;
  if (0 < keyCode && keyCode < 0x80) {
    if (!mod || (code.code & ScanCode::Keys::FlagKeypad) != 0) {
      // キーパッドの場合は、修飾キーの有無に影響されない
      result = keyCode;
    } else {
      result = tableMod[keyCode];
      if (result == 0) {
        result = keyCode;
      } else if (result == 0xff) {
        result = 0;
      }
    }
  } else if (keyCode == ScanCode::Keys::KeyBSlashUnder) {
    result = mod ? '_' : '\\';
  }
  return result;
}
