#ifndef __ULIB_GRAPHBOX_H__
#define __ULIB_GRAPHBOX_H__

#include <header/Object.h>
#include <header/Control.h>
#include <header/Window.h>
extern "C"
{
	#include <guigui00.h>
}
using namespace Ulib;

namespace Ulib
{
	class GraphBox : public Ulib::Control
	{
	protected:
		LIB_GRAPHBOX *gbox;
		int color_mode; // 8bit:1 32bit:4
		int bgColor; // BackGround Color
		int charSet;
		void my_putstringg0(int opt, int xpos0, int ypos0,
			int color, int bgcolor, int charset, int base, int len, void *ofs);
	public:
		GraphBox(int bit = 8);
		virtual ~GraphBox();
		virtual const char *getTypeName();
		virtual void operator=(LIB_GRAPHBOX *gbox0);
		virtual LIB_GRAPHBOX *Get_LIB_GRAPHBOX();
		virtual void PutString(const char *str, int xpos0, int ypos0, int color);
		virtual void DrawPoint(int opt, int color, int x, int y);
		virtual void DrawLine(int opt, int color, int x0, int y0, int x1, int y1);
		virtual GraphBox &BgColor(int value);
		virtual int BgColor();
		virtual GraphBox &CharSet(int value);
		virtual int CharSet();
		virtual void DrawBox(int opt, int color, int x0, int y0, int x1, int y1);
		virtual int ColorMode();
		friend void Ulib::Window::AddObject(Object &object0);
		friend void Ulib::Window::RemoveObject(Object &object0);
		friend void Ulib::Window::RefreshObject(Object &object0);
	};
}

#endif
