#ifndef __ULIB_SIGNALBOX_H__
#define __ULIB_SIGNALBOX_H__

#include <header/Object.h>
#include <header/Window.h>
extern "C"
{
	#include <guigui00.h>
}
using namespace Ulib;

namespace Ulib
{
	class SignalBox : public Ulib::Object
	{
	protected:
		int *signalBox0;
		int *sigPtr;
	public:
		SignalBox();
		virtual const char *getTypeName();
		virtual void Open(int size = 256);
		virtual int GetSignal(bool wait = false);
		virtual int GetParameter();
		virtual void DefineSignal(const int opt, const int mode, const int code, Window &window0, const int signal);
		virtual void DefineSignalKey(const int opt, const int code, Window &window0, const int signal);
		virtual void DefineSignalMouse(const int opt, const int code, Window &window0, const int signal);
		virtual void DefineSignalEnd();
		static const int MOUSE0_LEFT = 0x0000; // {^
		static const int MOUSE0_RIGHT = 0x0001; // E{^
		static const int MOUSE0_MIDDLE = 0x0002; // {^
		static const int MOUSE0_COORDINATE_INSIDE = 0x0000; // EBhEł̍W
		static const int MOUSE0_COORDINATE_OUT = 0x0001; // EBhEEo
		static const int MOUSE0_COORDINATE_INOUTSIDE = 0x0002; // EBhEOł̍W
		static const int MOUSE1_COORDINATE =  0x0010; // W
		static const int MOUSE1_PRESS = 0x0020; // vX
		static const int MOUSE1_RELEASE = 0x0030; // [X
		static const int MOUSE2_SENSITIVITY_0 = 0x0000; // NbN̂ݍWlM
		static const int MOUSE2_SENSITIVITY_1 = 0x1000; // NbNƃhbOɍWl𑗐M
		static const int MOUSE2_SENSITIVITY_2 = 0x2000; // EBhEŏɍWl𑗐M
		static const int MOUSE2_SENSITIVITY_3 = 0x3000; // ɍWl𑗐M
	};
}
#endif
