#ifndef __ULIB_TEXTBOX_H__
#define __ULIB_TEXTBOX_H__

#include <header/Object.h>
#include <header/Control.h>
#include <header/ULString.h>
#include <header/Window.h>
extern "C"
{
	#include <guigui00.h>
}
using namespace Ulib;

namespace Ulib
{
	class TextBox : public Ulib::Control
	{
	protected:
		LIB_TEXTBOX *textBox;
		int bgColor; // BackGround Color
		int charSet, initChar;
		//char *inputString;
		ULString inputString;
		bool visible; // :true
		bool enabled; // [U[Ƃ̑Θbɉł邩ǂ
	public:
		TextBox();
		virtual ~TextBox();
		virtual const char *getTypeName();
		virtual const char *ToString();
		virtual void operator=(LIB_TEXTBOX *label0);
		virtual LIB_TEXTBOX *Get_LIB_TEXTBOX();
		virtual void PutString(const char *str, int xpos0, int ypos0, int color);
		virtual TextBox &xSize(int value);
		virtual int xSize(); /*I[o[ChĂ֐́A
							 ႦpiControljŎĂĂA
							 ̃NXōĎKvLB*/
		virtual TextBox &ySize(int value);
		virtual int ySize();
		virtual TextBox &BgColor(int value);
		virtual int BgColor();
		virtual TextBox &CharSet(int value);
		virtual int CharSet();
		virtual TextBox &InitChar(int value);
		virtual int InitChar();
		virtual void Clear();
		virtual bool Visible();
		virtual TextBox &Visible(bool value);
		virtual bool Enabled();
		virtual TextBox &Enabled(bool value);
		friend void Ulib::Window::AddObject(Object &object0);
		friend void Ulib::Window::RemoveObject(Object &object0);
	};
}

#endif
