#ifndef __ULIB_ULSTRING_H__
#define __ULIB_ULSTRING_H__

#include <header/Ulib0.h>
#include <header/Object.h>

namespace Ulib
{
	class ULString : public Ulib::Object
	{
	private:
		char *c_string;
		unsigned int strLength;
	public:
		typedef unsigned int size_type;
		static const size_type npos;
		ULString(const char *pchar = 0);
		ULString(const ULString &rstr);
		virtual ~ULString();
		virtual const char *getTypeName();
		virtual const char *ToString();

		// strAposڂAnoĐݒ
		virtual ULString &assign(const ULString &rstr, size_type pos = 0, size_type n = npos);
		// 萔ŏ
		virtual ULString &assign(const char *pchar);
		// 萔nŏ
		virtual ULString &assign(const char *pchar, size_type n);
		// ncŏ
		virtual ULString &assign(size_type n, char c);

		virtual const char *c_str() const;
		virtual size_type length() const; // consto֐
		virtual ULString &operator=(const char *pchar);
		virtual ULString &operator=(const ULString &rstr);
		virtual ULString &operator+=(const ULString &rstr);
		virtual ULString &operator+=(const char *pchar);
		virtual char &operator[](size_type pos);
		virtual char &at(size_type pos);
		virtual ULString &erase(size_type pos = 0, size_type n = npos);
		virtual ULString &append(const char *pchar);
		virtual ULString &append(const ULString &rstr);
		virtual ULString &insert(size_type pos, const char *pchar);
		virtual ULString &insert(size_type pos, const ULString &rstr);
		virtual ULString substr(size_type pos = 0, size_type n = npos) const;
		virtual size_type find(const char *pchar, size_type pos = 0) const;
		virtual size_type find(const ULString &rstr, size_type pos = 0) const;
		virtual size_type rfind(const char *pchar, size_type pos = npos) const;
		virtual size_type rfind(const ULString &rstr, size_type pos = npos) const;
		virtual size_type find_first_of(const char *pchar, size_type pos = 0) const;
		virtual size_type find_first_of(const ULString &rstr, size_type pos = 0) const;
		virtual size_type find_last_of(const char *pchar, size_type pos = npos) const;
		virtual size_type find_last_of(const ULString &rstr, size_type pos = npos) const;
		virtual size_type find_first_not_of(const char *pchar, size_type pos = 0) const;
		virtual size_type find_first_not_of(const ULString &rstr, size_type pos = 0) const;
		virtual size_type find_last_not_of(const char *pchar, size_type pos = npos) const;
		virtual size_type find_last_not_of(const ULString &rstr, size_type pos = npos) const;
		virtual ULString &replace(size_type pos, size_type n, const char *pchar);
		virtual ULString &replace(size_type pos, size_type n, const ULString &rstr);
		virtual void swap(ULString &rstr);
		/*
		virtual ULString &(const char *pchar);
		virtual ULString &(const ULString &rstr);
		*/
	};
	ULString operator+(const ULString &rstr1, const ULString &rstr2);
	ULString operator+(const char *pchar, const ULString &rstr);
	ULString operator+(const ULString &rstr, const char *pchar);
	bool operator==(const ULString &rstr1, const ULString &rstr2);
	bool operator==(const char *pchar, const ULString &rstr);
	bool operator==(const ULString &rstr, const char *pchar);

	char *ustrcpy(char *dest, const char *src);
	char *ustrncpy(char *dest, const char *src, ULString::size_type n);
	ULString::size_type ustrlen(const char *s);
}
#endif
