﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Text;
using System.Windows.Controls;
using NT2chObject;

namespace NT2chCtrl2
{
    public partial class NTSubjectViewPanel : UserControl, ISubjectView
    {
        private string mDataFilePath;
        private const string CONTROL_DATA_PATH = @"\NT2chCtrl2.txt";
        static char[] COMMA_CHAR = new char[] { ',' };

        void saveData()
        {
            if (null == mDataFilePath)
                return;

            StringBuilder sb = new StringBuilder();

            GridView gv = mLstThreadTitle.View as GridView;
            if (gv != null)
            {
                int count = gv.Columns.Count;
                for (int i = 0; i < count; i++)
                {
                    if (i != 0)
                        sb.Append(",");
                    GridViewColumn gvc = gv.Columns[i];
                    sb.Append(gvc.ActualWidth);
                }
            }

            FileStream fs = null;
            try
            {
                fs = File.Open(mDataFilePath, FileMode.Create, FileAccess.Write);
                StreamWriter sw = new StreamWriter(fs);

                sw.WriteLine(sb.ToString());
                sw.Flush();
                fs.Flush();
                fs.Close();
                fs = null;
            }
            catch (Exception e)
            {
                System.Diagnostics.Debug.WriteLine(e.StackTrace);
            }
            finally
            {
                if (null != fs)
                    fs.Close();
            }
        }
        bool loadData(string rootPath)
        {
            mDataFilePath = null;
            if (rootPath == null)
                return false;
            
            mDataFilePath = rootPath + CONTROL_DATA_PATH;

            string line = null;

            FileStream fs = null;
            try
            {
                fs = File.Open(mDataFilePath, FileMode.Open, FileAccess.Read);
                StreamReader sr = new StreamReader(fs);

                line = sr.ReadLine();

                fs.Close();
                fs = null;
            }
            catch (Exception e)
            {
                System.Diagnostics.Debug.WriteLine(e.StackTrace);
            }
            finally
            {
                if (null != fs)
                    fs.Close();
            }

            if (line == null)
                return true;


            string[] lines = line.Split(COMMA_CHAR);
            int lineLen = lines.Length;

            GridView gv  = mLstThreadTitle.View as GridView;
            if (gv != null)
            {
                int nVal;
                int count = gv.Columns.Count;
                count = Math.Min(count, lineLen);
                for (int i = 0; i < count; i++)
                {
                    if (int.TryParse(lines[i], out nVal))
                    {
                        GridViewColumn gvc = gv.Columns[i];
                        gvc.Width = nVal;
                    }
                }
            }
            return true;
        }

    }
}
