﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Input;


namespace NT2chCtrl
{
    public class TouchSupportScrollViewer
    {
        ScrollViewer mSV;
        UIElement mElement;
        bool mTouch = false;
        TouchPoint mPos;
        double mVOffest;

        public TouchSupportScrollViewer(
            ScrollViewer sv, UIElement element)
        {
            mSV = sv;
            mElement = element;
            mElement.TouchDown += element_TouchDown;
            mElement.TouchMove += element_TouchMove;
            mElement.TouchUp += element_TouchUp;
        }

        void element_TouchUp(object sender, TouchEventArgs e)
        {
            mTouch = false;
        }

        void element_TouchMove(object sender, TouchEventArgs e)
        {

            if (!mTouch)
                return;

            TouchPoint pos = e.GetTouchPoint(mElement);
            double y = mPos.Position.Y - pos.Position.Y;
            double newOffset = mVOffest + y;
            if (mSV != null)
                mSV.ScrollToVerticalOffset(newOffset);
        }


        void element_TouchDown(object sender, TouchEventArgs e)
        {
            try
            {
                mPos = e.GetTouchPoint(mElement);
                if (mSV == null)
                {
                    mTouch = false;
                    return;
                }
                mVOffest = mSV.VerticalOffset;
                mTouch = true;
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message);
            }
        }
    }
}
