﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Threading;
using System.Windows.Controls;
using System.Windows.Threading;

namespace NT2chCtrl
{
    public partial class UIElementListPanel : Panel
    {
        const int SCROLL_OBSERVE_TIMER_DURATION = 1000 / 15; //15 frames per second;
        const double SCROLL_FRICTION_RATIO = 0.9;
        const double MAX_SCROLL_SPEED_DELTA = 10000;

        object mLockTimerObj = new object();
        Timer mTimer;
        double mSpeedDelta;
        bool mAutoScroll;
        double mAutoScrollDelta;
        bool mPauseAutoScroll = false;

        public void setAutoScroll(bool enable, double ratio)
        {
            mAutoScroll = enable;
            if (enable)
            {
                mAutoScrollDelta = ratio * 100;
                mSpeedDelta = 0;
                startScrollObserveTimer(-mAutoScrollDelta);
            }
        }

        public void toggleScrollDirection()
        {
            mSpeedDelta *= -1;
        }

        public void pauseAutoScroll()
        {
            mPauseAutoScroll = true;
        }
        public void resumeAutoScroll()
        {
            mPauseAutoScroll = false;
        }
        public void reverseAutoScroll()
        {
        }

        private void startScrollObserveTimer(double delta)
        {
            lock (mLockTimerObj)
            {
                if (mTimer == null)
                {
                    mSpeedDelta = delta;
                    mTimer = new System.Threading.Timer(
                        scrollObserveTimerCallback,
                        null,
                        SCROLL_OBSERVE_TIMER_DURATION,
                        SCROLL_OBSERVE_TIMER_DURATION);
                }
                else
                {
                    mSpeedDelta += delta;
                    if (mSpeedDelta > MAX_SCROLL_SPEED_DELTA)
                        mSpeedDelta = MAX_SCROLL_SPEED_DELTA;
                    if (mSpeedDelta < -MAX_SCROLL_SPEED_DELTA)
                        mSpeedDelta = -MAX_SCROLL_SPEED_DELTA;
                    mTimer.Change(
                        SCROLL_OBSERVE_TIMER_DURATION,
                        SCROLL_OBSERVE_TIMER_DURATION);
                }
            }
        }

        private void scrollObserveTimerCallback(object param)
        {
            lock (mLockTimerObj)
            {
                double newOffset = mCurrentScrollPos - (mSpeedDelta/15);

                mSpeedDelta *= SCROLL_FRICTION_RATIO;
#if DOTNET45
                if (mTouchDown)
                {
                    mSpeedDelta *= SCROLL_FRICTION_RATIO;
                }
#endif
                if (mAutoScroll)
                {
                    if (mSpeedDelta < mAutoScrollDelta && mSpeedDelta > -mAutoScrollDelta)
                    {
                        if(mSpeedDelta > 0)
                            mSpeedDelta = mAutoScrollDelta;                    
                        else
                            mSpeedDelta = -mAutoScrollDelta;
                    }
                    if (mPauseAutoScroll)
                        return;
                }
                else
                {
                    if (mSpeedDelta < 10 && mSpeedDelta > -10)
                    {
                        mSpeedDelta = 0;
                        if (mTimer != null)
                        {
                            mTimer.Dispose();
                            mTimer = null;
                        }
                    }
                }
                this.Dispatcher.BeginInvoke(DispatcherPriority.Normal,
                    (ThreadStart)delegate()
                {
                    setScrollValue(newOffset);
                });         
            }

        }
    }
}
