﻿using System;
using System.Collections.Generic;
using System.Text;
using NT2chCtrl.html.css;
using NT2chObject;

namespace NT2chCtrl.html
{
    public partial class HtmlElement
    {
        HtmlElement mParent;
        List<HtmlElement> mChildren;
        List<HtmlAttribute> mAttributes;
        List<string> mClassList = null;
        List<Selector> mMatchedSelector;
        string mTagName;
        protected bool mClosed;

        public int mDebugLine;
        public int mDebugSourceIndex;
        public void setDebugInfo(int line, int sourceIndex)
        {
            mDebugLine = line;
            mDebugSourceIndex = sourceIndex;
        }

        public HtmlElement getParent() { return mParent; }
        public List<HtmlElement> getChildren() { return mChildren; }
        public void setChildren(List<HtmlElement>  children) { mChildren = children; }
        public bool Closed() { return mClosed; }
        public void setClosed(bool value) { mClosed = value; }
        public string getTagName() { return mTagName; }
        public void addAttribute(HtmlAttribute item)
        {
            mAttributes.Add(item);
        }
        public void clearChildren()
        {
            mChildren.Clear();
        }

        public string getInnerHtml()
        {
            StringBuilder sb = new StringBuilder();
            foreach (HtmlElement elem in mChildren)
            {
                elem.getOuterHtml(sb);
            }
            return sb.ToString();
        }
        public string getOuterHtml()
        {
            StringBuilder sb = new StringBuilder();
            if(!Tag2String(sb))
                return sb.ToString();
            if (mChildren.Count == 0)
            {
                sb.Append("/>");
                return sb.ToString();
            }
            sb.Append(">");
            foreach (HtmlElement elem in mChildren)
            {
                elem.getOuterHtml(sb);
            }
            sb.Append("</").Append(mTagName).Append('>');
            return sb.ToString();
        }

        private void getOuterHtml(StringBuilder sb)
        {
            if(!Tag2String(sb))
                return;
            if (mChildren.Count == 0)
            {
                sb.Append("/>");
                return;
            }
            sb.Append(">");
            foreach (HtmlElement elem in mChildren)
            {
                elem.getOuterHtml(sb);
            }
            sb.Append("</").Append(mTagName).Append('>');
        }

        protected virtual bool Tag2String(StringBuilder sb)
        {
            int nVal;
            sb.Append('<').Append(mTagName).Append(' ');

            foreach (HtmlAttribute attr in mAttributes)
            {
                string name = attr.getName();
                string value = attr.getValue();
                if (name.Equals(value))
                {
                    sb.Append(name);
                }
                else
                {
                    sb.Append(name).Append('=');
                    if (int.TryParse(value, out nVal))
                    {
                        sb.Append(value);
                    }
                    else
                    {
                        sb.Append('\"').Append(value).Append('\"');
                    }
                }
                sb.Append(' ');
            }
            return true;
        }

        public string getAttributeValue(string attrName)
        {
            int count = mAttributes.Count;
            for (int i = 0; i < count; i++)
            {
                if (mAttributes[i].getName().Equals(attrName))
                {
                    return mAttributes[i].getValue();
                }
            }
            return null;
        }

        public void addSelector(Selector stor)
        {
            mMatchedSelector.Add(stor);
        }

        public HtmlElement(HtmlElement parent, string tagName)
        {
            mParent = parent;
            if (mParent != null)
                parent.mChildren.Add(this);
            mTagName = tagName;
            mChildren = new List<HtmlElement>();
            mAttributes = new List<HtmlAttribute>();
            mMatchedSelector = new List<Selector>();
            mClosed = false;
            mDebugLine = -1;
            mDebugSourceIndex = -1;
        }

        public virtual HtmlElement Clone(HtmlElement parent)
        {
            HtmlElement elem = new HtmlElement(parent, mTagName);

            elem.mAttributes.AddRange(mAttributes);
            elem.mClosed = mClosed;
            if(mClassList != null)
                elem.mClassList.AddRange(mClassList);

            foreach (HtmlElement e in mChildren)
            {
                e.Clone(elem);
            }
            return elem;
        }

        public void setInnerResHtml(string text, IAmbiguousSearch search)
        {
            mChildren.Clear();
            //setInnerText(text);
            parse2chRes(text, search);
        }
        public void setInnerText(string text)
        {
            mChildren.Clear();
            StringElement elem = new StringElement(this, text);
        }

        public List<HtmlElement> getChildren(//HtmlElement parant, 
            string tagName, List<string> classList, string id,
            string attrName)
        {
            List<HtmlElement> rList = new List<HtmlElement>();
            if (mChildren == null || mChildren.Count == 0)
                return rList;

            foreach (HtmlElement elem in mChildren)
            {
                if (matchSelector(elem, tagName, classList, id, attrName))
                    rList.Add(this);
            }
            return rList;
        }

        public List<HtmlElement> getElements(List<HtmlElement>rList, 
                    string tagName, List<string> classList, string id,
                    string attrName, bool skipParent)
        {
            bool addList = !skipParent;
            if(rList == null)
                rList = new List<HtmlElement>();

            if (!skipParent)
            {
                if (matchSelector(this, tagName, classList, id, attrName))
                    rList.Add(this);
            }

            if (mChildren == null || mChildren.Count == 0)
                return rList;

            foreach (HtmlElement child in mChildren)
            {
                rList = child.getElements(rList,
                     tagName, classList, id, attrName, false);
            }
            return rList;
        }

        private bool matchSelector(HtmlElement element,
            string tagName, List<string> classList, 
            string id, string attrName)
        {
            if (tagName != null)
            {
                if (!tagName.Equals(element.getTagName()))
                    return false;
            }
            if (classList != null)
            {
                if (!ContainClasses(classList))
                    return false;
            }
            if (id != null)
            {
                if (!id.Equals(getAttributeValue("id")))
                    return false;
            }
            if (attrName != null)
            {
                if (null == getAttributeValue(attrName))
                    return false;
            }
            return true;
        }


        public string[] getStringContent()
        {
            List<string> result = new List<string>();
            int count = mChildren.Count;
            for (int i = 0; i < count; i++)
            {
                StringElement elem = mChildren[i] as StringElement;
                if (elem == null)
                    continue;
                result.Add(elem.getString());
            }
            return result.ToArray();
        }

        public bool ContainClasses(List<string> classNames)
        {
            if (mClassList == null)
            {
                mClassList = getClasses();
            }
            if (mClassList.Count == 0)
                return false;
            bool contain = true;
            foreach (string s1 in classNames)
            {
                bool found = false;
                foreach (string s2 in mClassList)
                {
                    if (s1.Equals(s2))
                    {
                        found = true;
                        break;
                    }
                }
                if (!found)
                {
                    contain = false;
                    break;
                }
            }
            return contain;
        }

        public List<string> getClasses()
        {
            List<string> resultList = new List<string>();
            string classes = getAttributeValue("class");
            if (classes == null)
                return resultList;

            int length = classes.Length;
            int state = 0;
            int textStart = 0;
            for (int i = 0; i < length; i++)
            {
                switch (HtmlParser.getCharToken(classes[i]))
                {
                    case HtmlParser.CHAR_TOKEN.WHITESPACE:
                    case HtmlParser.CHAR_TOKEN.NL:
                        if (state == 1)
                        {
                            string clsName = classes.Substring(textStart, i - textStart);
                            resultList.Add(clsName);
                            state = 0;
                        }
                        break;
                    default:
                        if (state == 0)
                        {
                            state = 1;
                            textStart = i;
                        }
                        break;
                }
            }
            if (state == 1)
            {
                string clsName = classes.Substring(textStart,
                    length - textStart);
                resultList.Add(clsName);
            }
            return resultList;
        }


    }
}
