﻿using System;
using System.Collections.Generic;
using System.Text;

namespace NT2chCtrl.html.css
{
    public class Select
    {
        string mTag;
        string mClass;
        string mId;
        string mAttrName;
        string mAttrValue;
        bool mImmidiate;

        public string getTagName() { return mTag; }
        public string getClassName() { return mClass; }
        public string getIdName() { return mId; }
        public string getAttrName() { return mAttrName; }
        public string getAttrValue() { return mAttrValue; }
        public bool isImmidiateChild() { return mImmidiate; }

        public static  int Parse(DebugContext ctx, string source, int startIdx,
            List<Selector> resultList)
        {
            //List<List<Select>> resultList = new List<List<Select>>();
            Selector list = new Selector();
            
            int state = 0;

            string tagName = null;
            string className = null;
            string idName = null;
            string attrName = null;
            string attrVal = null;
            Select sel;
            bool immidiate = false;


            int textStart = startIdx;



            int length = source.Length;
            for (int i = startIdx; i < length; i++)
            {
                char c = source[i];
                HtmlParser.CHAR_TOKEN token = 
                    HtmlParser.getCharToken(c);

                switch (token)
                {
                    case HtmlParser.CHAR_TOKEN.ALPHA:
                        if (state == 0)
                        {
                            state = 1;
                            textStart = i;
                        }
                        else if(state == 2){
                            state = 4;
                            textStart = i;
                        }
                        else if (state == 3)
                        {
                            state = 5;
                            textStart = i;
                        }
                        else if (state == 7)
                        {
                            state = 8;
                            textStart = i;
                        }
                        else if (state == 9)
                        {
                            state = 10;
                            textStart = i;
                        }
                        break;
                    case HtmlParser.CHAR_TOKEN.NUMBER:
                    case HtmlParser.CHAR_TOKEN.HYPHIEN:
                    case HtmlParser.CHAR_TOKEN.UNDERBAR:
                        if (state == 0 || state == 2 || state == 3 || state == 7)
                        {
                            ctx.setCurrentIdx(i);
                            return -1;
                        }
                        else if (state == 9)
                        {
                            state = 10;
                            textStart = i;

                        }
                        break;
                    case HtmlParser.CHAR_TOKEN.ASTOR:
                        if (state != 0)
                        {
                            ctx.setCurrentIdx(i);
                            return -1;
                        }
                        state = 6;
                        break;
                    case HtmlParser.CHAR_TOKEN.PERIOD:
                        if (state == 1)
                        {
                            tagName = source.Substring(textStart, i - textStart);
                        }
                        else if (state == 6 || state == 0)
                        {
                            tagName = null;
                        }
                        else
                        {
                            ctx.setCurrentIdx(i);
                            return -1;
                        }
                        state = 2;
                        break;
                    case HtmlParser.CHAR_TOKEN.L_SQUARE_BRACKET:
                        if (state == 0 || state == 6)
                        {
                            state = 7;
                            tagName = className = idName = null;
                        }
                        else if (state == 1)
                        {
                            tagName = source.Substring(textStart, i - textStart);
                        }
                        else if (state == 4)
                        {
                            className = source.Substring(textStart, i - textStart);
                        }
                        else if (state == 5)
                        {
                            idName = source.Substring(textStart, i - textStart);
                        }
                        else
                        {
                            ctx.setCurrentIdx(i);
                            return -1;
                        }
                        state = 7;
                        break;
                    case HtmlParser.CHAR_TOKEN.R_SQUARE_BRACKET:
                        if (state == 8)
                        {
                            attrName = source.Substring(textStart, i - textStart);
                        }
                        else if (state == 10)
                        {
                            attrVal = source.Substring(textStart, i - textStart);
                        }
                        else
                        {
                            ctx.setCurrentIdx(i);
                            return -1;
                        }
                        state = 11;
                        break;
                    case HtmlParser.CHAR_TOKEN.EQUAL:
                        if (state != 8)
                        {
                            ctx.setCurrentIdx(i);
                            return -1;
                        }
                        attrName = source.Substring(textStart, i - textStart);
                        state = 9;
                        break;
                    case HtmlParser.CHAR_TOKEN.SHARP:
                        if (state == 0 || state == 6)
                        {
                        }
                        else if (state == 1)
                        {
                            tagName = source.Substring(textStart, i - textStart);
                        }
                        else if (state == 4)
                        {
                            className = source.Substring(textStart, i - textStart);
                        }
                        else
                        {
                            ctx.setCurrentIdx(i);
                            return -1;
                        }
                        state = 3;
                        break;
                    case HtmlParser.CHAR_TOKEN.GT:
                        if (state != 0)
                        {
                            ctx.setCurrentIdx(i);
                            return -1;
                        }
                        immidiate = true;
                        break;
                    case HtmlParser.CHAR_TOKEN.COMMA:
                        if (state == 0)
                        {
                            sel = null;
                        }
                        else if (state == 1)
                        {
                            sel = new Select(
                                source.Substring(textStart, i - textStart),
                                        null, null, null, null, immidiate);
                            immidiate = false;
                        }
                        else if (state == 4)
                        {
                            sel = new Select(tagName,
                                source.Substring(textStart, i - textStart),
                                        null, null, null, immidiate);
                            immidiate = false;
                        }
                        else if (state == 5)
                        {
                            sel = new Select(tagName, className,
                                source.Substring(textStart, i - textStart),
                                null, null, 
                                immidiate);
                            immidiate = false;
                        }
                        else if (state == 6)
                        {
                            sel = new Select(null, null, null, null, null, immidiate);
                            immidiate = false;
                        }
                        else if (state == 11)
                        {
                            sel = new Select(tagName, className, idName, attrName, attrVal, immidiate);
                            immidiate = false;
                        }
                        else
                        {
                            ctx.setCurrentIdx(i);
                            return -1;
                        }
                        state = 0;
                        if(sel != null)
                            list.addSelect(sel);
                        resultList.Add(list);
                        list = new Selector();

                        tagName = null;
                        className = null;
                        idName = null;
                        attrName = null;
                        attrVal = null;
                        break;
                    case HtmlParser.CHAR_TOKEN.WHITESPACE:
                        if (state == 0)
                        {
                            break;
                        }
                        else if (state == 1)
                        {
                            sel = new Select(
                                source.Substring(textStart, i - textStart),
                                        null, null, null, null, immidiate);
                            immidiate = false;
                        }
                        else if (state == 4)
                        {
                            sel = new Select(tagName,
                                source.Substring(textStart, i - textStart),
                                        null, null, null, immidiate);
                            immidiate = false;
                        }
                        else if (state == 5)
                        {
                            sel = new Select(tagName, className,
                                source.Substring(textStart, i - textStart),
                                null, null, immidiate);
                            immidiate = false;
                        }
                        else if (state == 6)
                        {
                            sel = new Select(null, null, null, null, null, immidiate);
                            immidiate = false;
                        }
                        else if (state == 11)
                        {
                            sel = new Select(tagName, className, idName, attrName, attrVal, immidiate);
                            immidiate = false;
                        }
                        else
                        {
                            ctx.setCurrentIdx(i);
                            return -1;
                        }
                        state = 0;
                        list.addSelect(sel);
                        tagName = null;
                        className = null;
                        idName = null;
                        attrName = null;
                        attrVal = null;
                        break;
                    case HtmlParser.CHAR_TOKEN.NL:
                        ctx.incrementLine();
                        if(state == 0)
                        {
                            break;
                        }
                        else if (state == 1)
                        {
                            sel = new Select(
                                source.Substring(textStart, i - textStart),
                                        null, null, null, null, immidiate);
                            immidiate = false;
                        }
                        else if (state == 4)
                        {
                            sel = new Select(tagName,
                                source.Substring(textStart, i - textStart),
                                        null, null, null, immidiate);
                            immidiate = false;
                        }
                        else if (state == 5)
                        {
                            sel = new Select(tagName, className,
                                source.Substring(textStart, i - textStart),
                                 null, null, immidiate);
                            immidiate = false;
                        }
                        else if (state == 6)
                        {
                            sel = new Select(null, null, null, null, null, immidiate);
                            immidiate = false;
                        }
                        else if (state == 11)
                        {
                            sel = new Select(tagName, className, idName, attrName, attrVal, immidiate);
                            immidiate = false;
                        }
                        else
                        {
                            ctx.setCurrentIdx(i);
                            return -1;
                        }
                        state = 0;
                        list.addSelect(sel);
                        tagName = null;
                        className = null;
                        idName = null;
                        attrName = null;
                        attrVal = null;
                        break;
                    case HtmlParser.CHAR_TOKEN.L_CURLY_BRACKET:
                        if(state == 0)
                        {
                            sel = null;
                        }
                        else if (state == 1)
                        {
                            sel = new Select(
                                source.Substring(textStart, i - textStart),
                                        null, null, null, null, immidiate);
                            immidiate = false;
                        }
                        else if (state == 4)
                        {
                            sel = new Select(tagName,
                                source.Substring(textStart, i - textStart),
                                        null, null, null, immidiate);
                            immidiate = false;
                        }
                        else if (state == 5)
                        {
                            sel = new Select(tagName, className,
                                source.Substring(textStart, i - textStart),
                                 null, null, immidiate);
                            immidiate = false;
                        }
                        else if (state == 6)
                        {
                            sel = new Select(null, null, null, null, null, immidiate);
                            immidiate = false;
                        }
                        else if (state == 11)
                        {
                            sel = new Select(tagName, className, idName, attrName, attrVal, immidiate);
                            immidiate = false;
                        }
                        else
                        {
                            ctx.setCurrentIdx(i);
                            return -1;
                        }
                        if(sel != null)
                            list.addSelect(sel);
                        resultList.Add(list);
                        return i;
                    case HtmlParser.CHAR_TOKEN.SLASH:
                        if (i < length - 1 && source[i+1] == '*')
                        {
                            int idx = source.IndexOf("*/", i + 2);
                            if (idx >= 0)
                            {
                                for (int j = i + 2; j < idx; j++)
                                {
                                    if (source[j] == '\n')
                                    {
                                        ctx.incrementLine();
                                    }
                                }
                                if (state == 0)
                                {
                                    //break;
                                    sel = null;
                                }
                                else if (state == 1)
                                {
                                    sel = new Select(
                                        source.Substring(textStart, i - textStart),
                                                null, null, null, null, immidiate);
                                    immidiate = false;
                                }
                                else if (state == 4)
                                {
                                    sel = new Select(tagName,
                                        source.Substring(textStart, i - textStart),
                                                null, null, null, immidiate);
                                    immidiate = false;
                                }
                                else if (state == 5)
                                {
                                    sel = new Select(tagName, className,
                                        source.Substring(textStart, i - textStart),
                                         null, null, immidiate);
                                    immidiate = false;
                                }
                                else if (state == 6)
                                {
                                    sel = new Select(null, null, null, null, null, immidiate);
                                    immidiate = false;
                                }
                                else if (state == 11)
                                {
                                    sel = new Select(tagName, className, idName, attrName, attrVal, immidiate);
                                    immidiate = false;
                                }
                                else
                                {
                                    ctx.setCurrentIdx(i);
                                    return -1;
                                }
                                if (state != 0)
                                {
                                    state = 0;
                                    list.addSelect(sel);
                                    tagName = null;
                                    className = null;
                                    idName = null;
                                    attrName = null;
                                    attrVal = null;
                                }
                                i = idx + 1;
                            }
                        }
                        break;
                    case HtmlParser.CHAR_TOKEN.OTHER:
                        //if (state != 0)
                        //{
                        ctx.setCurrentIdx(i);
                        return -1;
                        //}
                        //break;
                }

            }
            return length;
        }

        public int getSpecificity()
        {
            int specificity = 0;
            if (mId != null && mId.Length > 0 && !mId.Equals("*"))
                specificity += 100;

            if (mClass != null && mClass.Length > 0 && !mClass.Equals("*"))
                specificity += 10;

            if (mAttrName != null && mAttrName.Length > 0)
                specificity += 10;

            if (mTag != null && mTag.Length > 0 && !mTag.Equals("*"))
                specificity += 1;
            return specificity;
        }

        public Select(string tag, string className, string id, 
            string attrName, string attrVal, bool immidiate)
        {
            mTag = (tag != null && tag.Length > 0) ? tag : "*";
            mClass = (className != null && className.Length > 0) ? className : "*";
            mId = (id != null && id.Length > 0) ? id : "*";
            if (attrName != null)
            {
                if (attrVal == null)
                    mAttrValue = attrName;
                else
                    mAttrValue = attrVal;
                mAttrName = attrName;
            }
            else
            {
                mAttrName = null;
            }
            mImmidiate = immidiate;
        }

    }
}
