﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Input;
using System.Windows.Media;
using NT2chView.NtUI;

namespace NT2chView
{
    partial class MainWindow
    {
        private void hideAllToolbarDropCanvas()
        {
            mThreadTitleViewLHSDragCanvas.Visibility = System.Windows.Visibility.Collapsed;
            mThreadTitleViewRHSDragCanvas.Visibility = System.Windows.Visibility.Collapsed;
            mLHSDragCanvas.Visibility = System.Windows.Visibility.Collapsed;
            mRHSDragCanvas.Visibility = System.Windows.Visibility.Collapsed;
        }

        private void mLHSDragCanvas_DragEnter(object sender, DragEventArgs e)
        {
            if (validateResViewToolbarDropData(e))
                mLHSDragCanvas.Background = (Brush)TryFindResource("lhsDragBrush");
        }

        private void mLHSDragCanvas_DragLeave(object sender, DragEventArgs e)
        {
            mLHSDragCanvas.Background = (Brush)TryFindResource("lhsDragOrgBrush");
        }

        private void mLHSDragCanvas_DragOver(object sender, DragEventArgs e)
        {
            if (validateResViewToolbarDropData(e))
                mLHSDragCanvas.Background = (Brush)TryFindResource("lhsDragBrush");
        }

        private void mLHSDragCanvas_Drop(object sender, DragEventArgs e)
        {
            mLHSDragCanvas.Background = (Brush)TryFindResource("lhsDragOrgBrush");
            if (validateResViewToolbarDropData(e))
            {
                mTooltrayResView.SetValue(DockPanel.DockProperty, Dock.Left);
                NTUserPreference.ResViewToolbarPosition = NTDragDrop.TOOLBAR_LOCATION_LEFT;
            }
            hideAllToolbarDropCanvas();
        }

        private void mRHSDragCanvas_DragEnter(object sender, DragEventArgs e)
        {
            if (validateResViewToolbarDropData(e))
                mRHSDragCanvas.Background = (Brush)TryFindResource("rhsDragBrush");
        }

        private void mRHSDragCanvas_DragLeave(object sender, DragEventArgs e)
        {
            mRHSDragCanvas.Background = (Brush)TryFindResource("rhsDragOrgBrush");
        }

        private void mRHSDragCanvas_DragOver(object sender, DragEventArgs e)
        {
            if (validateResViewToolbarDropData(e))
                mRHSDragCanvas.Background = (Brush)TryFindResource("rhsDragBrush");
        }

        private void mRHSDragCanvas_Drop(object sender, DragEventArgs e)
        {
            mRHSDragCanvas.Background = (Brush)TryFindResource("rhsDragOrgBrush");
            if (validateResViewToolbarDropData(e))
            {
                mTooltrayResView.SetValue(DockPanel.DockProperty, Dock.Right);
                NTUserPreference.ResViewToolbarPosition = NTDragDrop.TOOLBAR_LOCATION_RIGHT;
            }
            hideAllToolbarDropCanvas();
        }

        bool validateResViewToolbarDropData(DragEventArgs e)
        {
            IDataObject data = e.Data;

            if (!data.GetDataPresent(NTDragDrop.RES_VIEW_TOOLBAR_DRAG_FORMAT))
            {
                e.Effects = DragDropEffects.None;
                return false;
            }
            else
            {
                e.Effects = DragDropEffects.Move;
                e.Handled = true;
                return true;
            }
        }


        bool mResViewToolbarDragCapture = false;
        Point mResViewPointCapture;

        void startDrag()
        {
            NTDragDrop.ResViewToolbarData data = new NTDragDrop.ResViewToolbarData();
            DataObject dObj = new DataObject(NTDragDrop.RES_VIEW_TOOLBAR_DRAG_FORMAT, data);
            DragDrop.DoDragDrop(mToolbarResView, dObj, DragDropEffects.All);
            hideAllToolbarDropCanvas();
        }

        private void mResViewToolHandle_MouseEnter(object sender, MouseEventArgs e)
        {

        }

        private void mResViewToolHandle_MouseLeave(object sender, MouseEventArgs e)
        {

        }

        private void mResViewToolHandle_MouseLeftBouttnDown(object sender, MouseButtonEventArgs e)
        {
            mResViewToolbarDragCapture = true;
            mResViewPointCapture = e.GetPosition(mToolbarResView);

        }

        private void mResViewToolHandle_MouseLeftButtonUp(object sender, MouseButtonEventArgs e)
        {
            mResViewToolbarDragCapture = false;

        }

        private void mResViewToolHandle_MouseMove(object sender, MouseEventArgs e)
        {
            if (!mResViewToolbarDragCapture)
                return;
            Point p = e.GetPosition(mToolbarResView);
            Vector v = Point.Subtract(p, mResViewPointCapture);
            if (v.Length > NTDragDrop.DRAG_START_MOVE_DELTA)
            {
                if (NTUserPreference.ResViewToolbarPosition
                    == NTDragDrop.TOOLBAR_LOCATION_RIGHT)
                {
                    mLHSDragCanvas.Visibility = System.Windows.Visibility.Visible;
                }
                else
                {
                    mRHSDragCanvas.Visibility = System.Windows.Visibility.Visible;
                }
                startDrag();
                e.Handled = true;
                mResViewToolbarDragCapture = false;
            }

        }
//----------------------------
        private void mThreadTitleViewLHSDragCanvas_DragEnter(object sender, DragEventArgs e)
        {
            if (validateThreadTitleViewToolbarDropData(e))
                mThreadTitleViewLHSDragCanvas.Background = (Brush)TryFindResource("lhsDragBrush");
        }

        private void mThreadTitleViewLHSDragCanvas_DragLeave(object sender, DragEventArgs e)
        {
            mThreadTitleViewLHSDragCanvas.Background = (Brush)TryFindResource("lhsDragOrgBrush");
        }

        private void mThreadTitleViewLHSDragCanvas_DragOver(object sender, DragEventArgs e)
        {
            if (validateThreadTitleViewToolbarDropData(e))
                mThreadTitleViewLHSDragCanvas.Background = (Brush)TryFindResource("lhsDragBrush");
        }

        private void mThreadTitleViewLHSDragCanvas_Drop(object sender, DragEventArgs e)
        {
            mThreadTitleViewLHSDragCanvas.Background = (Brush)TryFindResource("lhsDragOrgBrush");
            if (validateThreadTitleViewToolbarDropData(e))
            {
                mTooltrayThreadTitleView.SetValue(DockPanel.DockProperty, Dock.Left);
                NTUserPreference.ThreadTitleViewToolbarPosition = NTDragDrop.TOOLBAR_LOCATION_LEFT;
            }
            hideAllToolbarDropCanvas();
        }

        private void mThreadTitleViewRHSDragCanvas_DragEnter(object sender, DragEventArgs e)
        {
            if (validateThreadTitleViewToolbarDropData(e))
                mThreadTitleViewRHSDragCanvas.Background = (Brush)TryFindResource("rhsDragBrush");
        }

        private void mThreadTitleViewRHSDragCanvas_DragLeave(object sender, DragEventArgs e)
        {
            mThreadTitleViewRHSDragCanvas.Background = (Brush)TryFindResource("rhsDragOrgBrush");
        }

        private void mThreadTitleViewRHSDragCanvas_DragOver(object sender, DragEventArgs e)
        {
            if (validateThreadTitleViewToolbarDropData(e))
                mThreadTitleViewRHSDragCanvas.Background = (Brush)TryFindResource("rhsDragBrush");
        }

        private void mThreadTitleViewRHSDragCanvas_Drop(object sender, DragEventArgs e)
        {
            mThreadTitleViewRHSDragCanvas.Background = (Brush)TryFindResource("rhsDragOrgBrush");
            if (validateThreadTitleViewToolbarDropData(e))
            {
                mTooltrayThreadTitleView.SetValue(DockPanel.DockProperty, Dock.Right);
                NTUserPreference.ThreadTitleViewToolbarPosition = NTDragDrop.TOOLBAR_LOCATION_RIGHT;
            }
            hideAllToolbarDropCanvas();
        }

        bool validateThreadTitleViewToolbarDropData(DragEventArgs e)
        {
            IDataObject data = e.Data;

            if (!data.GetDataPresent(NTDragDrop.THREADTITLE_VIEW_TOOLBAR_DRAG_FORMAT))
            {
                e.Effects = DragDropEffects.None;
                return false;
            }
            else
            {
                e.Effects = DragDropEffects.Move;
                e.Handled = true;
                return true;
            }
        }


        bool mThreadTitleViewToolbarDragCapture = false;
        Point mThreadTitleViewPointCapture;

        void startDrag2()
        {
            NTDragDrop.ThreadTitleToolbarData data = new NTDragDrop.ThreadTitleToolbarData();
            DataObject dObj = new DataObject(NTDragDrop.THREADTITLE_VIEW_TOOLBAR_DRAG_FORMAT, data);
            DragDrop.DoDragDrop(mToolbarThreadTitleView, dObj, DragDropEffects.All);
            hideAllToolbarDropCanvas();
        }

        private void mThreadTitleViewToolHandle_MouseEnter(object sender, MouseEventArgs e)
        {

        }

        private void mThreadTitleViewToolHandle_MouseLeave(object sender, MouseEventArgs e)
        {

        }

        private void mThreadTitleViewToolHandle_MouseLeftBouttnDown(object sender, MouseButtonEventArgs e)
        {
            mThreadTitleViewToolbarDragCapture = true;
            mThreadTitleViewPointCapture = e.GetPosition(mToolbarThreadTitleView);

        }

        private void mThreadTitleViewToolHandle_MouseLeftButtonUp(object sender, MouseButtonEventArgs e)
        {
            mThreadTitleViewToolbarDragCapture = false;

        }

        private void mThreadTitleViewToolHandle_MouseMove(object sender, MouseEventArgs e)
        {
            if (!mThreadTitleViewToolbarDragCapture)
                return;
            Point p = e.GetPosition(mToolbarThreadTitleView);
            Vector v = Point.Subtract(p, mThreadTitleViewPointCapture);
            if (v.Length > NTDragDrop.DRAG_START_MOVE_DELTA)
            {
                if (NTUserPreference.ThreadTitleViewToolbarPosition
                    == NTDragDrop.TOOLBAR_LOCATION_RIGHT)
                {
                    mThreadTitleViewLHSDragCanvas.Visibility = System.Windows.Visibility.Visible;
                }
                else
                {
                    mThreadTitleViewRHSDragCanvas.Visibility = System.Windows.Visibility.Visible;
                }
                startDrag2();
                e.Handled = true;
                mThreadTitleViewToolbarDragCapture = false;
            }

        }

    }
}
