﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Threading;
using System.Windows;
using System.Windows.Documents;
using NT2chView.NtFile;
using NT2chView.NtNet;
using System.Runtime.Remoting.Contexts;
using NT2chCtrl;
using NT2chObject;


namespace NT2chView
{
    //[Synchronization]
    public class NTThreadTitle :  NTThread, IThread2
    {
        public string getTitle() { return Title; }
        public IBoard getBoard() { return mBoard; }
        public override string  getDatName() { return mDat; }
        public List<IRes> getResList()
        {
            if(mResList == null || mResList.Count == 0)
                return new List<IRes>();

            List<IRes> list = new List<IRes>(mResList.Count);

            foreach (IRes res in mResList)
                list.Add(res);        
            
            return list;
        }
        public int getPrevReadCount()
        {
            return mPrevReadCnt;
        }
        private object mObjExtra;
        public object getExtra() { return mObjExtra; }
        public void setExtra(object o) { mObjExtra = o; }

        public NTThread getDependencyObject(){ return this; }

#if false
        //     { "SeqNo", "Title", "ResCnt", "ReadCnt", "RemainCnt","LastMod", "LastWrite" };
        public static readonly DependencyProperty SeqNoProperty;
        public static readonly DependencyProperty TitleProperty;
        public static readonly DependencyProperty ResCntProperty;
        public static readonly DependencyProperty ReadCntProperty;
        public static readonly DependencyProperty RemainCntProperty;
        public static readonly DependencyProperty LastModProperty;
        public static readonly DependencyProperty LastWriteProperty;

        static NTThreadTitle()
        {
            
            PropertyMetadata pm1 = new PropertyMetadata(0);
            PropertyMetadata pm3 = new PropertyMetadata(0, new PropertyChangedCallback(OnResCntChanged));
            PropertyMetadata pm4 = new PropertyMetadata(0,new PropertyChangedCallback(OnReadCntChanged));
            PropertyMetadata pm5 = new PropertyMetadata(0);
            PropertyMetadata pm2 = new PropertyMetadata(string.Empty);
            PropertyMetadata pm6 = new PropertyMetadata(string.Empty);
            PropertyMetadata pm7 = new PropertyMetadata(string.Empty);

            SeqNoProperty = DependencyProperty.Register("SeqNo", typeof(int), typeof(NTThreadTitle), pm1);
            TitleProperty = DependencyProperty.Register("Title", typeof(string), typeof(NTThreadTitle), pm2);
            ResCntProperty = DependencyProperty.Register("ResCnt", typeof(int), typeof(NTThreadTitle), pm3);
            ReadCntProperty = DependencyProperty.Register("ReadCnt", typeof(int), typeof(NTThreadTitle), pm4);
            RemainCntProperty = DependencyProperty.Register("RemainCnt", typeof(int), typeof(NTThreadTitle), pm5);
            LastModProperty = DependencyProperty.Register("LastMod", typeof(string), typeof(NTThreadTitle), pm6);
            LastWriteProperty = DependencyProperty.Register("LastWrite", typeof(string), typeof(NTThreadTitle), pm7);
        
        }
#endif
        public NTBoard mBoard;
        public string mDat;
        public int mPrevReadCnt = -1;
        public List<NTRes> mResList = new List<NTRes>();
        public List<int> mWriteNoList = new List<int>();
        public List<int> mBookmarkList = new List<int>();
        public bool mLocalDat = false;
        
        //NTVagueSearchWord mVagueSearch = null;
        //int mSearchSecIndex = 0;
        //int mSearchTextIndex = 0;

        int mCurrentBookmarkFocus = -1;

        public string mWroteMsg = string.Empty;

#if false
        public void SearchWordSet(string sWord)
        {
            if (mVagueSearch == null)
                mVagueSearch = new NTVagueSearchWord(sWord);
            else
                mVagueSearch.setSearchWord(sWord);


            //mSearchSecIndex = 0;
           // mSearchTextIndex = 0;

        }


        public Section SearchNext()
        {

            
            if (mVagueSearch == null)
                return null;

            int len = mResList.Count;
            if (mSearchSecIndex >= len)
                mSearchSecIndex = 0;

            for (int i = mSearchSecIndex; i < len; i++)
            {
                NTRes res = mResList[i];
                string text = res.mMsg;
                int outLen;
                int ret = mVagueSearch.match(text, mSearchTextIndex, out outLen);
                if (ret >= 0)
                {
                    Section sec = res.mSection;
                    Paragraph para = sec.Blocks.LastBlock as Paragraph;
                    if (para != null)
                    {
                        para.Inlines.Clear();
                        //NTAppState.getMainWindow().parseResMsg(para, res, ret, outLen);
                    }
                    sec.BringIntoView();
                    mSearchTextIndex = outLen;
                    mSearchSecIndex = i;
                    if (mSearchTextIndex >= text.Length)
                    {
                        mSearchSecIndex++;
                        mSearchTextIndex = 0;
                    }
                    return sec;
                }
                mSearchTextIndex = 0;
            }
            for (int i = 0; i < mSearchSecIndex; i++)
            {
                NTRes res = mResList[i];
                string text = res.mMsg;
                int outLen;
                int ret = mVagueSearch.match(text, mSearchTextIndex, out outLen);
                if (ret >= 0)
                {
                    Section sec = res.mSection;
                    Paragraph para = sec.Blocks.LastBlock as Paragraph;
                    if (para != null)
                    {
                        para.Inlines.Clear();
                        //NTAppState.getMainWindow().parseResMsg(para, res, ret, outLen);
                    }
                    sec.BringIntoView();
                    mSearchTextIndex = outLen;
                    mSearchSecIndex = i;
                    if (mSearchTextIndex >= text.Length)
                    {
                        mSearchSecIndex++;
                        mSearchTextIndex = 0;
                    }
                    return sec;
                }
                mSearchTextIndex = 0;
            }
            mSearchSecIndex = 0;
            mSearchTextIndex = 0;
            return null;
        }

        public Section SearchPrev()
        {
            if (mVagueSearch == null)
                return null;

            int len = mResList.Count;
            if (mSearchSecIndex < 0)
                mSearchSecIndex = len - 1;

            for (int i = mSearchSecIndex; i >= 0; i--)
            {
                NTRes res = mResList[i];
                string text = res.mMsg;
                int outLen;
                int ret = mVagueSearch.match(text, mSearchTextIndex, out outLen);
                if (ret >= 0)
                {
                    Section sec = res.mSection;
                    Paragraph para = sec.Blocks.LastBlock as Paragraph;
                    if (para != null)
                    {
                        para.Inlines.Clear();
                        //NTAppState.getMainWindow().parseResMsg(para, res, ret, outLen);
                    }
                    sec.BringIntoView();
                    mSearchTextIndex = outLen;
                    mSearchSecIndex = i;
                    if (mSearchTextIndex >= text.Length)
                    {
                        mSearchSecIndex--;
                        mSearchTextIndex = 0;
                    }
                    return sec;
                }
                mSearchTextIndex = 0;
            }
            for (int i = len - 1; i > mSearchSecIndex; i--)
            {
                NTRes res = mResList[i];
                string text = res.mMsg;
                int outLen;
                int ret = mVagueSearch.match(text, mSearchTextIndex, out outLen);
                if (ret >= 0)
                {
                    Section sec = res.mSection;
                    Paragraph para = sec.Blocks.LastBlock as Paragraph;
                    if (para != null)
                    {
                        para.Inlines.Clear();
                        //NTAppState.getMainWindow().parseResMsg(para, res, ret, outLen);
                    }
                    sec.BringIntoView();
                    mSearchTextIndex = outLen;
                    mSearchSecIndex = i;
                    if (mSearchTextIndex >= text.Length)
                    {
                        mSearchSecIndex--;
                        mSearchTextIndex = 0;
                    }
                    return sec;
                }
                mSearchTextIndex = 0;
            }
            mSearchSecIndex = len -1;
            mSearchTextIndex = 0;
            return null;
        }

#endif

        public void clearLoadedDat()
        {
            mResList.Clear();
            mWriteNoList.Clear();
            mBookmarkList.Clear();
            LastMod = string.Empty;
            LastWrite = string.Empty;
            ReadCnt = 0;
        }

        public void delDat()
        {
           

            //MainWindow wnd = NTAppState.getMainWindow();
            //wnd.removeThreadFromTabCtrl(this);

            clearLoadedDat();

            NTFileAccess.deleteDatDir(mBoard.mName, mDat);

            Thread th = new Thread(delDat_Worker);
            string[] s = new string[2];
            s[0] = mBoard.mName;
            s[1] = mDat;
            th.Start(s);

        }

        static void delDat_Worker(object o)
        {
            string[] s = o as string[];
            if (s == null)
                return;

            string result = NTHttpAccess.ntDeleteDatValue(s[0], s[1]);
            NTDebug.l(result);

        }

#if false
        static void OnResCntChanged(DependencyObject d, DependencyPropertyChangedEventArgs e)
        {
            NTThreadTitle tt = (NTThreadTitle)d;
            tt.RemainCnt = (int)e.NewValue - tt.ReadCnt;
        }

        static void OnReadCntChanged(DependencyObject d, DependencyPropertyChangedEventArgs e)
        {
            NTThreadTitle tt = (NTThreadTitle)d;
            if(tt.ResCnt < (int)e.NewValue)
                tt.ResCnt = (int)e.NewValue;
            else
                tt.RemainCnt = tt.ResCnt - (int)e.NewValue;
        }
#endif

        public NTRes findResById(string id)
        {
            if ("???".Equals(id))
                return null;
            foreach (NTRes res in mResList)
            {
                if (id.Equals(res.mId))
                    return res;
            }
            return null;
        }


        public NTThreadTitle(NTBoard board)
            : this(board, false)
        {
        }
        
        public NTThreadTitle(NTBoard board, bool localDat)
        {
            mBoard = board;
            mLocalDat = localDat;
        }

        

#if false
        public int SeqNo
        {
            set { SetValue(SeqNoProperty, value); }
            get { return (int)GetValue(SeqNoProperty); }
        }
        public string Title
        {
            set { SetValue(TitleProperty, value); }
            get { return (string)GetValue(TitleProperty); }
        }
        public int ResCnt
        {
            set { SetValue(ResCntProperty, value); }
            get { return (int)GetValue(ResCntProperty); }
        }
        public int ReadCnt
        {
            set { SetValue(ReadCntProperty, value); }
            get { return (int)GetValue(ReadCntProperty); }
        }
        public int RemainCnt
        {
            set { SetValue(RemainCntProperty, value); }
            get { return (int)GetValue(RemainCntProperty); }
        }
        public string LastMod
        {
            set { SetValue(LastModProperty, value); }
            get { return (string)GetValue(LastModProperty); }
        }
        public string LastWrite
        {
            set { SetValue(LastWriteProperty, value); }
            get { return (string)GetValue(LastWriteProperty); }
        }
#endif    

       // static char[] LINE_BREAK = { '\n' };
        const string COLUMN_BREAK = "<>";

        public void parseMachiBBSDat(string source)
        {
            mResList.Clear();

            string [] lines = NTTextUtiles.splitLine(source);//.Split(LINE_BREAK);
            int n = 1;
            foreach (string line in lines)
            {
                int n0 = line.IndexOf(COLUMN_BREAK);
                if (n0 < 0)
                    continue;
                int n1 = line.IndexOf(COLUMN_BREAK, n0 + COLUMN_BREAK.Length);
                if (n1 < 0)
                    continue;
                int n2 = line.IndexOf(COLUMN_BREAK, n1 + COLUMN_BREAK.Length);
                if (n2 < 0)
                    continue;
                int n3 = line.IndexOf(COLUMN_BREAK, n2 + COLUMN_BREAK.Length);
                if (n3 < 0)
                    continue;
                int n4 = line.IndexOf(COLUMN_BREAK, n3 + COLUMN_BREAK.Length);
                if (n4 < 0)
                    continue;
                string seqNoStr = line.Substring(0, n0);
                int seqNo;
                if (!int.TryParse(seqNoStr, out seqNo))
                {
                    seqNo = n;
                }
                if (seqNo > n)
                {
                    for (int i = n; n < seqNo; n++)
                    {
                        NTRes dummy = new NTRes(this, n, string.Empty, string.Empty, string.Empty, string.Empty);
                        dummy.mIsDummy = true;
                        mResList.Add(dummy);
                    }
                }
                string name = line.Substring(n0+2, n1-(n0+2)).Trim();
                string mail = line.Substring(n1 + 2, n2 - (n1 + 2)).Trim();
                string date_id = line.Substring(n2 + 2, n3 - (n2 + 2)).Trim();
                string msg = line.Substring(n3 + 2, n4 - (n3 + 2));//.Trim();
                NTRes res = new NTRes(this, seqNo, name, mail, date_id, msg);
                n++;
                mResList.Add(res);
            }

            ReadCnt = mResList.Count;
            RemainCnt =  ResCnt - ReadCnt;

            constructResRelations(mResList);

        }

        //static object mLockParseDat = new object();//TEST 2012-11-22

        public void parseDat(string source)
        {
            //lock (mLockParseDat)//TEXT 2012-11-22
            //{
                if (mBoard.mMachiBBS)
                {
                    parseMachiBBSDat(source);
                    return;
                }
                mResList.Clear();

                string[] lines = NTTextUtiles.splitLine(source);//.Split(LINE_BREAK);
                int n = 1;
                foreach (string line in lines)
                {
                    int n1 = line.IndexOf(COLUMN_BREAK);
                    if (n1 < 0)
                        continue;
                    int n2 = line.IndexOf(COLUMN_BREAK, n1 + COLUMN_BREAK.Length);
                    if (n2 < 0)
                        continue;
                    int n3 = line.IndexOf(COLUMN_BREAK, n2 + COLUMN_BREAK.Length);
                    if (n3 < 0)
                        continue;
                    int n4 = line.IndexOf(COLUMN_BREAK, n3 + COLUMN_BREAK.Length);
                    if (n4 < 0)
                        continue;

                    string name = line.Substring(0, n1).Trim();
                    string mail = line.Substring(n1 + 2, n2 - (n1 + 2)).Trim();
                    string date_id = line.Substring(n2 + 2, n3 - (n2 + 2)).Trim();
                    string msg = line.Substring(n3 + 2, n4 - (n3 + 2));//.Trim();
                    NTRes res = new NTRes(this, n++, name, mail, date_id, msg);

                    mResList.Add(res);
                }

                ReadCnt = mResList.Count;
                RemainCnt = ResCnt - ReadCnt;

                constructResRelations(mResList);
           //}//TEST 2012-11-22

        }
        
        public void queryThreadAttrFromCloud()
        {

        }

        public int findWroteMsg(int startSeqNo)
        {
            if(mWroteMsg == null || mWroteMsg.Length == 0)
                return -1;

            string target = mWroteMsg.Trim().Replace("\r\n", " <br> ");
            mWroteMsg = string.Empty;

            int len = mResList.Count;
            int i = startSeqNo - 1;
            for( ; i < len; i++)
            {
                NTRes res = mResList[i];
                string msg = res.mMsg.Trim();
                if (target.Equals(msg))
                {
                    //mWroteMsg = string.Empty;
                    res.mWroteMsg = true;
                    return res.mSeqNo;
                }
            }
            return -1;
        }

        public NTRes findRes(int seqNo)
        {
            foreach (NTRes res in mResList)
            {
                if (res.mSeqNo == seqNo)
                    return res;
            }
            return null;
        }

        public void updateReadCntOnCloud()
        {
            if (!NTUserPreference.NTCloudIsEnabled)
                return;

            Thread th = new Thread(updateReadCntOnCloud_Worker);
            string[] arr = new string[3];
            arr[0] = mBoard.mName;
            arr[1] = mDat;
            arr[2] = ReadCnt.ToString();
            th.Start(arr);
        }

        static void updateReadCntOnCloud_Worker(object o)
        {
            string [] sArr = o as string[];
            if (sArr == null)
                return;
            string attrType;
            if (NTUserPreference.AESEnabled)
                attrType = "4";
            else
                attrType = "1";

            string result;
            if (NTUserPreference.NTUserCloudIsEnabled)
            {
                result = NTHttpAccess.UserCloudUpdateReadCount(
                    sArr[0], sArr[1], attrType/*"1"*/, sArr[2]);
            }
            else
            {
                result = NTHttpAccess.ntUpdateAttrValue(
                    sArr[0], sArr[1], attrType/*"1"*/, sArr[2]);
            }
            if (result != null)
                NTDebug.l(result);
        }

        public void addWriteTagOnCloud(int SeqNo)
        {
            if (!NTUserPreference.NTCloudIsEnabled)
                return;

            Thread th = new Thread(addWriteTagOnCloud_Worker);
            string[] arr = new string[3];
            arr[0] = mBoard.mName;
            arr[1] = mDat;
            arr[2] = SeqNo.ToString();
            th.Start(arr);
        }

        public void addBookmarkOnCloud(int SeqNo)
        {
            if (!NTUserPreference.NTCloudIsEnabled)
                return;

            Thread th = new Thread(addBookmarkOnCloud_Worker);
            string[] arr = new string[3];
            arr[0] = mBoard.mName;
            arr[1] = mDat;
            arr[2] = SeqNo.ToString();
            th.Start(arr);
        }

        public void removeBookmarkOnCloud(int SeqNo)
        {
            if (!NTUserPreference.NTCloudIsEnabled)
                return;

            Thread th = new Thread(removeBookmarkOnCloud_Worker);
            string[] arr = new string[3];
            arr[0] = mBoard.mName;
            arr[1] = mDat;
            arr[2] = SeqNo.ToString();
            th.Start(arr);
        }

        static void addWriteTagOnCloud_Worker(object o)
        {
            string[] sArr = o as string[];
            if (sArr == null)
                return;

            string attrType;
            if (NTUserPreference.AESEnabled)
                attrType = "5";
            else
                attrType = "2";
            string result;
            if (NTUserPreference.NTUserCloudIsEnabled)
            {
                result = NTHttpAccess.UserCloudUpdateAttrValue(
                    sArr[0], sArr[1], attrType, sArr[2]);
            }
            else
            {
                result = NTHttpAccess.ntUpdateAttrValue(
                    sArr[0], sArr[1], attrType/*"2"*/, sArr[2]);
            }
            if (result != null)
                NTDebug.l(result);
        }


        static void addBookmarkOnCloud_Worker(object o)
        {
            string[] sArr = o as string[];
            if (sArr == null)
                return;

            string attrType;
            if (NTUserPreference.AESEnabled)
                attrType = "6";
            else
                attrType = "3";
            string result;
            if (NTUserPreference.NTUserCloudIsEnabled)
            {
                result = NTHttpAccess.UserCloudUpdateAttrValue(
                    sArr[0], sArr[1], attrType, sArr[2]);
            }
            else
            {
                result = NTHttpAccess.ntUpdateAttrValue(
                    sArr[0], sArr[1], attrType/*"3"*/, sArr[2]);
            }
            if (result != null)
                NTDebug.l(result);
        }



        static void removeBookmarkOnCloud_Worker(object o)
        {
            string[] sArr = o as string[];
            if (sArr == null)
                return;
            string attrType;
            if (NTUserPreference.AESEnabled)
                attrType = "6";
            else
                attrType = "3";

            string result;
            if (NTUserPreference.NTUserCloudIsEnabled)
            {
                result = NTHttpAccess.UserCloudDeleteAttrValue(
                    sArr[0], sArr[1], attrType, sArr[2]);
            }
            else
            {
                result = NTHttpAccess.ntDeleteAttrValue(
                    sArr[0], sArr[1], attrType/*"3"*/, sArr[2]);
            }

            if (result != null)
                NTDebug.l(result);
        }
        void constructResRelations(List<NTRes> resList)
        {
            foreach (NTRes res in resList)
            {
                int[] arr = res.mRefferTo;
                if (arr != null)
                {
                    foreach (int n in arr)
                    {
                        if (n <= resList.Count && n > 0)
                        {
                            resList[n - 1].mRefferFrom.Add(res.mSeqNo);
                        }
                    }
                }
            }
        }

        public void setupBookmark()
        {
            foreach(NTRes res in mResList)
            {
                foreach(int n in mBookmarkList)
                {
                    if(res.mSeqNo == n)
                    {
                        res.mBookmark = true;
                        break;
                    }
                }
            }
        }

        public void setupWriteTag()
        {
            foreach (NTRes res in mResList)
            {
                foreach (int n in mWriteNoList)
                {
                    if (res.mSeqNo == n)
                    {
                        res.mWroteMsg = true;
                        if (res.mRefferFrom != null)
                        {
                            foreach (int n2 in res.mRefferFrom)
                            {
                                NTRes res2 = findRes(n2);
                                if (res2 != null)
                                {
                                    res2.mIsRepray = true;
                                }
                            }
                        }
                        break;
                    }
                }
            }
        }

        
        public void addWriteTag(int seqNo)
        {
            if (mWriteNoList.Contains(seqNo))
                return;

            mWriteNoList.Add(seqNo);
            /*int numRead;
            int[] writes;
            int[] bookmarkes;
            string lastWrite;

            NTFileAccess.retrieveDatAttrToFile(mBoard.mName, mDat,
                out numRead, out writes, out bookmarkes, out lastWrite);

            NTFileAccess.storeDatAttrToFile(mBoard.mName, mDat,
                numRead, mWriteNoList.ToArray(), bookmarkes);
            */
            addWriteTagOnCloud(seqNo);

        }
        public void addBookmark(int seqNo)
        {
            if (mBookmarkList.Contains(seqNo))
                return;

            mBookmarkList.Add(seqNo);
            int numRead;
            int[] writes;
            int[] bookmarkes;
            string lastWrite;

            NTFileAccess.retrieveDatAttrToFile(mBoard.mName, mDat,
                out numRead, out writes, out bookmarkes, out lastWrite);

            NTFileAccess.storeDatAttrToFile(mBoard.mName, mDat,
                numRead, writes, mBookmarkList.ToArray());

            addBookmarkOnCloud(seqNo);

        }
        public void removeBookmark(int seqNo)
        {
            int numRead;
            int[] writes;
            int[] bookmarkes;
            string lastWrite;

            NTFileAccess.retrieveDatAttrToFile(mBoard.mName, mDat,
                out numRead, out writes, out bookmarkes, out lastWrite);
            for (int i = 0; i < mBookmarkList.Count; i++)
            {
                int num = mBookmarkList[i];
                if (seqNo == num)
                {
                    mBookmarkList.RemoveAt(i);
                    i--;
                }
            }

            NTFileAccess.storeDatAttrToFile(mBoard.mName, mDat, numRead, writes, mBookmarkList.ToArray());

            removeBookmarkOnCloud(seqNo);

        }

        public void FocusNextBookmark()
        {
            if (0 == mBookmarkList.Count)
                return;

            mCurrentBookmarkFocus++;

            if (mCurrentBookmarkFocus >= mBookmarkList.Count)
                mCurrentBookmarkFocus = 0;

            int seqNo = mBookmarkList[mCurrentBookmarkFocus];
            foreach (NTRes res in mResList)
            {
                if (res.mSeqNo == seqNo)
                {
                    Section sec = res.mSection;
                    if (sec != null)
                        sec.BringIntoView();
                    break;
                }
            }
        }

        public void parseAttr(string strAttr)
        {
            if (strAttr == null || strAttr.Length == 0)
                return;

            string[] lines = NTTextUtiles.splitLine(strAttr);
            int len = lines.Length;
            if (len == 0)
                return;
            int result;
            if (!int.TryParse(lines[0], out result))
                return;
            if (100 != result)
                return;

            for (int i = 2; i < len; i++)
            {
                string[] values = lines[i].Split(NTTextUtiles.EQUAL_VALUE);
                if (values.Length != 2)
                    continue;
                switch (values[0])
                {
                    case "1":
                    case "4":
                        int num;
                        if (int.TryParse(values[1], out num))
                            ReadCnt = num;
                        break;
                    case "2":
                    case "5":
                        if (int.TryParse(values[1], out num))
                            mWriteNoList.Add(num);
                        break;
                    case "3":
                    case "6":
                        if (int.TryParse(values[1], out num))
                            mBookmarkList.Add(num);
                        break;
                }
            }
        }
        



    }
}
