﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Shapes;
using NT2chView.NtNet;
using NT2chView.NtHtml;
using System.Web;
using NT2chView.NtFile;


namespace NT2chView
{
    /// <summary>
    /// NTWriteResWindow.xaml の相互作用ロジック
    /// </summary>
    public partial class NTWriteResWindow : Window
    {
        NTThreadTitle mThread;
        MainWindow mMainWindow;
        string mDatName;
        string mBoardName;
        string mHostName;
        //string mSiteMsg;
        string[] mHistory = null;


        public NTWriteResWindow(MainWindow main, NTThreadTitle thread, string siteMsg)
        {

            InitializeComponent();
            mMainWindow = main;
            mThread = thread;
            //mSiteMsg = siteMsg;

            if (thread.mBoard.mMachiBBS)
            {
                chkWriteTroughP2.IsEnabled = false;
            }
            else
            {
                chkWriteTroughP2.IsChecked = NTUserPreference.P2IsEnabled;
            }
            chkSage.IsChecked = NTUserPreference.SageIsEnabled;
            Title = thread.Title;

            mHistory = NTPersistentFileAccess.retrieveWriteHistroy();
            if (mHistory == null || mHistory.Length == 0)
            {
                btnWriteHistory.IsEnabled = false;
            }


            if (siteMsg != null && siteMsg.Length > 0)
            {
                txtMsg.Text = siteMsg;
            }

            txtMsg.Focus();
        }

        private void btnWriteResClose_Click(object sender, RoutedEventArgs e)
        {
            storeMsgToHistory();
            Close();
        }

        private void btnWriteRes_Click(object sender, RoutedEventArgs e)
        {
            WriteRes_Invoke();
        }

        private void WriteRes_Invoke()
        {
            mThread.mWroteMsg = string.Empty;
            setupServerParam();
            string [] args = preWriteRes();

            bool result = false;
            if (!NTHttpUtils.isValid2chAddress(mThread.mBoard.mAddress))
            {
                if (mThread.mBoard.mMachiBBS)
                {
                    if (writeResMachiBBS(args, null))
                    {
                        result = true;
                    }

                }
                else
                {
                    if (writeResExternalBBS(mThread.mBoard.mAddress,  args, null))
                    {
                        result = true;
                    }
                }
            }
            else{
                if (NTUserPreference.P2IsEnabled)
                {
                    if (writeResP2(args, null))
                    {
                        result = true;
                    }
                }
                else
                {
                    if (writeRes(args, null))
                    {
                        result = true;
                    }
                }
            }
            if (result)
            {
                mThread.mWroteMsg = txtMsg.Text;
                mMainWindow.WriteResCallback(true, mThread);
                storeMsgToHistory();
                Close();
            }
        }

        private bool setupServerParam()
        {
            NTBoard board = mThread.mBoard;

            mDatName = NTHttpUtils.ridSuffixFromDatName(mThread.mDat);

            string hostName;
            string boardName;

            if (!NTHttpUtils.parseHostAddress(board.mAddress, out hostName, out boardName))
                return false;

            mBoardName = boardName;
            mHostName = hostName;
            return true;
        }
        private string []  preWriteRes()
        {

            if (!setupServerParam())
                return null;

            string mail;
            string name;
            string msg;

            if (chkSage.IsChecked.HasValue && ((bool)chkSage.IsChecked))
                mail = "sage";
            else
                mail = txtMail.Text;

            name = txtName.Text;

            msg = txtMsg.Text;

            mail = (mail == null) ? string.Empty : mail;
            name = (name == null) ? string.Empty : name;
            msg = (msg == null) ? string.Empty : msg;


            string[] args = new string[7];

            args[0] = mHostName;
            args[1] = mBoardName;
            args[2] = mDatName;
            args[3] = name;
            args[4] = mail;
            args[5] = msg;
            args[6] = NTHttpUtils.DEFAULT_SUBMIT;

            return args;

            

        }

        private bool writeResP2(string[] args, List<KeyValuePair<string, string>> extra)
        {


            string htmlStr = NTHttpAccess.writeResP2(args, extra, mThread.ResCnt, mThread.Title, false);
            
            if (null == htmlStr)
            {
                MessageBox.Show("サーバーの応答が不正です");
                return false;
            }

            FlowDocument doc = new FlowDocument();
            NTHtmlParser htmlParser = new NTHtmlParser(doc);
            string parsedHtml = htmlParser.parse(htmlStr);
            if (parsedHtml == null)
            {
                MessageBox.Show("サーバーの応答が不正です");
                return false;
            }

            X_CONFIRM_RESULT xResult = NTHtmlWriteResParser.validateResult(htmlParser);
            if (xResult == X_CONFIRM_RESULT.SUCCESS)
                return true;

            NTDebug.l(parsedHtml);
            NTWriteResResultWindow w
                = new NTWriteResResultWindow(htmlParser.getTitle(), doc, xResult);
            w.Owner = this;
            bool? result = w.ShowDialog();

            if (result.HasValue && ((bool)result))
            {
                List<KeyValuePair<string, string>> list = htmlParser.mInputTypeSubmit;
                if (list.Count > 0)
                {
                    args[6] = list[0].Value;
                    return writeResP2(args, htmlParser.mInputTypeHidden);
                }

            }
            return false;
        }

        private bool writeRes(string[] args, List<KeyValuePair<string, string>> extra)
        {


            string htmlStr = NTHttpAccess.writeRes(args, extra);
            
            if (null == htmlStr)
            {
                MessageBox.Show("サーバーの応答が不正です");
                return false;
            }
            FlowDocument doc = new FlowDocument();
            NTHtmlParser htmlParser = new NTHtmlParser(doc);
            string parsedHtml = htmlParser.parse(htmlStr);
            if (parsedHtml == null)
            {
                MessageBox.Show("サーバーの応答が不正です");
                return false;
            }

            X_CONFIRM_RESULT xResult = NTHtmlWriteResParser.validateResult(htmlParser);
            if (xResult == X_CONFIRM_RESULT.SUCCESS)
                return true;

            NTDebug.l(parsedHtml);
            NTWriteResResultWindow w
                = new NTWriteResResultWindow(htmlParser.getTitle(), doc, xResult);
            w.Owner = this;
            bool? result = w.ShowDialog();

            if (result.HasValue && ((bool)result))
            {
                List<KeyValuePair<string, string>> list = htmlParser.mInputTypeSubmit;
                if (list.Count > 0)
                {
                    args[6] = list[0].Value;
                    return writeRes(args, htmlParser.mInputTypeHidden);
                }

            }
            return false;
        }

        private bool writeResMachiBBS(string[] args, List<KeyValuePair<string, string>> extra)
        {
            //string host, bbs;
            string name = args[3];
            string mail = args[4];
            string msg = args[5];
 
            //if (!NTHttpUtils.splitMachiAddress(args[0], out host, out bbs))
            //    return false;

            string key = NTHttpUtils.ridSuffixFromCgiName(args[2]);

        //            public static string getWriteHtmlMachiBBS(string host, string board, string key)
       // {
            string a1 = "/bbs/read.pl?IMODE=TRUE&KEY=";//1341122306
            string a2 = "&BBS=";//tokyo
            string a3 = "&WRITEBOX=TRUE";

            string url1 = "http://"+args[0] + a1 + key + a2 + args[1] + a3;


            //string writeHtml = NTHttpAccess.getWriteHtmlMachiBBS(url1);
            string writeHtml = NTHttpAccess.getWriteHtmlExternalBBS(args[0], url1);
            if (writeHtml == null || writeHtml.Length == 0)
                return false;

            NTHtmlParser parser = new NTHtmlParser(new FlowDocument());
            string resultStr = parser.parse(writeHtml);


            NTDebug.l(resultStr);

            Encoding enc = Encoding.GetEncoding(NTAppState.HOST_2CH_ENCODING);

            List<KeyValuePair<string, string>> fAttr = parser.mFormAttributes;
            if (fAttr == null)
                return false;
            string url2 = null;
            //
            foreach (KeyValuePair<string, string> pair in fAttr)
            {
                if (pair.Key.Equals("action", StringComparison.CurrentCultureIgnoreCase))
                {
                    string s = pair.Value;
                    int idx = s.IndexOf('/');
                    if(idx < 0)
                        break;
                    s = s.Substring(idx);
                    idx = s.IndexOf('?');
                    if(idx >= 0)
                        s = s.Substring(0,idx);
                    url2 = "http://" + args[0] + "/bbs" + s;
                    break;
                }
            }
            if(url2 == null)
                return false;

            StringBuilder postData = new StringBuilder(256);
            
            postData.Append("NAME=").Append(HttpUtility.UrlEncode(name, enc));
            postData.Append("&MAIL=").Append(HttpUtility.UrlEncode(mail, enc));
            foreach(KeyValuePair<string,string> pair3 in parser.mInputTypeHidden)
            {
                string val = HttpUtility.UrlEncode(pair3.Value, enc);
                NTDebug.l(val + " :"+val.Length);

                postData.Append('&').Append(pair3.Key).Append('=')
                    .Append(val);
            }
            postData.Append("&MESSAGE=").Append(HttpUtility.UrlEncode(msg, enc));



            NTDebug.l(postData.ToString());

            resultStr = NTHttpAccess.writeResExternalBBS(url2, url1, "http://" + args[0], postData.ToString());

            NTDebug.l(resultStr);

            if (resultStr == null)
            {
                MessageBox.Show("サーバーの応答が不正です");
                return false;
            }

            FlowDocument doc = new FlowDocument();
            parser = new NTHtmlParser(doc);
            parser.parse(resultStr);

            X_CONFIRM_RESULT xResult = NTHtmlWriteResParser.validateResult(parser);
            if (xResult != X_CONFIRM_RESULT.ERROR)
                return true;

            NTWriteResResultWindow w
                = new NTWriteResResultWindow(parser.getTitle(), doc, xResult);
            w.Owner = this;
            bool? result = w.ShowDialog();
            if (result.HasValue && ((bool)result))
            {
                List<KeyValuePair<string, string>> list = parser.mInputTypeSubmit;
                if (list.Count > 0)
                {
                    args[6] = list[0].Value;
                    return writeResMachiBBS(args, parser.mInputTypeHidden);
                }

            }
            return false;
        }




        private List<KeyValuePair<string,string>> 
                parseWriteResPostParams(NTHtmlParser parser, string key, string from, string mail, string msg)
        {

            List<KeyValuePair<string, string>> pLIst = new List<KeyValuePair<string, string>>();

            bool setSubmit = false;
            foreach (KeyValuePair<string, string> pair in parser.mInputTypeSubmit)
            {
                string v = pair.Value;
                if (v.Contains("W") || v.Contains("書"))
                {
                    pLIst.Add(pair);
                    setSubmit = true;
                    break;
                }
            }
            if(!setSubmit)
                return null;

            bool setKey = false;
            foreach (KeyValuePair<string, string> pair in parser.mInputTypeHidden)
            {
                string k = pair.Key;
                bool dup = false;
                    
                switch (k)
                {
                    case "KEY":
                    case "key":
                        if (!setKey)
                        {
                            pLIst.Add(new KeyValuePair<string, string>(k, key));
                            setKey = true;
                        }
                        break;
                    default:
                        foreach (KeyValuePair<string, string> pair2 in pLIst)
                        {
                            if (pair2.Key.Equals(k, StringComparison.CurrentCultureIgnoreCase))
                            {
                                dup = true;
                                break;
                            }
                        }
                        if(!dup)
                            pLIst.Add(pair);
                        break;

                }
            }

            bool setFrom = false;
            bool setMail = false;
            foreach (KeyValuePair<string, string> pair in parser.mInputTypeText)
            {
                string k = pair.Key;
                 switch (k)
                {
                    case "FROM":
                    case "from":
                    case "name":
                    case "NAME":
                        if (!setFrom)
                        {
                            pLIst.Add(new KeyValuePair<string, string>(k, from));
                            setFrom = true;
                        }
                        break;
                    case "mail":
                    case "MAIL":
                    case "TO":
                    case "to":
                        if (!setMail)
                        {
                            pLIst.Add(new KeyValuePair<string, string>(k, mail));
                            setMail = true;
                        }
                        break;
                }
                if (setFrom && setMail)
                    break;
            }
            if (!setMail || !setMail)
                return null;

            bool setMsg = false;
            foreach (KeyValuePair<string, string> pair in parser.mTextAreaAttributes)
            {
                string v = pair.Value;
                switch (v)
                {
                    case "MESSAGE":
                    case "message":
                        if (!setMsg)
                        {
                            pLIst.Add(new KeyValuePair<string, string>(v, msg));
                            setMsg = true;
                        }
                        break;
                }
                if (setMsg)
                    break;

            }
            if (!setMsg)
                return null;

            return pLIst;
        }


        private bool writeResExternalBBS(string baseUrl, string[] args, List<KeyValuePair<string, string>> extra)
        {
            string host = args[0];//, bbs;
            string name = args[3];
            string mail = args[4];
            string msg = args[5];


            string key = args[2];
            int idx = baseUrl.IndexOf(host);
            if (idx < 0)
                return false;
            idx += host.Length;
            string url = baseUrl.Substring(0, idx) + "/test/read.cgi" + 
                baseUrl.Substring(idx) + key + '/';
            NTHtmlParser parser = null;
            string resultStr = null;

            Mouse.OverrideCursor = Cursors.Wait;

            try
            {

                string writeHtml = NTHttpAccess.getWriteHtmlExternalBBS(host, url);
                if (writeHtml != null && writeHtml.Length > 0)
                {
                    parser = new NTHtmlParser(new FlowDocument());
                    resultStr = parser.parse(writeHtml);
                }

                if (writeHtml == null || parser == null ||
                    parser.mFormAttributes.Count == 0 || parser.mInputTypeHidden.Count == 0)
                {
                    url = baseUrl;
                    writeHtml = NTHttpAccess.getWriteHtmlExternalBBS(host, url);
                    if (writeHtml == null || writeHtml.Length == 0)
                        return false;

                    parser = new NTHtmlParser(new FlowDocument());
                    resultStr = parser.parse(writeHtml);
                    if (parser.mFormAttributes.Count == 0 || parser.mInputTypeHidden.Count == 0)
                        return false;
                }

                string newUrl = NTHtmlUtils.parseActionUrl(host, url, parser);

                if (newUrl == null)
                    return false;

                List<KeyValuePair<string, string>> pList = parseWriteResPostParams(parser, key, name, mail, msg);
                if (pList == null)
                    return false;

                Encoding enc = Encoding.GetEncoding(NTAppState.HOST_2CH_ENCODING);
                StringBuilder postData = new StringBuilder(256);

                foreach (KeyValuePair<string, string> pair in pList)
                {
                    if (postData.Length != 0)
                        postData.Append('&');
                    postData.Append(pair.Key).Append('=')
                        .Append(HttpUtility.UrlEncode(pair.Value, enc));

                }

                NTDebug.l(postData.ToString());

                resultStr = NTHttpAccess.writeResExternalBBS(newUrl, url, args[0], postData.ToString());
            }
            finally
            {
                Mouse.OverrideCursor = null;
            }

            NTDebug.l(resultStr);
            if (resultStr == null)
            {
                MessageBox.Show("サーバーの応答が不正です");
                return false;
            }

            FlowDocument doc = new FlowDocument();
            parser = new NTHtmlParser(doc);
            parser.parse(resultStr);

            X_CONFIRM_RESULT xResult = NTHtmlWriteResParser.validateResult(parser);
            if (xResult != X_CONFIRM_RESULT.ERROR)
                return true;

            NTWriteResResultWindow w
                = new NTWriteResResultWindow(parser.getTitle(), doc, xResult);
            w.Owner = this;
            bool? result = w.ShowDialog();
            return false;
        }


        private void chkSage_Checked(object sender, RoutedEventArgs e)
        {
            NTDebug.l("checked!");
            NTUserPreference.SageIsEnabled = true;
            //NTUserPreference.savePreferences();
        }

        private void chkSage_Unchecked(object sender, RoutedEventArgs e)
        {
            NTDebug.l("unchecked!");
            NTUserPreference.SageIsEnabled = false;
            //NTUserPreference.savePreferences();
        }
        private void chkWriteTroughP2_Checked(object sender, RoutedEventArgs e)
        {
            //NTDebug.l("checked!");
            NTUserPreference.P2IsEnabled = true;
           // NTUserPreference.savePreferences();
        }

        private void chkWriteTroughP2_Unchecked(object sender, RoutedEventArgs e)
        {
            //NTDebug.l("checked!");
            NTUserPreference.P2IsEnabled = false;
            //NTUserPreference.savePreferences();
        }

        private void storeMsgToHistory()
        {
            string msg = txtMsg.Text;

            if (msg.Length == 0)
                return;


            string newMsg = NTTextFormat.convertLineBreakToHtmlTag(msg);

            NTPersistentFileAccess.storeWriteHistory(newMsg);

        }

        //bool mLeftShift = false;
        //bool mRightShift = false;
        private void NTWriteResWindow_PreviewKeyDown(object sender, KeyEventArgs e)
        {
            switch (e.Key)
            {
                case Key.LeftShift:
                   // mLeftShift = true;
                    break;
                case Key.RightShift:
                    //mRightShift = true;
                    break;
                case Key.Enter:
                    if(Keyboard.Modifiers == ModifierKeys.Shift)
                    //if (mLeftShift || mRightShift)
                    {
                        NTDebug.l("Pressed Shift + Enter!");
                        WriteRes_Invoke();
                        e.Handled = true;
                    }
                    break;
                case Key.Escape:
                    if (Keyboard.Modifiers == ModifierKeys.Shift)
                    {
                        NTDebug.l("Pressed ESC!");
                        e.Handled = true;
                        storeMsgToHistory();
                        Close();
                    }
                    break;
            }
        }

        private void NTWriteResWindow_PreviewKeyUp(object sender, KeyEventArgs e)
        {
            if (e.Key == Key.LeftShift)
            {
                //mLeftShift = false;
            }
            else if (e.Key == Key.RightShift)
            {
                //mRightShift = false;
            }
        }

        private void btnWriteHistory_Click(object sender, RoutedEventArgs e)
        {
            NTWriteResHistoryPopup popup = new NTWriteResHistoryPopup(this, mHistory);
            popup.show();
        }

        public void setMsg(string msg)
        {
            txtMsg.Text = msg;
        }
    }
}
