﻿using System;
using System.Collections.Generic;
using System.Text;

namespace NT2chView.NtFile
{
    class NTFileUtil
    {
        static char[] IGNORE_CHAR = {'\\',/*'/',*/':','*','?','"','<','>','|'};

        public static bool Url2FilePath(string url, out string pathName, out string fileName)
        {
            pathName = string.Empty;
            fileName = string.Empty;

            if (url == null || url.Length == 0)
                return false;

            int idx = url.IndexOf("://");
            if (idx < 0)
                return false;

            string address = url.Substring(idx + "://".Length);

            idx = address.LastIndexOf('/');
            if (idx < 0)
                return false;
            foreach(char c in IGNORE_CHAR){
                address = address.Replace(c, '・');
            }

            fileName = address.Substring(idx + 1);

            address = address.Substring(0, idx);
            address = address.Replace('/', '\\');

            pathName = NTFileAccess.getImageDir() + address;

            return true;
        }
    }
}
