<<<<<<< HEAD
<?php

/*
 * Nucleus: PHP/MySQL Weblog CMS (http://nucleuscms.org/)
 * Copyright (C) 2002-2012 The Nucleus Group
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * (see nucleus/documentation/index.html#license for more info)
 */
/**
 * A class representing a template
 *
 * @license http://nucleuscms.org/license.txt GNU General Public License
 * @copyright Copyright (C) 2002-2012 The Nucleus Group
 * @version $Id: TEMPLATE.php 1726 2012-04-07 02:23:46Z sakamocchi $
 */
class Template
{
	/**
	 * Template::$id
	 */
	private $id;
	
	/**
	 * Template::__construct()
	 * 
	 * @param	integer	$templateid	id for template
	 * @return	void
	 */
	public function __construct($templateid)
	{
		$this->id = intval($templateid);
		return;
	}
	
	/**
	 * Template::getID()
	 * 
	 * @param	void
	 * @return	integer	id for this instance of Template class
	 */
	public function getID()
	{
		return (integer) $this->id;
	}
	
	/**
	 * Template::createFromName()
	 * 
	 * @statc
	 * @param	string	$name	template name
	 * @return	object	instance of Template class generated by the name
	 */
	static public function createFromName($name)
	{
		return new Template(Template::getIdFromName($name));
	}
	
	/**
	 * Template::getIdFromName()
	 * 
	 * @static
	 * @param	string	$name	template name
	 * @return	integer	id for the template
	 */
	static public function getIdFromName($name)
	{
		$name = DB::quoteValue($name);
		$query = "SELECT tdnumber FROM %s WHERE tdname=%s";
		$query = sprintf($query, sql_table('template_desc'), $name);
		return DB::getValue($query);
	}
	
	/**
	 * Template::updateGeneralInfo()
	 * Updates the general information about the template
	 * 
	 * @param	string	$name	template name
	 * @param	string	$desc	description for this template
	 * @return	void
	 */
	public function updateGeneralInfo($name, $desc)
	{
		$query =  "UPDATE %s SET tdname=%s, tddesc=%s WHERE tdnumber=%d";
		$query = sprintf($query, sql_table('template_desc'), DB::quoteValue($name), DB::quoteValue($desc), (integer) $this->getID());
		DB::execute($query);
		return;
	}
	
	/**
	 * Template::update()
	 * Updates the contents of one part of the template
	 * 
	 * @param	String	$type	value for nucleus_template.tpartname
	 * @param	String	$content	value for nucleus_template.tcontent
	 * @return	Void
	 */
	public function update($type, $content)
	{
		// delete old thingie
		$query = "DELETE FROM %s WHERE tpartname=%s and tdesc=%d";
		$query = sprintf($query, sql_table('template'), DB::quoteValue($type), (integer) $this->getID());
		DB::execute($query);
		
		// write new thingie
		if ( $content )
		{
			$query = "INSERT %s (tcontent, tpartname, tdesc) VALUE (%s, %s, %d)";
			$query = sprintf($query, sql_table('template'), DB::quoteValue($content), DB::quoteValue($type), (integer) $this->getID());
			DB::execute($query);
		}
		return;
	}
	
	/**
	 * Template::deleteAllParts()
	 * Deletes all template parts from the database
	 * 
	 * @param	void
	 * @return	void
	 */
	public function deleteAllParts()
	{
		$query = "DELETE FROM %s WHERE tdesc=%d";
		$query = sprintf($query, sql_table('template'), (integer) $this->getID());
		DB::execute($query);
		return;
	}
	
	/**
	 * Template::createNew()
	 * Creates a new template
	 *
	 * @static
	 * @param	string	$name	name for new template
	 * @param	string	$desc	description for new template
	 * @return	integer	id for new template
	 */
	static public function createNew($name, $desc)
	{
		global $manager;
		
		$manager->notify(
			'PreAddTemplate',
			array(
				'name' => &$name,
				'description' => &$desc
			)
		);
		
		DB::execute('INSERT INTO '.sql_table('template_desc').' (tdname, tddesc) VALUES (' . DB::quoteValue($name) . ',' . DB::quoteValue($desc) . ')');
		$newId = DB::getInsertId();
		
		$manager->notify(
			'PostAddTemplate',
			array(
				'templateid' => $newId,
				'name' => $name,
				'description' => $desc
			)
		);
		
		return $newId;
	}
	
	/**
	 * Reads a template and returns an array with the parts.
	 *
	 * @static
	 * @param 	string	$name name of the template file
	 * @return	array	template array
	 */
	static public function read($name)
	{
		global $manager;
		$manager->notify(
			'PreTemplateRead',
			array(
				'template' => &$name
			)
		);
		
		$query = "SELECT tpartname, tcontent FROM %s, %s WHERE tdesc=tdnumber and tdname=%s";
		$query = sprintf($query, sql_table('template_desc'), sql_table('template'), DB::quoteValue($name));
		$res = DB::getResult($query);
		
		foreach ( $res as $row )
		{
			$template[$row['tpartname']] = $row['tcontent'];
		}
		
		/*
		 * TODO: this is appropriate or not?
		 */
		if ( array_key_exists('LOCALE', $template) && !empty($template['LOCALE']) )
		{
			setlocale(LC_TIME, $template['LOCALE']);
		}
		else
		{
			setlocale(LC_TIME,'');
		}
		
		return $template;
	}
	
	/**
	 * fills a template with values
	 * 
	 * @static
	 * @param	string	$template	Template to be used
	 * @param	array	$values		Array of all the values
	 * @return	string	string filled with tag contents
	 */
	static public function fill($template, $values)
	{
		
		if ( sizeof($values) != 0 )
		{
			foreach ( $values as $key => $value )
			{
				$template = preg_replace('#<%' . preg_quote($key, '#') . '%>#', $value, $template);
			}
		}
		
		// remove non matched template-tags
		return preg_replace('#<%([a-zA-Z]+)?%>#', '', $template);
	}
	
	/**
	 * TEMPLATE::exists()
	 * returns true if there is a template with the given shortname
	 * 
	 * @static
	 * @param	string	$name	template name
	 * @return	boolean	exists or not
	 */
	static public function exists($name)
	{
		$query = "SELECT * FROM %s WHERE tdname=%s";
		$query = sprintf($query, sql_table('template_desc'), DB::quoteValue($name));
		$r = DB::getResult($query);
		return ($r->rowCount() != 0);
	}
	
	/**
	 * TEMPLATE::existsID()
	 * returns true if there is a template with the given ID
	 * 
	 * @static
	 * @param	integer	$id	id for template
	 * @return	bookean	exists or not
	 */
	static public function existsID($id)
	{
		$query = "SELECT * FROM %s WHERE tdnumber=%d";
		$query = sprintf($query, sql_table('template_desc'), (integer) $id);
		$r = DB::getResult($query);
		return ($r->rowCount() != 0);
	}
	
	/**
	 * TEMPLATE::getNameFromId()
	 * 
	 * @static
	 * @param	integer	$id	id for template
	 * @return	object	sql object
	 */
	static public function getNameFromId($id)
	{
		$query = "SELECT tdname as result FROM %s WHERE tdnumber=%d";
		$query = sprintf($query, sql_table('template_desc'), (integer) $id);
		return DB::getValue($query);
	}
	
	/**
	 * TEMPLATE::getDesc()
	 * 
	 * @static
	 * @param	integer	$id	id for template
	 * @return	string	description for the template
	 */
	static public function getDesc($id)
	{
		$query = "SELECT tddesc FROM %s WHERE tdnumber=%d";
		$query = sprintf($query, sql_table('template_desc'), (integer) $id);
		return DB::getValue($query);
	}
}
=======
<?php

/*
 * Nucleus: PHP/MySQL Weblog CMS (http://nucleuscms.org/)
 * Copyright (C) 2002-2009 The Nucleus Group
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * (see nucleus/documentation/index.html#license for more info)
 */
/**
 * A class representing a template
 *
 * @license http://nucleuscms.org/license.txt GNU General Public License
 * @copyright Copyright (C) 2002-2009 The Nucleus Group
 * @version $Id: TEMPLATE.php 1880 2012-06-17 07:48:14Z sakamocchi $
 */
class Template
{
	/**
	 * Template::$id
	 */
	private $id;
	
	/**
	 * Template::__construct()
	 * 
	 * @param	integer	$templateid	id for template
	 * @return	void
	 */
	public function __construct($templateid)
	{
		$this->id = intval($templateid);
		return;
	}
	
	/**
	 * Template::getID()
	 * 
	 * @param	void
	 * @return	integer	id for this instance of Template class
	 */
	public function getID()
	{
		return (integer) $this->id;
	}
	
	/**
	 * Template::createFromName()
	 * 
	 * @statc
	 * @param	string	$name	template name
	 * @return	object	instance of Template class generated by the name
	 */
	static public function createFromName($name)
	{
		return new Template(Template::getIdFromName($name));
	}
	
	/**
	 * Template::getIdFromName()
	 * 
	 * @static
	 * @param	string	$name	template name
	 * @return	integer	id for the template
	 */
	static public function getIdFromName($name)
	{
		$name = DB::quoteValue($name);
		$query = "SELECT tdnumber FROM %s WHERE tdname=%s";
		$query = sprintf($query, sql_table('template_desc'), $name);
		return DB::getValue($query);
	}
	
	/**
	 * Template::updateGeneralInfo()
	 * Updates the general information about the template
	 * 
	 * @param	string	$name	template name
	 * @param	string	$desc	description for this template
	 * @return	void
	 */
	public function updateGeneralInfo($name, $desc)
	{
		$query =  "UPDATE %s SET tdname=%s, tddesc=%s WHERE tdnumber=%d";
		$query = sprintf($query, sql_table('template_desc'), DB::quoteValue($name), DB::quoteValue($desc), (integer) $this->getID());
		DB::execute($query);
		return;
	}
	
	/**
	 * Template::update()
	 * Updates the contents of one part of the template
	 * 
	 * @param	String	$type	value for nucleus_template.tpartname
	 * @param	String	$content	value for nucleus_template.tcontent
	 * @return	Void
	 */
	public function update($type, $content)
	{
		// delete old thingie
		$query = "DELETE FROM %s WHERE tpartname=%s and tdesc=%d";
		$query = sprintf($query, sql_table('template'), DB::quoteValue($type), (integer) $this->getID());
		DB::execute($query);
		
		// write new thingie
		if ( $content )
		{
			$query = "INSERT INTO %s (tcontent, tpartname, tdesc) VALUES (%s, %s, %d)";
			$query = sprintf($query, sql_table('template'), DB::quoteValue($content), DB::quoteValue($type), (integer) $this->getID());
			DB::execute($query);
		}
		return;
	}
	
	/**
	 * Template::deleteAllParts()
	 * Deletes all template parts from the database
	 * 
	 * @param	void
	 * @return	void
	 */
	public function deleteAllParts()
	{
		$query = "DELETE FROM %s WHERE tdesc=%d";
		$query = sprintf($query, sql_table('template'), (integer) $this->getID());
		DB::execute($query);
		return;
	}
	
	/**
	 * Template::createNew()
	 * Creates a new template
	 *
	 * @static
	 * @param	string	$name	name for new template
	 * @param	string	$desc	description for new template
	 * @return	integer	id for new template
	 */
	static public function createNew($name, $desc)
	{
		global $manager;

		$data = array(
			'name'			=> &$name,
			'description'	=> &$desc
		);
		$manager->notify('PreAddTemplate', $data);
		
		DB::execute('INSERT INTO '.sql_table('template_desc').' (tdname, tddesc) VALUES (' . DB::quoteValue($name) . ',' . DB::quoteValue($desc) . ')');
		$newId = DB::getInsertId();

		$data = array(
			'templateid'	=> $newId,
			'name'			=> $name,
			'description'	=> $desc
		);
		$manager->notify('PostAddTemplate', $data);
		
		return $newId;
	}
	
	/**
	 * Reads a template and returns an array with the parts.
	 *
	 * @static
	 * @param 	string	$name name of the template file
	 * @return	array	template array
	 */
	static public function read($name)
	{
		global $manager;
		$data = array('template' => &$name);
		$manager->notify('PreTemplateRead', $data);
		
		$query = "SELECT tpartname, tcontent FROM %s, %s WHERE tdesc=tdnumber and tdname=%s";
		$query = sprintf($query, sql_table('template_desc'), sql_table('template'), DB::quoteValue($name));
		$res = DB::getResult($query);
		
		$template = array();
		foreach ( $res as $row )
		{
			$template[$row['tpartname']] = $row['tcontent'];
		}
		
		return $template;
	}
	
	/**
	 * fills a template with values
	 * 
	 * @static
	 * @param	string	$template	Template to be used
	 * @param	array	$values		Array of all the values
	 * @return	string	string filled with tag contents
	 */
	static public function fill($template, $values)
	{
		
		if ( sizeof($values) != 0 )
		{
			foreach ( $values as $key => $value )
			{
				$template = preg_replace('#<%' . preg_quote($key, '#') . '%>#', $value, $template);
			}
		}
		
		// remove non matched template-tags
		return preg_replace('#<%([a-zA-Z]+)?%>#', '', $template);
	}
	
	/**
	 * Template::exists()
	 * returns true if there is a template with the given shortname
	 * 
	 * @static
	 * @param	string	$name	template name
	 * @return	boolean	exists or not
	 */
	static public function exists($name)
	{
		$query = "SELECT * FROM %s WHERE tdname=%s";
		$query = sprintf($query, sql_table('template_desc'), DB::quoteValue($name));
		$r = DB::getResult($query);
		return ($r->rowCount() != 0);
	}
	
	/**
	 * Template::existsID()
	 * returns true if there is a template with the given ID
	 * 
	 * @static
	 * @param	integer	$id	id for template
	 * @return	bookean	exists or not
	 */
	static public function existsID($id)
	{
		$query = "SELECT * FROM %s WHERE tdnumber=%d";
		$query = sprintf($query, sql_table('template_desc'), (integer) $id);
		$r = DB::getResult($query);
		return ($r->rowCount() != 0);
	}
	
	/**
	 * Template::getNameFromId()
	 * 
	 * @static
	 * @param	integer	$id	id for template
	 * @return	object	sql object
	 */
	static public function getNameFromId($id)
	{
		$query = "SELECT tdname as result FROM %s WHERE tdnumber=%d";
		$query = sprintf($query, sql_table('template_desc'), (integer) $id);
		return DB::getValue($query);
	}
	
	/**
	 * Template::getDesc()
	 * 
	 * @static
	 * @param	integer	$id	id for template
	 * @return	string	description for the template
	 */
	static public function getDesc($id)
	{
		$query = "SELECT tddesc FROM %s WHERE tdnumber=%d";
		$query = sprintf($query, sql_table('template_desc'), (integer) $id);
		return DB::getValue($query);
	}
}
>>>>>>> skinnable-master
