
/**
 * Java Binary
 *
 * Copyright 2006 Lawrie Griffiths <lawrie,griffiths@ntlworld.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef __JAVA_BINARY_H__
#  define __JAVA_BINARY_H__

/*
 * An array containing all the bits of the flash routine bytecode.
 */
static const char java_binary[] = {
  0xf6, 0xca, 0x0c, 0x02, 0xc8, 0x01, 0x5a, 0x01, 0x37, 0x00, 0x22, 0x00,
  0xec, 0x0b, 0x01, 0x20, 0x02, 0x00, 0x78, 0x02, 0x84, 0x06, 0x00, 0x04,
  0x00, 0x00, 0x12, 0x00, 0xa8, 0x02, 0x84, 0x06, 0x0d, 0x0b, 0x00, 0x00,
  0x04, 0x00, 0x2c, 0x03, 0x91, 0x06, 0x01, 0x02, 0x00, 0x00, 0x04, 0x00,
  0x44, 0x03, 0x92, 0x06, 0x01, 0x02, 0x00, 0x00, 0x04, 0x00, 0x5c, 0x03,
  0x93, 0x06, 0x00, 0x01, 0x03, 0x00, 0x04, 0x00, 0x68, 0x03, 0x93, 0x06,
  0x00, 0x01, 0x04, 0x00, 0x04, 0x00, 0x74, 0x03, 0x93, 0x06, 0x00, 0x01,
  0x04, 0x00, 0x04, 0x00, 0x80, 0x03, 0x93, 0x06, 0x00, 0x01, 0x04, 0x00,
  0x04, 0x00, 0x8c, 0x03, 0x93, 0x06, 0x00, 0x01, 0x13, 0x00, 0x04, 0x00,
  0x98, 0x03, 0x93, 0x06, 0x00, 0x01, 0x13, 0x00, 0x04, 0x00, 0xa4, 0x03,
  0x93, 0x06, 0x00, 0x01, 0x14, 0x00, 0x04, 0x00, 0xb0, 0x03, 0x93, 0x06,
  0x00, 0x01, 0x13, 0x00, 0x04, 0x00, 0xbc, 0x03, 0x93, 0x06, 0x00, 0x01,
  0x13, 0x00, 0x04, 0x00, 0xc8, 0x03, 0x93, 0x06, 0x00, 0x01, 0x14, 0x00,
  0x04, 0x00, 0xd4, 0x03, 0x93, 0x06, 0x00, 0x01, 0x13, 0x00, 0x04, 0x00,
  0xe0, 0x03, 0x93, 0x06, 0x00, 0x01, 0x13, 0x00, 0x04, 0x00, 0xec, 0x03,
  0x93, 0x06, 0x00, 0x01, 0x04, 0x00, 0x02, 0x00, 0xf8, 0x03, 0x93, 0x06,
  0x00, 0x02, 0x00, 0x00, 0x02, 0x00, 0x10, 0x04, 0x93, 0x06, 0x00, 0x03,
  0x00, 0x00, 0x04, 0x00, 0x34, 0x04, 0x93, 0x06, 0x00, 0x01, 0x14, 0x00,
  0x04, 0x00, 0x40, 0x04, 0x93, 0x06, 0x00, 0x02, 0x03, 0x00, 0x04, 0x00,
  0x58, 0x04, 0x93, 0x06, 0x01, 0x02, 0x00, 0x00, 0x04, 0x00, 0x70, 0x04,
  0x94, 0x06, 0x01, 0x02, 0x00, 0x00, 0x02, 0x00, 0x88, 0x04, 0x95, 0x06,
  0x00, 0x05, 0x00, 0x00, 0x02, 0x00, 0xc4, 0x04, 0x95, 0x06, 0x00, 0x02,
  0x00, 0x00, 0x08, 0x00, 0xdc, 0x04, 0x95, 0x06, 0x03, 0x05, 0x00, 0x04,
  0x07, 0x00, 0x18, 0x05, 0x98, 0x06, 0x03, 0x07, 0x00, 0x04, 0x02, 0x00,
  0x6c, 0x05, 0x9b, 0x06, 0x00, 0x04, 0x00, 0x00, 0x02, 0x00, 0x9c, 0x05,
  0x9b, 0x06, 0x00, 0x02, 0x00, 0x08, 0x03, 0x00, 0xb4, 0x05, 0x9b, 0x06,
  0x01, 0x05, 0x00, 0x04, 0x16, 0x00, 0xf0, 0x05, 0x9c, 0x06, 0x02, 0x06,
  0x01, 0x04, 0x02, 0x00, 0x38, 0x06, 0x9e, 0x06, 0x00, 0x01, 0x00, 0x08,
  0x02, 0x00, 0x44, 0x06, 0x9e, 0x06, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0xa0, 0x04, 0xa0, 0x08, 0xa0, 0x0c, 0x00, 0x10, 0x00, 0x14, 0x00,
  0x18, 0x00, 0x1c, 0x00, 0x20, 0x00, 0x24, 0x00, 0x28, 0x00, 0x2c, 0x00,
  0x30, 0x00, 0x34, 0x00, 0x38, 0x00, 0x3c, 0x90, 0x3e, 0x90, 0x40, 0x90,
  0x42, 0x90, 0x44, 0x90, 0x46, 0x90, 0x48, 0x90, 0x4a, 0x90, 0x4c, 0x90,
  0x4e, 0x90, 0x50, 0x90, 0x52, 0x90, 0x54, 0x90, 0x56, 0x00, 0x5a, 0x00,
  0x5e, 0xa0, 0x62, 0x00, 0x66, 0x00, 0x6a, 0xa0, 0x61, 0x0b, 0x00, 0x00,
  0x61, 0x0b, 0x0a, 0x04, 0x65, 0x0b, 0x0a, 0x04, 0x69, 0x0b, 0x0a, 0x04,
  0x6d, 0x0b, 0x00, 0x08, 0x75, 0x0b, 0x00, 0x09, 0x7e, 0x0b, 0x00, 0x08,
  0x86, 0x0b, 0x00, 0x08, 0x8e, 0x0b, 0x00, 0x08, 0x96, 0x0b, 0x00, 0x08,
  0x9e, 0x0b, 0x00, 0x08, 0xa6, 0x0b, 0x00, 0x08, 0xae, 0x0b, 0x00, 0x01,
  0xaf, 0x0b, 0x00, 0x01, 0xb0, 0x0b, 0x0b, 0x08, 0xb8, 0x0b, 0x0b, 0x08,
  0xc0, 0x0b, 0x0a, 0x04, 0xc4, 0x0b, 0x0a, 0x04, 0xc8, 0x0b, 0x0a, 0x04,
  0xcc, 0x0b, 0x0a, 0x04, 0xd0, 0x0b, 0x0a, 0x04, 0xd4, 0x0b, 0x0a, 0x04,
  0xd8, 0x0b, 0x0a, 0x04, 0xdc, 0x0b, 0x0a, 0x04, 0xe0, 0x0b, 0x0a, 0x04,
  0xe4, 0x0b, 0x0a, 0x04, 0xe8, 0x0b, 0x0a, 0x04, 0x02, 0x00, 0x5c, 0x06,
  0x9e, 0x06, 0x01, 0x00, 0x01, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x01, 0x00, 0x33, 0x00, 0x5c, 0x06,
  0x9f, 0x06, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0x22, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x05, 0x00, 0x34, 0x00, 0x5c, 0x06,
  0xa2, 0x06, 0x01, 0x02, 0x01, 0x00, 0x00, 0x00, 0x02, 0x00, 0x5c, 0x06,
  0xb0, 0x06, 0x01, 0x02, 0x01, 0x00, 0x00, 0x00, 0x35, 0x00, 0x5c, 0x06,
  0xb7, 0x06, 0x03, 0x02, 0x02, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00, 0x0a, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x05, 0x00, 0x0b, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x0c, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00, 0x0d, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x01, 0x00, 0x0e, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00, 0x11, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x01, 0x00, 0x36, 0x00, 0x5c, 0x06,
  0xd9, 0x06, 0x04, 0x05, 0x04, 0x00, 0x00, 0x00, 0x33, 0x00, 0x5c, 0x06,
  0xf0, 0x06, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0x02, 0x00, 0x5c, 0x06,
  0xf2, 0x06, 0x01, 0x02, 0x01, 0x00, 0x00, 0x00, 0x35, 0x00, 0x5c, 0x06,
  0xfd, 0x06, 0x02, 0x02, 0x02, 0x00, 0x00, 0x00, 0x02, 0x00, 0x5c, 0x06,
  0x07, 0x07, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0x02, 0x00, 0x5c, 0x06,
  0x0c, 0x07, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0x02, 0x00, 0x5c, 0x06,
  0x11, 0x07, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0x02, 0x00, 0x5c, 0x06,
  0x16, 0x07, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0x02, 0x00, 0x5c, 0x06,
  0x1b, 0x07, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0x02, 0x00, 0x5c, 0x06,
  0x20, 0x07, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0x02, 0x00, 0x5c, 0x06,
  0x25, 0x07, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0x02, 0x00, 0x5c, 0x06,
  0x2a, 0x07, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0x02, 0x00, 0x5c, 0x06,
  0x2f, 0x07, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0x02, 0x00, 0x5c, 0x06,
  0x34, 0x07, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0x02, 0x00, 0x5c, 0x06,
  0x39, 0x07, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0x02, 0x00, 0x5c, 0x06,
  0x3e, 0x07, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0x02, 0x00, 0x5c, 0x06,
  0x43, 0x07, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0x02, 0x00, 0x5c, 0x06,
  0x48, 0x07, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5c, 0x06,
  0x4d, 0x07, 0x0d, 0x03, 0x01, 0x00, 0x04, 0x00, 0x02, 0x00, 0x5c, 0x06,
  0x4e, 0x08, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0x37, 0x00, 0x5c, 0x06,
  0x53, 0x08, 0x06, 0x05, 0x05, 0x00, 0x04, 0x00, 0x38, 0x00, 0x5c, 0x06,
  0x70, 0x08, 0x00, 0x01, 0x00, 0x00, 0x04, 0x00, 0x02, 0x00, 0x5c, 0x06,
  0x74, 0x08, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0x02, 0x00, 0x5c, 0x06,
  0x79, 0x08, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0x35, 0x00, 0x5c, 0x06,
  0x7e, 0x08, 0x02, 0x02, 0x02, 0x00, 0x00, 0x00, 0x39, 0x00, 0x5c, 0x06,
  0x84, 0x08, 0x02, 0x02, 0x02, 0x00, 0x00, 0x00, 0x3a, 0x00, 0x5c, 0x06,
  0x8e, 0x08, 0x01, 0x02, 0x01, 0x00, 0x00, 0x00, 0x39, 0x00, 0x5c, 0x06,
  0xa1, 0x08, 0x02, 0x02, 0x02, 0x00, 0x00, 0x00, 0x3b, 0x00, 0x5c, 0x06,
  0xab, 0x08, 0x01, 0x02, 0x01, 0x00, 0x00, 0x00, 0x02, 0x00, 0x5c, 0x06,
  0xbe, 0x08, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0x2b, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x05, 0x00, 0x2c, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x05, 0x00, 0x2d, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x2e, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x02, 0x00, 0x5c, 0x06,
  0xc3, 0x08, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0x2f, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x3c, 0x00, 0x5c, 0x06,
  0xc8, 0x08, 0x02, 0x02, 0x02, 0x00, 0x00, 0x00, 0x3a, 0x00, 0x5c, 0x06,
  0xda, 0x08, 0x01, 0x02, 0x01, 0x00, 0x00, 0x00, 0x30, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x3d, 0x00, 0x5c, 0x06,
  0xeb, 0x08, 0x02, 0x02, 0x01, 0x00, 0x02, 0x00, 0x03, 0x00, 0x5c, 0x06,
  0x1e, 0x09, 0x00, 0x04, 0x00, 0x00, 0x04, 0x00, 0x3b, 0x00, 0x5c, 0x06,
  0x75, 0x09, 0x01, 0x02, 0x01, 0x00, 0x00, 0x00, 0x3e, 0x00, 0x5c, 0x06,
  0x7e, 0x09, 0x01, 0x02, 0x01, 0x00, 0x00, 0x00, 0x3c, 0x00, 0x5c, 0x06,
  0x87, 0x09, 0x02, 0x03, 0x02, 0x00, 0x00, 0x00, 0x3f, 0x00, 0x5c, 0x06,
  0x9e, 0x09, 0x03, 0x03, 0x03, 0x00, 0x00, 0x00, 0x23, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x05, 0x00, 0x24, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x05, 0x00, 0x03, 0x00, 0x5c, 0x06,
  0xb1, 0x09, 0x00, 0x04, 0x00, 0x00, 0x04, 0x00, 0x02, 0x00, 0x5c, 0x06,
  0xfd, 0x09, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0x38, 0x00, 0x5c, 0x06,
  0x02, 0x0a, 0x00, 0x02, 0x00, 0x00, 0x04, 0x00, 0x17, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00, 0x18, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00, 0x40, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x41, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x42, 0x00, 0x5c, 0x06,
  0x16, 0x0a, 0x02, 0x01, 0x02, 0x00, 0x00, 0x00, 0x02, 0x00, 0x5c, 0x06,
  0x1f, 0x0a, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0x43, 0x00, 0x5c, 0x06,
  0x24, 0x0a, 0x06, 0x04, 0x03, 0x02, 0x00, 0x00, 0x25, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00, 0x03, 0x00, 0x6c, 0x06,
  0x69, 0x0a, 0x00, 0x03, 0x00, 0x00, 0x04, 0x00, 0x02, 0x00, 0x6c, 0x06,
  0x75, 0x0a, 0x01, 0x03, 0x01, 0x00, 0x00, 0x00, 0x44, 0x00, 0x6c, 0x06,
  0x85, 0x0a, 0x02, 0x02, 0x00, 0x02, 0x04, 0x00, 0x45, 0x00, 0x7c, 0x06,
  0xc6, 0x0a, 0x04, 0x04, 0x03, 0x00, 0x00, 0x00, 0x46, 0x00, 0x7c, 0x06,
  0x0d, 0x0b, 0x03, 0x03, 0x03, 0x00, 0x00, 0x00, 0x01, 0x00, 0x7c, 0x06,
  0x16, 0x0b, 0x03, 0x03, 0x01, 0x01, 0x00, 0x00, 0x03, 0x00, 0x84, 0x06,
  0x4d, 0x0b, 0x00, 0x02, 0x00, 0x00, 0x04, 0x00, 0x3d, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x02, 0x00, 0x84, 0x06,
  0x5c, 0x0b, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0x1b, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x05, 0x00, 0x06, 0x00, 0x3d, 0x00,
  0x3e, 0x00, 0x03, 0x00, 0x3e, 0x00, 0x42, 0x00, 0x3e, 0x00, 0x03, 0x00,
  0x06, 0x00, 0x35, 0x00, 0x38, 0x00, 0x03, 0x00, 0x38, 0x00, 0x3b, 0x00,
  0x38, 0x00, 0x03, 0x00, 0x00, 0x00, 0x30, 0x00, 0x33, 0x00, 0x0d, 0x00,
  0x00, 0x0a, 0x0a, 0x0a, 0x0a, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x0a, 0x09, 0x0a, 0x09,
  0x0a, 0x00, 0xb1, 0x12, 0x00, 0xb0, 0x2a, 0xb4, 0x80, 0x1b, 0x04, 0xa4,
  0x00, 0x07, 0x04, 0xa7, 0x00, 0x04, 0x03, 0xac, 0x2a, 0x12, 0x00, 0xb7,
  0x01, 0x02, 0xb1, 0x2a, 0xb7, 0x00, 0x00, 0xb8, 0x01, 0x06, 0x4d, 0x2c,
  0xc7, 0x00, 0x0b, 0x2a, 0x08, 0xb6, 0x10, 0x0d, 0xa7, 0x00, 0x0b, 0x2a,
  0x2c, 0xb6, 0x00, 0x0c, 0xb6, 0x10, 0x0d, 0x2a, 0x2b, 0xb5, 0x00, 0x1f,
  0xb1, 0x2a, 0xb7, 0x00, 0x00, 0x2a, 0x1d, 0xbc, 0x05, 0xb5, 0x00, 0x04,
  0x2b, 0x1c, 0x2a, 0xb4, 0x00, 0x04, 0x03, 0x1d, 0xb8, 0x12, 0x01, 0xb1,
  0x2a, 0xb0, 0x2a, 0xb7, 0x00, 0x00, 0x2a, 0x12, 0x00, 0xb5, 0x00, 0x04,
  0xb1, 0x2a, 0xb7, 0x00, 0x00, 0x2a, 0x2b, 0xb5, 0x00, 0x04, 0xb1, 0x2a,
  0xb7, 0x03, 0x00, 0xb1, 0x2a, 0xb7, 0x04, 0x00, 0xb1, 0x2a, 0xb7, 0x04,
  0x00, 0xb1, 0x2a, 0xb7, 0x04, 0x00, 0xb1, 0x2a, 0xb7, 0x13, 0x00, 0xb1,
  0x2a, 0xb7, 0x13, 0x00, 0xb1, 0x2a, 0xb7, 0x14, 0x00, 0xb1, 0x2a, 0xb7,
  0x13, 0x00, 0xb1, 0x2a, 0xb7, 0x13, 0x00, 0xb1, 0x2a, 0xb7, 0x14, 0x00,
  0xb1, 0x2a, 0xb7, 0x13, 0x00, 0xb1, 0x2a, 0xb7, 0x13, 0x00, 0xb1, 0x2a,
  0xb7, 0x04, 0x00, 0xb1, 0x2a, 0xb7, 0x00, 0x00, 0xb1, 0x12, 0x04, 0x4c,
  0x12, 0x05, 0x4d, 0x12, 0x06, 0x4e, 0x12, 0x07, 0x3a, 0x04, 0x12, 0x08,
  0x3a, 0x05, 0x12, 0x09, 0x3a, 0x06, 0x12, 0x0a, 0x3a, 0x07, 0x12, 0x0b,
  0x3a, 0x08, 0x12, 0x0c, 0x3a, 0x09, 0x12, 0x0d, 0x3a, 0x0a, 0xbb, 0x00,
  0x15, 0x59, 0xb2, 0x1a, 0x09, 0xb7, 0x15, 0x00, 0x3a, 0x0b, 0xbb, 0x00,
  0x16, 0x59, 0xb2, 0x1a, 0x0a, 0xb7, 0x16, 0x00, 0x3a, 0x0c, 0xb8, 0x17,
  0x04, 0x2d, 0x03, 0x03, 0xb8, 0x17, 0x01, 0xb8, 0x18, 0x01, 0x10, 0x09,
  0x03, 0xb8, 0x17, 0x02, 0x19, 0x04, 0x03, 0x04, 0xb8, 0x17, 0x01, 0xb8,
  0x19, 0x02, 0x10, 0x09, 0x04, 0xb8, 0x17, 0x02, 0x19, 0x05, 0x03, 0x05,
  0xb8, 0x17, 0x01, 0xb2, 0x1a, 0x09, 0xb6, 0x00, 0x3e, 0x10, 0x09, 0x05,
  0xb8, 0x17, 0x02, 0x19, 0x0b, 0xb6, 0x00, 0x3a, 0x99, 0x00, 0x08, 0x19,
  0x09, 0xa7, 0x00, 0x05, 0x19, 0x0a, 0x10, 0x0e, 0x05, 0xb8, 0x17, 0x01,
  0x19, 0x06, 0x03, 0x06, 0xb8, 0x17, 0x01, 0xb2, 0x1a, 0x0a, 0xb6, 0x00,
  0x3e, 0x10, 0x09, 0x06, 0xb8, 0x17, 0x02, 0x19, 0x0c, 0xb6, 0x00, 0x3b,
  0x10, 0x0e, 0x06, 0xb8, 0x17, 0x02, 0x19, 0x07, 0x03, 0x07, 0xb8, 0x17,
  0x01, 0xb2, 0x1a, 0x0b, 0xb6, 0x00, 0x3e, 0x10, 0x09, 0x07, 0xb8, 0x17,
  0x02, 0x19, 0x08, 0x03, 0x08, 0xb8, 0x17, 0x01, 0xb2, 0x1a, 0x0c, 0xb6,
  0x00, 0x3e, 0x10, 0x09, 0x08, 0xb8, 0x17, 0x02, 0x2b, 0x03, 0x10, 0x06,
  0xb8, 0x17, 0x01, 0xb8, 0x1b, 0x01, 0xb6, 0x00, 0x18, 0x88, 0x10, 0x09,
  0x10, 0x06, 0xb8, 0x17, 0x02, 0x2c, 0x03, 0x10, 0x07, 0xb8, 0x17, 0x01,
  0xb8, 0x1b, 0x01, 0xb6, 0x00, 0x17, 0x88, 0x10, 0x09, 0x10, 0x07, 0xb8,
  0x17, 0x02, 0xb8, 0x17, 0x03, 0x14, 0x00, 0x0e, 0xb8, 0x01, 0x05, 0xa7,
  0xff, 0x3f, 0x2a, 0xb7, 0x00, 0x00, 0xb1, 0x03, 0x36, 0x05, 0x15, 0x05,
  0x15, 0x04, 0xa2, 0x00, 0x15, 0x2c, 0x15, 0x05, 0x1d, 0x60, 0x2a, 0x15,
  0x05, 0x1b, 0x60, 0x34, 0x55, 0x84, 0x05, 0x01, 0xa7, 0xff, 0xea, 0xb1,
  0xb8, 0x1b, 0x01, 0xb0, 0x2a, 0xb7, 0x14, 0x00, 0xb1, 0x2a, 0xb7, 0x03,
  0x00, 0xb1, 0x2a, 0x2b, 0xb7, 0x03, 0x01, 0xb1, 0x2a, 0xb7, 0x00, 0x00,
  0x2a, 0x2b, 0xb5, 0x00, 0x04, 0xb1, 0x2a, 0xb4, 0x00, 0x04, 0xb6, 0x00,
  0x3e, 0x11, 0x02, 0x58, 0xa2, 0x00, 0x07, 0x04, 0xa7, 0x00, 0x04, 0x03,
  0xac, 0x2a, 0xb7, 0x00, 0x00, 0x2a, 0x2b, 0xb5, 0x00, 0x04, 0xb1, 0x11,
  0x03, 0xff, 0x2a, 0xb4, 0x00, 0x04, 0xb6, 0x00, 0x3e, 0x64, 0x10, 0x64,
  0x68, 0x11, 0x03, 0xff, 0x6c, 0xac, 0x2a, 0xb7, 0x00, 0x00, 0xb1, 0x2a,
  0xb7, 0x00, 0x00, 0xb1, 0x2a, 0xb7, 0x00, 0x00, 0x2a, 0x07, 0xbc, 0x00,
  0x00, 0xb5, 0x00, 0x08, 0x2a, 0x1b, 0xb5, 0xa0, 0x04, 0xb1, 0xb8, 0x19,
  0x02, 0x2a, 0xb4, 0xa0, 0x04, 0x7e, 0x99, 0x00, 0x07, 0x04, 0xa7, 0x00,
  0x04, 0x03, 0xac, 0x03, 0x3c, 0x1b, 0x2a, 0xb4, 0xa0, 0x0c, 0xa2, 0x00,
  0x2b, 0x2a, 0xb6, 0x00, 0x3a, 0x99, 0x00, 0x12, 0x2a, 0xb4, 0x00, 0x08,
  0x1b, 0x32, 0x2a, 0xb6, 0x10, 0x40, 0x00, 0x00, 0xa7, 0x00, 0x0f, 0x2a,
  0xb4, 0x00, 0x08, 0x1b, 0x32, 0x2a, 0xb6, 0x10, 0x41, 0x00, 0x00, 0x84,
  0x01, 0x01, 0xa7, 0xff, 0xd3, 0xb1, 0xbb, 0x00, 0x19, 0x59, 0x04, 0xb7,
  0x19, 0x00, 0xb3, 0x19, 0x03, 0xbb, 0x00, 0x19, 0x59, 0x05, 0xb7, 0x19,
  0x00, 0xb3, 0x19, 0x04, 0xbb, 0x00, 0x19, 0x59, 0x07, 0xb7, 0x19, 0x00,
  0xb3, 0x19, 0x05, 0xbb, 0x00, 0x19, 0x59, 0x10, 0x08, 0xb7, 0x19, 0x00,
  0xb3, 0x19, 0x06, 0x07, 0xbc, 0x00, 0x00, 0x59, 0x03, 0xb2, 0x19, 0x03,
  0x53, 0x59, 0x04, 0xb2, 0x19, 0x04, 0x53, 0x59, 0x05, 0xb2, 0x19, 0x05,
  0x53, 0x59, 0x06, 0xb2, 0x19, 0x06, 0x53, 0xb3, 0x19, 0x07, 0xbb, 0x00,
  0x1d, 0x59, 0xb7, 0x1d, 0x01, 0xb3, 0x19, 0x08, 0xb1, 0x2a, 0xb4, 0xa0,
  0x04, 0x04, 0xb8, 0x1a, 0x04, 0xac, 0x2a, 0xb4, 0xa0, 0x04, 0x03, 0xb8,
  0x1a, 0x04, 0xac, 0x2a, 0xb7, 0x00, 0x00, 0x2a, 0x03, 0xb5, 0x90, 0x08,
  0x2a, 0x1b, 0xb5, 0xa0, 0x04, 0x2a, 0x06, 0x11, 0x00, 0x80, 0xb6, 0x20,
  0x3f, 0xb1, 0x2a, 0xb4, 0xa0, 0x04, 0x1b, 0x04, 0xb8, 0x1a, 0x05, 0x2a,
  0xb4, 0xa0, 0x04, 0x1c, 0x03, 0xb8, 0x1a, 0x05, 0xb1, 0xbb, 0x00, 0x1a,
  0x59, 0x03, 0xb7, 0x1a, 0x02, 0xb3, 0x1a, 0x09, 0xbb, 0x00, 0x1a, 0x59,
  0x04, 0xb7, 0x1a, 0x02, 0xb3, 0x1a, 0x0a, 0xbb, 0x00, 0x1a, 0x59, 0x05,
  0xb7, 0x1a, 0x02, 0xb3, 0x1a, 0x0b, 0xbb, 0x00, 0x1a, 0x59, 0x06, 0xb7,
  0x1a, 0x02, 0xb3, 0x1a, 0x0c, 0x07, 0xbc, 0x00, 0x00, 0x59, 0x03, 0xb2,
  0x1a, 0x09, 0x53, 0x59, 0x04, 0xb2, 0x1a, 0x0a, 0x53, 0x59, 0x05, 0xb2,
  0x1a, 0x0b, 0x53, 0x59, 0x06, 0xb2, 0x1a, 0x0c, 0x53, 0xb3, 0x1a, 0x0d,
  0xb1, 0x2a, 0xb7, 0x00, 0x00, 0xb1, 0xb2, 0x1b, 0x0e, 0xc7, 0x00, 0x0d,
  0xbb, 0x00, 0x1b, 0x59, 0xb7, 0x1b, 0x00, 0xb3, 0x1b, 0x0e, 0xb2, 0x1b,
  0x0e, 0xb0, 0x2a, 0xb7, 0x00, 0x00, 0x2a, 0xb7, 0x1d, 0x03, 0xb1, 0x2a,
  0xb7, 0x00, 0x00, 0xb1, 0xb2, 0x1d, 0x1c, 0x59, 0x4e, 0xc2, 0x1b, 0xb2,
  0x1d, 0x1c, 0xb4, 0x90, 0x04, 0x7e, 0x36, 0x04, 0x15, 0x04, 0x9a, 0x00,
  0x18, 0xb2, 0x1d, 0x1c, 0x1c, 0x85, 0xb6, 0x20, 0x07, 0x1b, 0xb2, 0x1d,
  0x1c, 0xb4, 0x90, 0x04, 0x7e, 0x36, 0x04, 0xa7, 0xff, 0xe9, 0xb2, 0x1d,
  0x1c, 0x59, 0xb4, 0x90, 0x04, 0x1b, 0x02, 0x82, 0x7e, 0x93, 0xb5, 0x90,
  0x04, 0x15, 0x04, 0x2d, 0xc3, 0xac, 0x3a, 0x05, 0x2d, 0xc3, 0x19, 0x05,
  0xbf, 0xbb, 0x00, 0x1d, 0x59, 0x04, 0xb7, 0x1d, 0x00, 0xb3, 0x1d, 0x1c,
  0xb1, 0x2a, 0xb7, 0x01, 0x01, 0x2a, 0xbb, 0x00, 0x1d, 0x59, 0xb7, 0x1d,
  0x01, 0xb5, 0x00, 0x27, 0xb1, 0xb2, 0x1e, 0x1d, 0x59, 0x4b, 0xc2, 0xb2,
  0x1e, 0x1d, 0xb6, 0x00, 0x34, 0x9a, 0x00, 0x27, 0x10, 0x07, 0xbc, 0x0a,
  0xb3, 0x1e, 0x1f, 0x10, 0x07, 0xbc, 0x00, 0x00, 0xb3, 0x1e, 0x20, 0xb2,
  0x1e, 0x1d, 0x04, 0xb6, 0x10, 0x11, 0xb2, 0x1e, 0x1d, 0x10, 0x0a, 0xb6,
  0x10, 0x0d, 0xb2, 0x1e, 0x1d, 0xb6, 0x00, 0x08, 0x2a, 0xc3, 0xa7, 0x00,
  0x08, 0x4c, 0x2a, 0xc3, 0x2b, 0xbf, 0xb2, 0x1e, 0x1d, 0xb0, 0x2a, 0x59,
  0xb4, 0xa0, 0x23, 0x1b, 0x80, 0xb5, 0xa0, 0x23, 0x03, 0x3e, 0x1d, 0xb2,
  0x1e, 0x21, 0xa2, 0x00, 0x15, 0xb2, 0x1e, 0x20, 0x1d, 0x32, 0x2c, 0xa6,
  0x00, 0x06, 0xa7, 0x00, 0x09, 0x84, 0x03, 0x01, 0xa7, 0xff, 0xea, 0x1d,
  0xb2, 0x1e, 0x21, 0xa0, 0x00, 0x19, 0xb2, 0x1e, 0x1f, 0xb2, 0x1e, 0x21,
  0x1b, 0x4f, 0xb2, 0x1e, 0x20, 0xb2, 0x1e, 0x21, 0x59, 0x04, 0x60, 0xb3,
  0x1e, 0x21, 0x2c, 0x53, 0x2a, 0xb6, 0x00, 0x0e, 0xb1, 0x2a, 0x1b, 0x07,
  0x78, 0x2c, 0xb6, 0x20, 0x45, 0xb1, 0x2a, 0xb4, 0x00, 0x27, 0x2a, 0xb4,
  0xa0, 0x23, 0x03, 0xb6, 0x20, 0x43, 0x3c, 0x03, 0x3d, 0x1c, 0xb2, 0x1e,
  0x21, 0xa2, 0x00, 0x1d, 0x1b, 0xb2, 0x1e, 0x1f, 0x1c, 0x2e, 0x7e, 0x99,
  0x00, 0x0d, 0xb2, 0x1e, 0x20, 0x1c, 0x32, 0xb6, 0x00, 0x3d, 0x00, 0x00,
  0x84, 0x02, 0x01, 0xa7, 0xff, 0xe2, 0xa7, 0xff, 0xd0, 0x4c, 0xa7, 0xff,
  0xcc, 0xbb, 0x00, 0x1e, 0x59, 0xb7, 0x1e, 0x00, 0xb3, 0x1e, 0x1d, 0x03,
  0xb3, 0x1e, 0x21, 0xb1, 0x2a, 0xb7, 0x00, 0x00, 0xb1, 0x00, 0x00, 0x00,
  0x01, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x0a, 0x54, 0x6f, 0x74,
  0x20, 0x4d, 0x65, 0x6d, 0x3a, 0x46, 0x72, 0x65, 0x65, 0x20, 0x4d, 0x65,
  0x6d, 0x3a, 0x42, 0x61, 0x74, 0x74, 0x65, 0x72, 0x79, 0x3a, 0x42, 0x75,
  0x74, 0x74, 0x6f, 0x6e, 0x73, 0x3a, 0x53, 0x65, 0x6e, 0x73, 0x6f, 0x72,
  0x31, 0x3a, 0x53, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x32, 0x3a, 0x53, 0x65,
  0x6e, 0x73, 0x6f, 0x72, 0x33, 0x3a, 0x53, 0x65, 0x6e, 0x73, 0x6f, 0x72,
  0x34, 0x3a, 0x54, 0x46, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0xe8,
  0x00, 0x00, 0x00, 0x00, 0x3a, 0x83, 0x12, 0x6f, 0x00, 0x00, 0x00, 0x02,
  0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x0f,
  0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x40,
  0x00, 0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0xf0, 0x00, 0x00, 0x01, 0x00,
  0x00, 0x00, 0x00, 0x07, 0x11
};


#endif /* __JAVA_BINARY_H__ */
