/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: event.cpp,v 1.5 2003/12/20 06:51:58 takayuki Exp $
 */

// $Header: /home/CVS/configurator/base/event.cpp,v 1.5 2003/12/20 06:51:58 takayuki Exp $

#include "base/event.h"

using namespace std;

/***************************** ƥȥ *****************************/

#ifdef TESTSUITE
#include "base/coverage_undefs.h"

namespace {
    class Event_fortest : public Event<int> 
    {   TESTSUITE_PROTOTYPE(main)   };

    int * ptr_i_dummy_handler;
    void dummy_handler(int & i)
    {
        ptr_i_dummy_handler = &i;
        ++ i;
        TestSuite::check("dummy_handler");
    }

    class EventHandler : public Event_fortest::Handler
    {
    public:
        int * ptr_i;

        EventHandler(void)  throw() { TestSuite::check("EventHandler::EventHandler");  }
        ~EventHandler(void) throw() { TestSuite::check("EventHandler::~EventHandler"); }
        void handler(Event_fortest::value_type & i) { ptr_i = &i; ++i; TestSuite::check("EventHandler::handler"); }
    };
}

TESTSUITE(main,Event_fortest)
{
    BEGIN_CASE("add","add") {
        BEGIN_CASE("1","addǥϥɥ餬ϿǤ") {
            Singleton<Event_fortest::handler_list_type>::renewInstance();

            Event_fortest::add(dummy_handler);

            TEST_CASE("1","ϥɥꥹȤ1Ƥ", Singleton<Event_fortest::handler_list_type>::getInstance()->size() == 1);
            TEST_CASE("2","ϥɥꥹȤȤ", *Singleton<Event_fortest::handler_list_type>::getInstance()->begin() == dummy_handler);
        } END_CASE;

        BEGIN_CASE("2","ƱϥɥʣϿǤ") {
            Singleton<Event_fortest::handler_list_type>::renewInstance();

            Event_fortest::add(dummy_handler);
            Event_fortest::add(dummy_handler);
            Event_fortest::add(dummy_handler);

            TEST_CASE("1","ϥɥꥹȤȤ3", Singleton<Event_fortest::handler_list_type>::getInstance()->size() == 3);
            TEST_CASE("2","ϥɥꥹȤȤ", *Singleton<Event_fortest::handler_list_type>::getInstance()->begin() == dummy_handler);
        } END_CASE;
    } END_CASE;

    BEGIN_CASE("remove","remove") {
        BEGIN_CASE("1","addϿϥɥǤ") {
            Singleton<Event_fortest::handler_list_type>::renewInstance();

            Event_fortest::add(dummy_handler);
            Event_fortest::remove(dummy_handler);

            TEST_CASE("1","ϥɥꥹȤǿ0", Singleton<Event_fortest::handler_list_type>::getInstance()->size() == 0);
        } END_CASE;

        BEGIN_CASE("2","ϿƤΥϥɥ餬ä") {
            Singleton<Event_fortest::handler_list_type>::renewInstance();

            Event_fortest::add(dummy_handler);
            Event_fortest::add(dummy_handler);
            Event_fortest::add(dummy_handler);
            Event_fortest::remove(dummy_handler);

            TEST_CASE("1","ϥɥꥹȤǿ0", Singleton<Event_fortest::handler_list_type>::getInstance()->size() == 0);
        } END_CASE;
    } END_CASE;

    BEGIN_CASE("constructor/destructor","constructor/destructor") {
        Singleton<Event_fortest::Handler::instance_list_type>::renewInstance();

        TEST_CASE("0","[] ϥɥꥹȤȤ0", Singleton<Event_fortest::Handler::instance_list_type>::getInstance()->size() == 0);
        {
            EventHandler evhdr;
            TEST_CASE("1","ϥɥꥹȤϿƤ", Singleton<Event_fortest::Handler::instance_list_type>::getInstance()->size() == 1);
            TEST_CASE("2","ϿƤ", *Singleton<Event_fortest::Handler::instance_list_type>::getInstance()->begin() == &evhdr);
        }
        TEST_CASE("3","ϥɥϲƤ", Singleton<Event_fortest::Handler::instance_list_type>::getInstance()->size() == 0);
    } END_CASE;

    BEGIN_CASE("raise","raise") {
        BEGIN_CASE("1","ϿŪʥϥɥ餬¹Ԥ") {
            Singleton<Event_fortest::handler_list_type>::renewInstance();
            TestSuite::clearCheckpoints();

            Event_fortest::add(dummy_handler);

            int i = 0;
            Event_fortest::raise(i);

            TEST_CASE("1","ϥɥ餬¹Ԥ",TestSuite::isReached("dummy_handler"));
            TEST_CASE("2","֤ǸƤѿƱ", &i == ptr_i_dummy_handler);
            TEST_CASE("3","ͤ󥯥ȤƤ", i == 1);
        } END_CASE;

        BEGIN_CASE("2","Ͽ󥹥󥹤Υϥɥ餬¹Ԥ") {
            Singleton<Event_fortest::handler_list_type>::renewInstance();
            TestSuite::clearCheckpoints();
            EventHandler evhdr;

            int i = 0;
            Event_fortest::raise(i);

            TEST_CASE("1","ϥɥ餬¹Ԥ",TestSuite::isReached("EventHandler::handler"));
            TEST_CASE("2","֤ǸƤѿƱ", &i == evhdr.ptr_i);
            TEST_CASE("3","ͤ󥯥ȤƤ", i == 1);
        } END_CASE;

        BEGIN_CASE("3","ξƱ (֤ä˵ˤʤ)") {
            Singleton<Event_fortest::handler_list_type>::renewInstance();
            TestSuite::clearCheckpoints();
            EventHandler evhdr;

            Event_fortest::add(dummy_handler);

            int i = 0;
            Event_fortest::raise(i);

            TEST_CASE("1","ϥɥ餬¹Ԥ",TestSuite::isReached("dummy_handler"));
            TEST_CASE("2","ϥɥ餬¹Ԥ",TestSuite::isReached("EventHandler::handler"));
            TEST_CASE("3","ͤ󥯥ȤƤ", i == 2);
        } END_CASE;

        BEGIN_CASE("4","ʣϿ") {
            Singleton<Event_fortest::handler_list_type>::renewInstance();
            TestSuite::clearCheckpoints();
            EventHandler evhdr;
            EventHandler evhdr2;

            Event_fortest::add(dummy_handler);
            Event_fortest::add(dummy_handler);

            int i = 0;
            Event_fortest::raise(i);

            TEST_CASE("1","ϥɥ餬¹Ԥ",TestSuite::isReached("dummy_handler"));
            TEST_CASE("2","ϥɥ餬¹Ԥ",TestSuite::isReached("EventHandler::handler"));
            TEST_CASE("3","ͤ󥯥ȤƤ", i == 4);
        } END_CASE;
    } END_CASE;
}


#endif



