/*
 *  TOPPERS/OSEK Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      OSEK Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2004 by Embedded and Real-Time Systems Laboratory
 *              Graduate School of Information Science, Nagoya Univ., JAPAN
 *  Copyright (C) 2004 by Witz Corporation, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 */

/*
 *	OSEKJ[lWCN[ht@C
 *
 *  AZũ\[Xt@CVXeRtBM[Vt@
 *  C炱̃t@CCN[h鎞́C_MACRO_ONLY `
 *  ƂŁC}N`ȊŐLqƂłD
 *
 *  ̒ŃCN[hĂt@CāC̃CN[ht@
 *  CɈˑĂȂD
 */

#ifndef _KERNEL_H_
#define _KERNEL_H_

/*
 *  J[lEAvP[V ʃCN[ht@C
 */

/*
 *  VXevZbTɈˑ`
 */
#include <sys_defs.h>
#include <cpu_defs.h>

#include <osek.h>


/*
 *  f[^^̒`
 */
#ifndef _MACRO_ONLY

typedef UINT8			TaskType;			/* ^XNID */
typedef UINT8			TaskStateType;		/* ^XN */
typedef UINT8			ResourceType;		/* \[XID */
typedef UINT32			EventMaskType;		/* Cxg}XN */
typedef UINT32			TickType;			/* JE^lieBbNj*/
typedef UINT8			AlarmType;			/* A[ID */
typedef UINT8			AppModeType;		/* AvP[V[h */
typedef UINT8			OSServiceIdType;	/* OS̃T[rXAPIID */
typedef UINT8			IsrType;			/* ISR IDiOSEKdlOj*/
typedef UINT8			CounterType;		/* JE^IDiOSEKdlOj*/

typedef struct {
	TickType maxallowedvalue;	/* JE^w̍ől */
	TickType ticksperbase;		/* PʂɒB܂ł̃eBbN */
	TickType mincycle;			/* TCNw̍ŏl */
} AlarmBaseType;

typedef TaskType		*TaskRefType;
typedef TaskStateType	*TaskStateRefType;
typedef EventMaskType	*EventMaskRefType;
typedef TickType		*TickRefType;
typedef AlarmBaseType	*AlarmBaseRefType;

/*
 *  J[lIuWFNg錾p̃}N
 */
#define DeclareTask(TaskName)		extern const TaskType TaskName
#define DeclareResource(ResName)	extern const ResourceType ResName
#define DeclareEvent(EventName)		extern const EventMaskType EventName
#define DeclareAlarm(AlarmName)		extern const AlarmType AlarmName
/* JE^OSEKdlO	*/
#define DeclareCounter(CounterName)	extern const CounterType CounterName

/*
 *  C[``p̃}N
 */
#define TASKNAME(TaskName)	TaskMain##TaskName
#define TASK(TaskName)		void TaskMain##TaskName(void)
#define ISRNAME(ISRName)	ISRMain##ISRName
#define ISR(ISRName)		void ISRMain##ISRName(void)
#define ALARMCALLBACKNAME(AlarmCallBackName) 	\
							AlarmMain##AlarmCallBackName
#define ALARMCALLBACK(AlarmCallBackName)	\
							void AlarmMain##AlarmCallBackName(void)

/*
 *  VXeT[rXAPI̐錾
 */

/*
 *  ^XNǗ@\
 */
extern StatusType ActivateTask(TaskType tskid);
extern StatusType TerminateTask(void);
extern StatusType ChainTask(TaskType tskid);
extern StatusType Schedule(void);
extern StatusType GetTaskID(TaskRefType p_tskid);
extern StatusType GetTaskState(TaskType tskid, TaskStateRefType p_state);

/*
 *  ݊Ǘ@\
 */
extern void EnableAllInterrupts(void);
extern void DisableAllInterrupts(void);
extern void ResumeAllInterrupts(void);
extern void SuspendAllInterrupts(void);
extern void ResumeOSInterrupts(void);
extern void SuspendOSInterrupts(void);

/*
 *  \[XǗ@\
 */
extern StatusType GetResource(ResourceType resid);
extern StatusType ReleaseResource(ResourceType resid);

/*
 *  Cxg@\
 */
extern StatusType SetEvent(TaskType tskid, EventMaskType mask);
extern StatusType ClearEvent(EventMaskType mask);
extern StatusType GetEvent(TaskType tskid, EventMaskRefType p_mask);
extern StatusType WaitEvent(EventMaskType mask);

/*
 *  A[@\
 */
extern StatusType GetAlarmBase(AlarmType almid, AlarmBaseRefType p_info);
extern StatusType GetAlarm(AlarmType almid, TickRefType p_tick);
extern StatusType SetRelAlarm(AlarmType almid, TickType incr, TickType cycle);
extern StatusType SetAbsAlarm(AlarmType almid, TickType start, TickType cycle);
extern StatusType CancelAlarm(AlarmType almid);

/*
 *  OSs@\
 */
extern AppModeType GetActiveApplicationMode(void);
extern void StartOS(AppModeType mode);
extern void ShutdownOS(StatusType ercd);

/*
 *  JE^@\iOSEKdlOj
 */
extern StatusType SignalCounter(CounterType cntid);

/*
 *  R[obN
 */
extern void ErrorHook(StatusType ercd);
extern void PreTaskHook(void);
extern void PostTaskHook(void);
extern void StartupHook(void);
extern void ShutdownHook(StatusType ercd);

#endif /* _MACRO_ONLY */

/*
 *  OS̃G[R[h
 */
#define E_OS_ACCESS		((StatusType) 1)
#define E_OS_CALLEVEL	((StatusType) 2)
#define E_OS_ID			((StatusType) 3)
#define E_OS_LIMIT		((StatusType) 4)
#define E_OS_NOFUNC		((StatusType) 5)
#define E_OS_RESOURCE	((StatusType) 6)
#define E_OS_STATE		((StatusType) 7)
#define E_OS_VALUE		((StatusType) 8)

/*
 *  ̑̒萔l
 */
#define INVALID_TASK		((TaskType) UINT8_INVALID)	/* ^XN */

#define SUSPENDED			((StatusType) 0)	/* x~ */
#define RUNNING				((StatusType) 1)	/* s */
#define READY				((StatusType) 2)	/* s\ */
#define WAITING				((StatusType) 3)	/* ҂ */

#define RES_SCHEDULER		((ResourceType) 0)	/* XPW[\[X */

#define OSDEFAULTAPPMODE	((AppModeType) 0x01)
									/* ftHgAvP[V[h */

/*
 *  OS̃T[rXAPIID
 */
#define OSServiceId_ActivateTask				((OSServiceIdType) 0)
#define OSServiceId_TerminateTask				((OSServiceIdType) 1)
#define OSServiceId_ChainTask					((OSServiceIdType) 2)
#define OSServiceId_Schedule					((OSServiceIdType) 3)
#define OSServiceId_GetTaskID					((OSServiceIdType) 4)
#define OSServiceId_GetTaskState				((OSServiceIdType) 5)
#define OSServiceId_EnableAllInterrupts			((OSServiceIdType) 6)
#define OSServiceId_DisableAllInterrupts		((OSServiceIdType) 7)
#define OSServiceId_ResumeAllInterrupts			((OSServiceIdType) 8)
#define OSServiceId_SuspendAllInterrupts		((OSServiceIdType) 9)
#define OSServiceId_ResumeOSInterrupts			((OSServiceIdType) 10)
#define OSServiceId_SuspendOSInterrupts			((OSServiceIdType) 11)
#define OSServiceId_GetResource					((OSServiceIdType) 12)
#define OSServiceId_ReleaseResource				((OSServiceIdType) 13)
#define OSServiceId_SetEvent					((OSServiceIdType) 14)
#define OSServiceId_ClearEvent					((OSServiceIdType) 15)
#define OSServiceId_GetEvent					((OSServiceIdType) 16)
#define OSServiceId_WaitEvent					((OSServiceIdType) 17)
#define OSServiceId_GetAlarmBase				((OSServiceIdType) 18)
#define OSServiceId_GetAlarm					((OSServiceIdType) 19)
#define OSServiceId_SetRelAlarm					((OSServiceIdType) 20)
#define OSServiceId_SetAbsAlarm					((OSServiceIdType) 21)
#define OSServiceId_CancelAlarm					((OSServiceIdType) 22)
#define OSServiceId_GetActiveApplicationMode	((OSServiceIdType) 23)
#define OSServiceId_StartOS						((OSServiceIdType) 24)
#define OSServiceId_ShutdownOS					((OSServiceIdType) 25)
#define OSServiceId_SignalCounter				((OSServiceIdType) 26)

/*
 *  G[tbNɓn̂߂̒`i`eOSEKdlOj
 */
#ifndef _MACRO_ONLY

typedef union {
		TaskType			tskid;
		TaskRefType			p_tskid;
		TaskStateRefType	p_state;
		ResourceType		resid;
		EventMaskType		mask;
		EventMaskRefType	p_mask;
		AlarmType			almid;
		AlarmBaseRefType	p_info;
		TickRefType			p_tick;
		TickType			incr;
		TickType			cycle;
		TickType			start;
		AppModeType			mode;
		CounterType			cntid;
	} _ErrorHook_Par;

extern OSServiceIdType	_errorhook_svcid;
extern _ErrorHook_Par	_errorhook_par1, _errorhook_par2, _errorhook_par3;

#endif /* _MACRO_ONLY */

/*
 *  }N̒`
 */
#define OSErrorGetServiceId()				(_errorhook_svcid)

#define OSError_ActivateTask_TaskID()		(_errorhook_par1.tskid)
#define OSError_ChainTask_TaskID()			(_errorhook_par1.tskid)
#define OSError_GetTaskID_TaskID()			(_errorhook_par1.p_tskid)
#define OSError_GetTaskState_TaskID()		(_errorhook_par1.tskid)
#define OSError_GetTaskState_State()		(_errorhook_par2.p_state)
#define OSError_GetResource_ResID()			(_errorhook_par1.resid)
#define OSError_ReleaseResource_ResID()		(_errorhook_par1.resid)
#define OSError_SetEvent_TaskID()			(_errorhook_par1.tskid)
#define OSError_SetEvent_Mask()				(_errorhook_par2.mask)
#define OSError_ClearEvent_Mask()			(_errorhook_par1.mask)
#define OSError_GetEvent_TaskID()			(_errorhook_par1.tskid)
#define OSError_GetEvent_Mask()				(_errorhook_par2.p_mask)
#define OSError_WaitEvent_Mask()			(_errorhook_par1.mask)
#define OSError_GetAlarmBase_AlarmID()		(_errorhook_par1.almid)
#define OSError_GetAlarmBase_Info()			(_errorhook_par2.p_info)
#define OSError_GetAlarm_AlarmID()			(_errorhook_par1.almid)
#define OSError_GetAlarm_Tick()				(_errorhook_par2.p_tick)
#define OSError_SetRelAlarm_AlarmID()		(_errorhook_par1.almid)
#define OSError_SetRelAlarm_increment()		(_errorhook_par2.incr)
#define OSError_SetRelAlarm_cycle()			(_errorhook_par3.cycle)
#define OSError_SetAbsAlarm_AlarmID()		(_errorhook_par1.almid)
#define OSError_SetAbsAlarm_start()			(_errorhook_par2.start)
#define OSError_SetAbsAlarm_cycle()			(_errorhook_par3.cycle)
#define OSError_CancelAlarm_AlarmID()		(_errorhook_par1.almid)
#define OSError_SignalCounter_CounterID()	(_errorhook_par1.cntid)

/*
 *  o[WiITRON4.0dlɏj
 */
#define	TKERNEL_MAKER	0x0118u		/* J[l̃[J[R[h */
#define	TKERNEL_PRID	0x0010u		/* J[l̎ʔԍ */
#define	TKERNEL_SPVER	0x0221u		/* OSEKdl̃o[Wԍ */
#define	TKERNEL_PRVER	0x1010u		/* J[l̃o[Wԍ */

#endif /* _KERNEL_H_ */
