/*
 *  TOPPERS/OSEK Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      OSEK Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2004 by Embedded and Real-Time Systems Laboratory
 *              Graduate School of Information Science, Nagoya Univ., JAPAN
 *  Copyright (C) 2004 by Witz Corporation, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 */

/*
 *	݊Ǘ@\
 */

#ifndef _INTERRUPT_H_
#define _INTERRUPT_H_

/*
 *  ISRiJeS2jID̓Ȓl̒`
 */
#define ISRID_NULL		((IsrType) UINT8_INVALID)	/* ID */

/*
 *  ISRiJeS2jێϐ̐錾ikernel_cfg.cj
 */
extern const UINT8		tnum_isr2;			/* ISRiJeS2j̐ */

/*
 *  ISRiJeS2jubNikernel_cfg.cj
 */
extern const Priority	isrinib_intpri[];	/* ݗDx */

/*
 *  ISRiJeS2jǗubNikernel_cfg.cj
 */
extern ResourceType		isrcb_lastres[];	/* ŌɊl\[X */

/*
 *  ISRiJeS2j̍ōD惌xikernel_cfg.cj
 */
extern const IPL		ipl_maxisr2;

/*
 *  sISRiJeS2j
 *
 *  ISRiJeS2jsĂȂ́CISRID_NULL ɂD
 */
extern IsrType		runisr;

/*
 *  SuspendAllInterrupts ̃lXg
 */
extern UINT8		sus_all_cnt;	/* SuspendAllInterrupts ̃lXg */

/*
 *  ݊Ǘ@\̏
 */
extern void	interrupt_initialize(void);

#endif /* _INTERRUPT_H_ */
