/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2002-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: singleton.cpp,v 1.5 2003/12/15 07:32:14 takayuki Exp $
 */

// $Header: /home/CVS/configurator/base/singleton.cpp,v 1.5 2003/12/15 07:32:14 takayuki Exp $

#include "base/singleton.h"
#include "base/testsuite.h"

using namespace std;

    //Singleton Ūѿ
bool SingletonBase::initialize = false;     //Ѥߥե饰
bool SingletonBase::is_valid   = true;      //󥹥ե饰

struct SingletonBase::chain * SingletonBase::top  = 0;  //ǥȥ饯Υȥå


/************************************* ƥȥ *************************************/

#ifdef TESTSUITE
#include "base/coverage_undefs.h"

    bool throw_DummyType;
    class DummyType {
    public:
        static int counter;
        int dummy_value;
        int order;
        SINGLETON_CONSTRUCTOR(DummyType) throw(bad_alloc) : dummy_value(0), order(++counter)
        {
            CHECKPOINT("DummyType::DummyType");
            if(throw_DummyType)
                throw bad_alloc();
        } 
        ~DummyType(void) throw(int)
        {
            CHECKPOINT("DummyType::~DummyType");
            if(throw_DummyType)
                throw 0;
            if(counter-- != order)
                CHECKPOINT("illegal order");
        }
    };

    SINGLETON_WRAPPER(DummyType2, DummyType)

    int DummyType::counter = 0;

    TESTSUITE(main, SingletonBase)
    {
        struct chain * old_top  = top;

        top  = 0;

        BEGIN_CASE("getInstance","getInstance") {
            BEGIN_CASE("1","ñΥ󥹥󥹤") {
                TestSuite::clearCheckpoints();
                DummyType * dummy = Singleton<DummyType>::getInstance();
                TEST_CASE("1","󥹥ȥ饯ưƤ", TestSuite::isReached("DummyType::DummyType"));

                TestSuite::clearCheckpoints();
                TEST_CASE("2","󥹥󥹤", Singleton<DummyType>::getInstance() == dummy);
                TEST_CASE("3","2ܰʹߤϥ󥹥ȥ饯ưʤ", !TestSuite::isReached("DummyType::DummyType"));
                TEST_CASE("4","󥰥ȥνäƤ", SingletonBase::initialize);
                TEST_CASE("5","ǥȥ饯󤬹Ƥ", SingletonBase::top != 0);
            } END_CASE;
        } END_CASE;

        BEGIN_CASE("final_release","final_release") {
            BEGIN_CASE("1","󥹥󥹤Ǥ") {
                TEST_CASE("0","[] ٤Ǥ", SingletonBase::top != 0);

                TestSuite::clearCheckpoints();
                SingletonBase::final_release();

                TEST_CASE("1","ǥȥ饯ưƤ", TestSuite::isReached("DummyType::~DummyType"));
                TEST_CASE("2","ǥȥ饯󤬤ʤʤäƤ", SingletonBase::top == 0);
            } END_CASE;

            BEGIN_CASE("2","֤") {
                DummyType::counter = 0;

                DummyType  * dummy  = Singleton<DummyType>::getInstance();
                DummyType2 * dummy2 = Singleton<DummyType2>::getInstance();

                TEST_CASE("0","[] ", dummy->order == 1 && dummy2->order == 2);

                TestSuite::clearCheckpoints();
                SingletonBase::final_release();

                TEST_CASE("1","ǥȥ饯ưƤ", TestSuite::isReached("DummyType::~DummyType"));
                TEST_CASE("2","ǥȥ饯󤬤ʤʤäƤ", SingletonBase::top == 0);
                TEST_CASE("3","˴", !TestSuite::isReached("illegal order"));
            } END_CASE;

        } END_CASE;

        BEGIN_CASE("getInstance","getInstance") {
            BEGIN_CASE("1","㳰") {
                BEGIN_CASE("1","getInstance()") {
                    throw_DummyType = true;
                    bool result = false;
                    try { Singleton<DummyType>::getInstance(); }
                    catch(...) { result = true; }

                    TEST_CASE("1","㳰ϵ",result);
                    TEST_CASE("2","ǥȥ饯ˤϲĤʤäƤʤ", SingletonBase::top == 0);
                } END_CASE;

                SingletonBase::final_release();

                BEGIN_CASE("2","getInstance(nothrow)") {

                    DummyType * dummy;
                    throw_DummyType = true;
                    bool result = true;
                    try { dummy = Singleton<DummyType>::getInstance(nothrow); }
                    catch(...) { result = false; }

                    TEST_CASE("1","㳰ϵʤ",result);
                    TEST_CASE("2","NULL֤", dummy == 0);
                    TEST_CASE("3","ǥȥ饯ˤϲĤʤäƤʤ", SingletonBase::top == 0);
                } END_CASE;
            } END_CASE;
        } END_CASE;

        top  = old_top;
    }

#endif



