/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *                2003      by Advanced Data Controls, Corp
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: ghs_hook.c,v 1.2 2003/12/19 11:48:37 honda Exp $
 */
#ifdef GHS_HOOK
#include "jsp_kernel.h"
#include "kernel.h"
#include "time_event.h"
#include "task.h"
#include "ghs_hook.h"


#define	THG_ALL	THG_SYS|THG_RET|THG_DSP|THG_STS|THG_INT
#define	THF_ALL	THF_TSK|THF_TSKS|THF_TEX|THF_SEM|THF_FLG|THF_DTQ|THF_MBX|THF_MPF|THF_TIM
#ifndef GRP
#define	GRP	THG_ALL
#endif
#ifndef SEV
#define	SEV	THF_ALL  
#endif
#ifndef TSK
#define	TSK	TRACE_TNUM_TSKID
#endif


#define MAX_TSK  256

T_ROS Ros_buf;

struct GHS_TASKS {
	B	sts;			
	B	pri;			
} ghs_tasks[MAX_TSK];

ghs_tasks_initialize()
{
	INT	i;
	TCB	*tcb;

	for (tcb = tcb_table, i = 0; i < tmax_tskid; tcb++, i++) {
		if(i > sizeof(ghs_tasks) / sizeof(ghs_tasks[0]))
			return;
		if(TSTAT_RUNNABLE(tcb->tstat)) ghs_tasks[i].sts = TTS_RDY;
		else ghs_tasks[i].sts = TTS_DMT;
		ghs_tasks[i].pri = EXT_TSKPRI(tcb->priority);
	}
}

int SetEndian()
{
    union testme {
        char    a[2];
        short   b;
    	} testme;

    testme.b    = 0;
    testme.a[0] = 1;
    if (testme.b== 1)
        return(0);
    else
        return(1);
}

void vinit_hook(void)
{
    int i;

    Ros_buf.trace.bigendian = SetEndian();
    Ros_buf.trace.dummy = 0;
    Ros_buf.trace.size = BUFF_SIZE-1;
    Ros_buf.trace.putp = 0;
    Ros_buf.trace.getp = 0;
    for(i = 0; i < TRACE_TNUM_TSKID-1; i++)
        Ros_buf.hook.task_id[i] = 0;
    for(i = 0; i < TRACE_TNUM_EVT-1; i++)
        Ros_buf.hook.evtcode[i] = 0;
    Ros_buf.hook.max_tid = tmax_tskid;
    Ros_buf.hook.tnum_tskid = TRACE_TNUM_TSKID;
    Ros_buf.hook.tnum_evt = TRACE_TNUM_EVT;

    Ros_buf.hook.trc_grp = GRP;
    Ros_buf.hook.sys_grp = SEV;
    for(i = 0; i < TSK; i++)
        Ros_buf.hook.task_id[i] = 1;    
    
}

void ghs_hook4(int sts, int p1, int p2)
{
    int putp;

        while(BUFF_SIZE-(Ros_buf.trace.putp-Ros_buf.trace.getp) < 4)
        {
	    Ros_buf.trace.getp += Ros_buf.syscall[Ros_buf.trace.getp & Ros_buf.trace.size] & 0x0F;
        }
        putp = Ros_buf.trace.putp;
        Ros_buf.syscall[putp++ & Ros_buf.trace.size] = (sts << 4) | 4;
        Ros_buf.syscall[putp++ & Ros_buf.trace.size] = current_time;
        Ros_buf.syscall[putp++ & Ros_buf.trace.size] = p1;
        Ros_buf.syscall[putp++ & Ros_buf.trace.size] = p2;
        Ros_buf.trace.putp = putp;
}

void ghs_hook5(int sts, int p1, int p2, int p3)
{
    int putp;

        while(BUFF_SIZE-(Ros_buf.trace.putp-Ros_buf.trace.getp) < 5)
        {   Ros_buf.trace.getp += Ros_buf.syscall[Ros_buf.trace.getp & Ros_buf.trace.size] & 0x0F;
        }
	putp = Ros_buf.trace.putp;
        Ros_buf.syscall[putp++ & Ros_buf.trace.size] = (sts << 4) | 5;
        Ros_buf.syscall[putp++ & Ros_buf.trace.size] = current_time;
        Ros_buf.syscall[putp++ & Ros_buf.trace.size] = p1;
        Ros_buf.syscall[putp++ & Ros_buf.trace.size] = p2;
        Ros_buf.syscall[putp++ & Ros_buf.trace.size] = p3;
        Ros_buf.trace.putp = putp;
}

void ghs_hook6(int sts, int p1, int p2, int p3, int p4)
{
    int putp;

        while(BUFF_SIZE-(Ros_buf.trace.putp-Ros_buf.trace.getp) < 6)
        {   Ros_buf.trace.getp += Ros_buf.syscall[Ros_buf.trace.getp & Ros_buf.trace.size] & 0x0F;
        }

        putp = Ros_buf.trace.putp;
        Ros_buf.syscall[putp++ & Ros_buf.trace.size] = (sts << 4) | 6;
        Ros_buf.syscall[putp++ & Ros_buf.trace.size] = current_time;
        Ros_buf.syscall[putp++ & Ros_buf.trace.size] = p1;
        Ros_buf.syscall[putp++ & Ros_buf.trace.size] = p2;
        Ros_buf.syscall[putp++ & Ros_buf.trace.size] = p3;
        Ros_buf.syscall[putp++ & Ros_buf.trace.size] = p4;
        Ros_buf.trace.putp = putp;
}

void ghs_hook7(int sts, int p1, int p2, int p3, int p4, int p5)
{
    int putp;

        while(BUFF_SIZE-(Ros_buf.trace.putp-Ros_buf.trace.getp) < 7)
        {   Ros_buf.trace.getp += Ros_buf.syscall[Ros_buf.trace.getp & Ros_buf.trace.size] & 0x0F;
        }

        putp = Ros_buf.trace.putp;
        Ros_buf.syscall[putp++ & Ros_buf.trace.size] = (sts << 4) | 7;
        Ros_buf.syscall[putp++ & Ros_buf.trace.size] = current_time;
        Ros_buf.syscall[putp++ & Ros_buf.trace.size] = p1;
        Ros_buf.syscall[putp++ & Ros_buf.trace.size] = p2;
        Ros_buf.syscall[putp++ & Ros_buf.trace.size] = p3;
        Ros_buf.syscall[putp++ & Ros_buf.trace.size] = p4;
        Ros_buf.syscall[putp++ & Ros_buf.trace.size] = p5;
        Ros_buf.trace.putp = putp;
}

void ghs_hook8(int sts, int p1, int p2, int p3, int p4, int p5, int p6)
{
    int putp;

        while(BUFF_SIZE-(Ros_buf.trace.putp-Ros_buf.trace.getp) < 8)
        {   Ros_buf.trace.getp += Ros_buf.syscall[Ros_buf.trace.getp & Ros_buf.trace.size] & 0x0F;
        }
        putp = Ros_buf.trace.putp;
        Ros_buf.syscall[putp++ & Ros_buf.trace.size] = (sts << 4) | 8;
        Ros_buf.syscall[putp++ & Ros_buf.trace.size] = current_time;
        Ros_buf.syscall[putp++ & Ros_buf.trace.size] = p1;
        Ros_buf.syscall[putp++ & Ros_buf.trace.size] = p2;
        Ros_buf.syscall[putp++ & Ros_buf.trace.size] = p3;
        Ros_buf.syscall[putp++ & Ros_buf.trace.size] = p4;
        Ros_buf.syscall[putp++ & Ros_buf.trace.size] = p5;
        Ros_buf.syscall[putp++ & Ros_buf.trace.size] = p6;
        Ros_buf.trace.putp = putp;
}

void ghs_hook9(int sts, int p1, int p2, int p3, int p4, int p5, int p6, int p7)
{
    int putp;

        while(BUFF_SIZE-(Ros_buf.trace.putp-Ros_buf.trace.getp) < 9)
        {   Ros_buf.trace.getp += Ros_buf.syscall[Ros_buf.trace.getp & Ros_buf.trace.size] & 0x0F;
        }

        putp = Ros_buf.trace.putp;
        Ros_buf.syscall[putp++ & Ros_buf.trace.size] = (sts << 4) | 9;
        Ros_buf.syscall[putp++ & Ros_buf.trace.size] = current_time;
        Ros_buf.syscall[putp++ & Ros_buf.trace.size] = p1;
        Ros_buf.syscall[putp++ & Ros_buf.trace.size] = p2;
        Ros_buf.syscall[putp++ & Ros_buf.trace.size] = p3;
        Ros_buf.syscall[putp++ & Ros_buf.trace.size] = p4;
        Ros_buf.syscall[putp++ & Ros_buf.trace.size] = p5;
        Ros_buf.syscall[putp++ & Ros_buf.trace.size] = p6;
        Ros_buf.syscall[putp++ & Ros_buf.trace.size] = p7;
        Ros_buf.trace.putp = putp;
}

#endif

