/*
 *  TOPPERS/OSEK Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      OSEK Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2004 by Embedded and Real-Time Systems Laboratory
 *              Graduate School of Information Science, Nagoya Univ., JAPAN
 *  Copyright (C) 2004 by Witz Corporation, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 */

/*
 *	^XNǗ@\
 */

#include "osek_kernel.h"
#include "check.h"
#include "task.h"
#include "resource.h"

/*
 *  ^XN̋N
 */
StatusType
ActivateTask(TaskType tskid)
{
	StatusType	ercd = E_OK;

	LOG_ACTTSK_ENTER(tskid);
	CHECK_CALLEVEL(TCL_TASK | TCL_ISR2);
	CHECK_TSKID(tskid);

	lock_cpu();
	if (tcb_tstat[tskid] == TS_DORMANT) {
		if ((make_active(tskid)) && (callevel == TCL_TASK)) {
			dispatch();
		}
	}
	else if (tcb_actcnt[tskid] < tinib_maxact[tskid]) {
		tcb_actcnt[tskid] += 1;
	}
	else {
		ercd = E_OS_LIMIT;
		goto d_error_exit;
	}
  exit:
	unlock_cpu();
	LOG_ACTTSK_LEAVE(ercd);
	return(ercd);

  error_exit:
	lock_cpu();
  d_error_exit:
	_errorhook_par1.tskid = tskid;
	call_errorhook(ercd, OSServiceId_ActivateTask);
	goto exit;
}

/*
 *  ^XN̏I
 */
StatusType
TerminateTask(void)
{
	StatusType	ercd = E_OK;

	LOG_TERTSK_ENTER();
	CHECK_CALLEVEL(TCL_TASK);
	CHECK_RESOURCE(tcb_lastres[runtsk] == RESID_NULL);

	lock_cpu();
	/*
	 *  \[X̉͗Dx邾Ȃ̂ŁCł
	 *  ȂĂ悢D
	 */
	tcb_tstat[runtsk] = TS_DORMANT;
	search_schedtsk();
	if (tcb_actcnt[runtsk] > 0) {
		tcb_actcnt[runtsk] -= 1;
		(void)make_active(runtsk);
	}
	exit_and_dispatch();
	/* ɂ͖߂ĂȂ */

  error_exit:
	lock_cpu();
	call_errorhook(ercd, OSServiceId_TerminateTask);
	unlock_cpu();
	LOG_TERTSK_LEAVE(ercd);
	return(ercd);
}

/*
 *  ^XN̏Iƃ^XN̋N
 */
StatusType
ChainTask(TaskType tskid)
{
	/*
	 *  ł ercd ͖̏{͕svł邪CRpČx
	 *  bZ[W邽߂ɏĂD
	 */
	StatusType	ercd = E_OK;

	LOG_CHNTSK_ENTER(tskid);
	CHECK_CALLEVEL(TCL_TASK);
	CHECK_RESOURCE(tcb_lastres[runtsk] == RESID_NULL);
	CHECK_TSKID(tskid);

	lock_cpu();
	if (tskid == runtsk) {
		// tcb_tstat[runtsk] = TS_DORMANT;
		search_schedtsk();
		(void)make_active(runtsk);
	}
	else {
		/*
		 *  G[ɕpcȂ悤ɁCG[`FbN
		 *  ^XNȊOɍsKvD
		 */
		if ((tcb_tstat[tskid] != TS_DORMANT)
			&& (tcb_actcnt[tskid] >= tinib_maxact[tskid])) {
			ercd = E_OS_LIMIT;
			goto d_error_exit;
		}
		tcb_tstat[runtsk] = TS_DORMANT;
		search_schedtsk();
		if (tcb_actcnt[runtsk] > 0) {
			tcb_actcnt[runtsk] -= 1;
			(void)make_active(runtsk);
		}
		if (tcb_tstat[tskid] == TS_DORMANT) {
			(void)make_active(tskid);
		}
		else {
			tcb_actcnt[tskid] += 1;
		}
	}
	exit_and_dispatch();
	/* ɂ͖߂ĂȂ */

  error_exit:
	lock_cpu();
  d_error_exit:
	_errorhook_par1.tskid = tskid;
	call_errorhook(ercd, OSServiceId_ChainTask);
	unlock_cpu();
	LOG_CHNTSK_LEAVE(ercd);
	return(ercd);
}

/*
 *  XPW[̌Ăяo
 */
StatusType
Schedule(void)
{
	/*
	 *  ł ercd ͖̏{͕svł邪CRpČx
	 *  bZ[W邽߂ɏĂD
	 */
	StatusType	ercd = E_OK;

	LOG_SCHED_ENTER();
	CHECK_CALLEVEL(TCL_TASK);
	CHECK_RESOURCE(tcb_lastres[runtsk] == RESID_NULL);

	lock_cpu();
	if (tinib_inipri[runtsk] < nextpri) {
		tcb_curpri[runtsk] = tinib_inipri[runtsk];
		preempt();
		dispatch();
		tcb_curpri[runtsk] = tinib_exepri[runtsk];
	}
  exit:
	unlock_cpu();
	LOG_SCHED_LEAVE(ercd);
	return(ercd);

  error_exit:
	lock_cpu();
	call_errorhook(ercd, OSServiceId_Schedule);
	goto exit;
}

/*
 *  sԂ̃^XNID̎Q
 */
StatusType
GetTaskID(TaskRefType p_tskid)
{
	StatusType	ercd = E_OK;

	LOG_GETTID_ENTER(p_tskid);
	CHECK_CALLEVEL(TCL_TASK | TCL_ISR2 | TCL_ERROR | TCL_PREPOST);

	lock_cpu();
	*p_tskid = runtsk;
	/*
	 *  { runtsk ł͂Ȃȉ̎ɂȂׂCTSKID_NULL 
	 *   INVALID_TASK ͓̂ŁCP runtsk ł悢D
	 *      (runtsk == TSKID_NULL) ? INVALID_TASK : runtsk
	 */
  exit:
	unlock_cpu();
	LOG_GETTID_LEAVE(ercd, *p_tskid);
	return(ercd);

  error_exit:
	lock_cpu();
	call_errorhook(ercd, OSServiceId_GetTaskID);
	goto exit;

}

/*
 *  ^XNԂ̎Q
 */
StatusType
GetTaskState(TaskType tskid, TaskStateRefType p_state)
{
	StatusType	ercd = E_OK;

	LOG_GETTST_ENTER(tskid, p_state);
	CHECK_CALLEVEL(TCL_TASK | TCL_ISR2 | TCL_ERROR | TCL_PREPOST);
	CHECK_TSKID(tskid);

	lock_cpu();
	*p_state = (tskid == runtsk) ? RUNNING : tcb_tstat[tskid];
  exit:
	unlock_cpu();
	LOG_GETTST_LEAVE(ercd, *p_state);
	return(ercd);

  error_exit:
	lock_cpu();
	_errorhook_par1.tskid = tskid;
	_errorhook_par2.p_state = p_state;
	call_errorhook(ercd, OSServiceId_GetTaskState);
	goto exit;
}
