/*
 *  TOPPERS/OSEK Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      OSEK Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2004 by Embedded and Real-Time Systems Laboratory
 *              Graduate School of Information Science, Nagoya Univ., JAPAN
 *  Copyright (C) 2004 by Witz Corporation, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 */

/*
 *	OSEKJ[l WCN[ht@C
 *
 *  ̃CN[ht@ĆCJ[l\vÕ\[Xt@
 *  CŕKCN[hׂWCN[ht@CłD
 *
 *  AZũ\[Xt@CVXeRtBM[Vt@
 *  C炱̃t@CCN[h鎞́C_MACRO_ONLY `
 *  ƂŁC}N`ȊŐLqƂłD
 */

#ifndef _OSEK_KERNEL_H_
#define _OSEK_KERNEL_H_

/*
 *  J[lʂ̃CN[ht@C
 */
#include <kernel.h>

/*
 *  J[lŎgpf[^^̒`
 */
#ifndef _MACRO_ONLY
typedef void		*VP;			/* ^܂Ȃ̂ւ̃|C^ */
typedef void		(*FP)(void);	/* vŐNԒni|C^j */
typedef UINT8		Priority;		/* Dxi^XNCISRj */
typedef	UINT8		IPL;			/* ݗD惌x */
#endif /* _MACRO_ONLY */

/*
 *  Dx̒iK̒`
 */
#define TNUM_PRIORITY	((Priority) 16)

/*
 *  ʓIȒ萔̒`
 */
#define	NULL			((void *) 0)		/* |C^ */

/*
 *  Dxl̒`
 */
#define TPRI_MINTASK	((Priority) 0)		/* Œ^XNDx */
#define TPRI_MAXTASK	((Priority)(TNUM_PRIORITY - 1))
											/* ō^XNDx */
#define TPRI_SCHEDULER	((Priority) 127)	/* XPW[̗Dx */
#define TPRI_MINISR		((Priority) 128)	/* ŒኄݗDx */
#define TPRI_NULL		((Priority) UINT8_INVALID)
											/* Dx */

/*
 *  Cxg}XNl̒`
 */
#define EVTMASK_NONE	((EventMaskType) 0)	/* CxgȂ */

/*
 *  AvP[V[hl̒`
 */
#define APPMODE_NONE	((AppModeType) 0)	/* [hȂ */

/*
 *  IPLl̒`
 */
#define IPL_ENA_ALL	((IPL) 0)		/* ׂĂ݂̊ */

/*
 *  s̃ReLXgicallevelj̒l̒`
 */
#define TCL_NULL		((UINT8) 0x00)	/* T[rXR[ĂяoȂ */
#define TCL_TASK		((UINT8) 0x01)	/* ^XN */
#define TCL_ISR2		((UINT8) 0x02)	/* JeS2 ISR */
#define TCL_ERROR		((UINT8) 0x04)	/* ErrorHook */
#define TCL_PREPOST		((UINT8) 0x08)	/* PreTaskHookCPostTaskHook */
#define TCL_STARTUP		((UINT8) 0x10)	/* StartupHook */
#define TCL_SHUTDOWN	((UINT8) 0x20)	/* ShutdownHook */

/*
 *  ^[Qbgˑ̒`
 */
#include <t_config.h>

#ifndef _MACRO_ONLY
/*
 *  OSŝ߂̕ϐiosctl.cj
 */
extern UINT8		callevel;	/* s̃ReLXg */
extern AppModeType	appmode;	/* AvP[V[h */

/*
 *  OS̃NeBJZNV֐
 */
Inline void	lock_cpu(void);		/* NeBJZNVJn */
Inline void	unlock_cpu(void);	/* NeBJZNVI */

Inline void
lock_cpu(void)
{
	disable_int();
}

Inline void
unlock_cpu(void)
{
	enable_int();
}

/*
 *  G[tbNĂяô߂̐錾iosctl.cj
 *
 *  T[rXR[ŃG[ꍇɂ́CT[rXR[ւ̃p
 *  [^ _errorhook_par1`3 ɐݒ肵Ccall_errorhook ĂяoD
 *  call_errorhook ւ́CG[R[hƃT[rXR[IDnD
 */
extern void	call_errorhook(StatusType ercd, OSServiceIdType svcid);

/*
 *  |Xg^XNtbN/v^XNtbNĂяô߂̐錾iosctl.cj
 */
extern void	call_posttaskhook(void);
extern void	call_pretaskhook(void);

/*
 *  eW[̏ikernel_cfg.cj
 */
extern void	object_initialize(void);

#endif /* _MACRO_ONLY */

/*
 *  gXe[^XW
 */
#ifndef BASIC_STATUS
#define EXTENDED_STATUS
#endif /* BASIC_STATUS */

#endif /* _OSEK_KERNEL_H_ */
