/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: kernellogcontrol.cpp,v 1.2 2003/06/30 15:58:39 takayuki Exp $
 */

// KernelLogControl.cpp : CKernelLogControl Υץơ

#include "stdafx.h"
#include "Watcher.h"
#include "KernelLogControl.h"

/////////////////////////////////////////////////////////////////////////////
// CKernelLogControl


STDMETHODIMP CKernelLogControl::Open()
{
	// TODO: ΰ֤˥ץѤΥɤɲäƤ
	if(!FAILED(manager.CoCreateInstance(CLSID_KernelLog)) && !FAILED(manager.Advise((_IKernelLogEvents *)this,__uuidof(_IKernelLogEvents),&cookie)))
		return S_OK;
	if(!!manager)
		manager.Release();
	return E_FAIL;
}

STDMETHODIMP CKernelLogControl::Close()
{
	// TODO: ΰ֤˥ץѤΥɤɲäƤ
	if(!manager)
		return E_FAIL;

	AtlUnadvise(manager, __uuidof(_IKernelLogEvents),cookie);
	manager.Release();
	cookie = 0;
	return S_OK;
}

STDMETHODIMP CKernelLogControl::get_Type(long *pVal)
{
	// TODO: ΰ֤˥ץѤΥɤɲäƤ
	if(log != NULL)
	{
		*pVal = (long)log->header.logtype;
	}else
		*pVal = 0;

	return S_OK;
}

STDMETHODIMP CKernelLogControl::get_Logtim(long *pVal)
{
	// TODO: ΰ֤˥ץѤΥɤɲäƤ
	if(log != NULL)
	{
		*pVal = (long)log->header.logtim;
	}else
		*pVal = 0;
	return S_OK;
}

STDMETHODIMP CKernelLogControl::get_isValid(BOOL *pVal)
{
	// TODO: ΰ֤˥ץѤΥɤɲäƤ
	if(log != NULL)
		*pVal = TRUE;
	else
		*pVal = FALSE;
	return S_OK;
}

STDMETHODIMP CKernelLogControl::get_Param(long index, long *pVal)
{
	// TODO: ΰ֤˥ץѤΥɤɲäƤ
	*pVal = *((long *)&log->body + index);

	return S_OK;
}
