/*
 * Decompiled with CFR 0.152.
 */
package js.tinyvm;

import java.util.Hashtable;
import java.util.Vector;
import js.common.ToolProgressMonitor;
import js.tinyvm.ClassPath;
import js.tinyvm.ClassRecord;
import js.tinyvm.ConstantRecord;
import js.tinyvm.EntryClassIndex;
import js.tinyvm.MasterRecord;
import js.tinyvm.RecordTable;
import js.tinyvm.Signature;
import js.tinyvm.SpecialClassConstants;
import js.tinyvm.SpecialSignatureConstants;
import js.tinyvm.TinyVMException;
import js.tinyvm.io.IByteWriter;
import js.tinyvm.util.HashVector;

public class Binary {
    final RecordTable iEntireBinary = new RecordTable("binary", true, false);
    final MasterRecord iMasterRecord = new MasterRecord(this);
    final RecordTable iClassTable = new RecordTable("class table", false, false);
    final RecordTable iStaticState = new RecordTable("static state", true, true);
    final RecordTable iStaticFields = new RecordTable("static fields", true, false);
    final RecordTable iConstantTable = new RecordTable("constants", false, false);
    final RecordTable iMethodTables = new RecordTable("methods", true, false);
    final RecordTable iExceptionTables = new RecordTable("exceptions", false, false);
    final RecordTable iInstanceFieldTables = new RecordTable("instance fields", true, false);
    final RecordTable iCodeSequences = new RecordTable("code", true, false);
    final RecordTable iConstantValues = new RecordTable("constant values", true, false);
    final RecordTable iEntryClassIndices = new RecordTable("entry class indices", true, false);
    final Hashtable iSpecialSignatures = new Hashtable();
    final Hashtable iClasses = new Hashtable();
    final HashVector iSignatures = new HashVector();
    static final /* synthetic */ boolean $assertionsDisabled;

    public void dump(IByteWriter writer) throws TinyVMException {
        this.iEntireBinary.dump(writer);
    }

    protected void addClassRecord(String className, ClassRecord classRecord) {
        if (!$assertionsDisabled && className == null) {
            throw new AssertionError((Object)"Precondition: className != null");
        }
        if (!$assertionsDisabled && classRecord == null) {
            throw new AssertionError((Object)"Precondition: classRecord != null");
        }
        if (!$assertionsDisabled && className.indexOf(46) != -1) {
            throw new AssertionError((Object)"Precondition: className is in correct form");
        }
        this.iClasses.put(className, classRecord);
        this.iClassTable.add(classRecord);
    }

    public boolean hasMain(String className) {
        if (!$assertionsDisabled && className == null) {
            throw new AssertionError((Object)"Precondition: className != null");
        }
        if (!$assertionsDisabled && className.indexOf(46) != -1) {
            throw new AssertionError((Object)"Precondition: className is in correct form");
        }
        ClassRecord pRec = this.getClassRecord(className);
        return pRec.hasMethod(new Signature("main", "([Ljava/lang/String;)V"), true);
    }

    public ClassRecord getClassRecord(String className) {
        if (!$assertionsDisabled && className == null) {
            throw new AssertionError((Object)"Precondition: className != null");
        }
        if (!$assertionsDisabled && className.indexOf(46) != -1) {
            throw new AssertionError((Object)"Precondition: className is in correct form");
        }
        return (ClassRecord)this.iClasses.get(className);
    }

    public int getClassIndex(String className) {
        if (!$assertionsDisabled && className == null) {
            throw new AssertionError((Object)"Precondition: className != null");
        }
        if (!$assertionsDisabled && className.indexOf(46) != -1) {
            throw new AssertionError((Object)"Precondition: className is in correct form");
        }
        return this.getClassIndex(this.getClassRecord(className));
    }

    public int getClassIndex(ClassRecord classRecord) {
        if (classRecord == null) {
            return -1;
        }
        return this.iClassTable.indexOf(classRecord);
    }

    public ConstantRecord getConstantRecord(int index) {
        if (!$assertionsDisabled && index < 0) {
            throw new AssertionError((Object)"Precondition: index >= 0");
        }
        return (ConstantRecord)this.iConstantTable.get(index);
    }

    public int getConstantIndex(ConstantRecord constantRecord) {
        if (constantRecord == null) {
            return -1;
        }
        return this.iConstantTable.indexOf(constantRecord);
    }

    public static Binary createFromClosureOf(String[] entryClassNames, ClassPath classPath, boolean all) throws TinyVMException {
        Binary result = new Binary();
        result.processClasses(entryClassNames, classPath);
        result.processSpecialSignatures();
        result.processConstants();
        result.processMethods(all);
        result.processFields();
        result.processCode(false);
        result.storeComponents();
        result.initOffsets();
        result.processCode(true);
        if (!$assertionsDisabled && result == null) {
            throw new AssertionError((Object)"Postconditon: result != null");
        }
        return result;
    }

    public void processClasses(String[] entryClassNames, ClassPath classPath) throws TinyVMException {
        ClassRecord classRecord;
        String className;
        int i;
        if (!$assertionsDisabled && entryClassNames == null) {
            throw new AssertionError((Object)"Precondition: entryClassNames != null");
        }
        if (!$assertionsDisabled && classPath == null) {
            throw new AssertionError((Object)"Precondition: classPath != null");
        }
        Vector pInterfaceMethods = new Vector();
        String[] specialClasses = SpecialClassConstants.CLASSES;
        for (i = 0; i < specialClasses.length; ++i) {
            className = specialClasses[i];
            classRecord = ClassRecord.getClassRecord(className, classPath, this);
            this.addClassRecord(className, classRecord);
        }
        for (i = 0; i < entryClassNames.length; ++i) {
            className = entryClassNames[i];
            classRecord = ClassRecord.getClassRecord(className, classPath, this);
            this.addClassRecord(className, classRecord);
            classRecord.useAllMethods();
            this.iEntryClassIndices.add(new EntryClassIndex(this, className));
        }
        for (int pIndex = 0; pIndex < this.iClassTable.size(); ++pIndex) {
            ClassRecord classRecord2 = (ClassRecord)this.iClassTable.get(pIndex);
            classRecord2.storeReferredClasses(this.iClasses, this.iClassTable, classPath, pInterfaceMethods);
        }
        int pSize = this.iClassTable.size();
        int pIndex = 0;
        while (pIndex < pSize) {
            classRecord = (ClassRecord)this.iClassTable.get(pIndex);
            for (int i2 = 0; i2 < pInterfaceMethods.size(); ++i2) {
                classRecord.addUsedMethod((String)pInterfaceMethods.elementAt(i2));
            }
            classRecord.iIndex = pIndex++;
            classRecord.initFlags();
            classRecord.initParent();
        }
    }

    public void processSpecialSignatures() {
        for (int i = 0; i < SpecialSignatureConstants.SIGNATURES.length; ++i) {
            Signature pSig = new Signature(SpecialSignatureConstants.SIGNATURES[i]);
            this.iSignatures.addElement(pSig);
            this.iSpecialSignatures.put(pSig, SpecialSignatureConstants.SIGNATURES[i]);
        }
    }

    public boolean isSpecialSignature(Signature aSig) {
        return this.iSpecialSignatures.containsKey(aSig);
    }

    public void processConstants() throws TinyVMException {
        int pSize = this.iClassTable.size();
        for (int pIndex = 0; pIndex < pSize; ++pIndex) {
            ClassRecord pRec = (ClassRecord)this.iClassTable.get(pIndex);
            pRec.storeConstants(this.iConstantTable, this.iConstantValues);
        }
    }

    public void processMethods(boolean iAll) throws TinyVMException {
        int pSize = this.iClassTable.size();
        for (int pIndex = 0; pIndex < pSize; ++pIndex) {
            ClassRecord classRecord = (ClassRecord)this.iClassTable.get(pIndex);
            classRecord.storeMethods(this.iMethodTables, this.iExceptionTables, this.iSignatures, iAll);
        }
    }

    public void processFields() throws TinyVMException {
        int pSize = this.iClassTable.size();
        for (int pIndex = 0; pIndex < pSize; ++pIndex) {
            ClassRecord pRec = (ClassRecord)this.iClassTable.get(pIndex);
            pRec.storeFields(this.iInstanceFieldTables, this.iStaticFields, this.iStaticState);
        }
    }

    public void processCode(boolean aPostProcess) throws TinyVMException {
        int pSize = this.iClassTable.size();
        for (int pIndex = 0; pIndex < pSize; ++pIndex) {
            ClassRecord pRec = (ClassRecord)this.iClassTable.get(pIndex);
            pRec.storeCode(this.iCodeSequences, aPostProcess);
        }
    }

    public void storeComponents() {
        this.iEntireBinary.add(this.iMasterRecord);
        this.iEntireBinary.add(this.iClassTable);
        this.iEntireBinary.add(this.iStaticState);
        this.iEntireBinary.add(this.iStaticFields);
        this.iEntireBinary.add(this.iConstantTable);
        this.iEntireBinary.add(this.iMethodTables);
        this.iEntireBinary.add(this.iExceptionTables);
        this.iEntireBinary.add(this.iInstanceFieldTables);
        this.iEntireBinary.add(this.iCodeSequences);
        this.iEntireBinary.add(this.iConstantValues);
        this.iEntireBinary.add(this.iEntryClassIndices);
    }

    public void initOffsets() throws TinyVMException {
        this.iEntireBinary.initOffset(0);
    }

    public int getTotalNumMethods() {
        int pTotal = 0;
        int pSize = this.iMethodTables.size();
        for (int i = 0; i < pSize; ++i) {
            pTotal += ((RecordTable)this.iMethodTables.get(i)).size();
        }
        return pTotal;
    }

    public int getTotalNumInstanceFields() {
        int pTotal = 0;
        int pSize = this.iInstanceFieldTables.size();
        for (int i = 0; i < pSize; ++i) {
            pTotal += ((RecordTable)this.iInstanceFieldTables.get(i)).size();
        }
        return pTotal;
    }

    public void log(ToolProgressMonitor monitor) throws TinyVMException {
        int pSize = this.iSignatures.size();
        for (int i = 0; i < pSize; ++i) {
            Signature pSig = (Signature)this.iSignatures.elementAt(i);
            monitor.log("Signature " + i + ": " + pSig.getImage());
        }
        monitor.log("Master record : " + this.iMasterRecord.getLength() + " bytes.");
        monitor.log("Class records : " + this.iClassTable.size() + " (" + this.iClassTable.getLength() + " bytes).");
        monitor.log("Field records : " + this.getTotalNumInstanceFields() + " (" + this.iInstanceFieldTables.getLength() + " bytes).");
        monitor.log("Method records: " + this.getTotalNumMethods() + " (" + this.iMethodTables.getLength() + " bytes).");
        monitor.log("Code          : " + this.iCodeSequences.size() + " (" + this.iCodeSequences.getLength() + " bytes).");
    }

    static {
        $assertionsDisabled = !Binary.class.desiredAssertionStatus();
    }
}

