/*
 * Decompiled with CFR 0.152.
 */
package js.tinyvm;

import java.io.IOException;
import js.tinyvm.Binary;
import js.tinyvm.TinyVMException;
import js.tinyvm.WritableData;
import js.tinyvm.io.IByteWriter;
import js.tinyvm.io.IOUtilities;
import org.apache.bcel.classfile.CodeException;
import org.apache.bcel.classfile.ConstantClass;
import org.apache.bcel.classfile.JavaClass;

public class ExceptionRecord
implements WritableData {
    CodeException iExcep;
    int iClassIndex;

    public ExceptionRecord(CodeException aExcep, Binary aBinary, JavaClass aCF) throws Exception {
        this.iExcep = aExcep;
        int pCPIndex = aExcep.getCatchType();
        if (pCPIndex == 0) {
            this.iClassIndex = aBinary.getClassIndex("java/lang/Throwable");
        } else {
            ConstantClass pCls = (ConstantClass)aCF.getConstantPool().getConstant(pCPIndex);
            String pName = pCls.getBytes(aCF.getConstantPool());
            this.iClassIndex = aBinary.getClassIndex(pName);
        }
        if (this.iClassIndex == -1) {
            throw new TinyVMException("Exception not found: " + this.iExcep);
        }
    }

    public int getLength() {
        return IOUtilities.adjustedSize(7, 2);
    }

    public void dump(IByteWriter aOut) throws TinyVMException {
        int pStart = this.iExcep.getStartPC();
        int pEnd = this.iExcep.getEndPC();
        int pHandler = this.iExcep.getHandlerPC();
        if (pStart > 65535 || pEnd > 65535 || pHandler > 65535) {
            throw new TinyVMException("Exception handler with huge PCs");
        }
        try {
            aOut.writeU2(pStart);
            aOut.writeU2(pEnd);
            aOut.writeU2(pHandler);
            aOut.writeU1(this.iClassIndex);
            IOUtilities.writePadding(aOut, 2);
        }
        catch (IOException e) {
            throw new TinyVMException(e.getMessage(), e);
        }
    }

    public boolean equals(Object aOther) {
        if (!(aOther instanceof ExceptionRecord)) {
            return false;
        }
        return ((ExceptionRecord)aOther).iExcep.equals(this.iExcep);
    }

    public int hashCode() {
        return this.iExcep.hashCode();
    }
}

