/*
 * Decompiled with CFR 0.152.
 */
package js.tinyvm;

import org.apache.bcel.classfile.Utility;
import org.apache.bcel.generic.Type;

public class TinyVMType {
    public static final byte T_REFERENCE_TYPE = 0;
    public static final byte T_STACKFRAME_TYPE = 1;
    public static final byte T_BOOLEAN_TYPE = 4;
    public static final byte T_CHAR_TYPE = 5;
    public static final byte T_FLOAT_TYPE = 6;
    public static final byte T_DOUBLE_TYPE = 7;
    public static final byte T_BYTE_TYPE = 8;
    public static final byte T_SHORT_TYPE = 9;
    public static final byte T_INT_TYPE = 10;
    public static final byte T_LONG_TYPE = 11;
    public static final byte T_ARRAY_TYPE = 0;
    public static final byte T_OBJECT_TYPE = 0;
    public static final TinyVMType T_REFERENCE;
    public static final TinyVMType T_BOOLEAN;
    public static final TinyVMType T_CHAR;
    public static final TinyVMType T_FLOAT;
    public static final TinyVMType T_DOUBLE;
    public static final TinyVMType T_BYTE;
    public static final TinyVMType T_SHORT;
    public static final TinyVMType T_INT;
    public static final TinyVMType T_LONG;
    public static final TinyVMType T_ARRAY;
    public static final TinyVMType T_OBJECT;
    private final byte _type;
    private final int _size;
    static final /* synthetic */ boolean $assertionsDisabled;

    private TinyVMType(byte type, int size) {
        this._type = type;
        this._size = size;
    }

    public byte type() {
        return this._type;
    }

    public int size() {
        return this._size;
    }

    public static boolean isValid(byte type) {
        switch (type) {
            case 0: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                return true;
            }
        }
        return false;
    }

    public static TinyVMType tinyVMTypeFromSignature(String signature) {
        return TinyVMType.tinyVMType(Utility.typeOfSignature((String)signature));
    }

    public static TinyVMType tinyVMType(Type type) {
        return TinyVMType.tinyVMType(type.getType());
    }

    public static TinyVMType tinyVMType(byte type) {
        switch (type) {
            case 4: {
                return T_BOOLEAN;
            }
            case 5: {
                return T_CHAR;
            }
            case 6: {
                return T_FLOAT;
            }
            case 7: {
                return T_DOUBLE;
            }
            case 8: {
                return T_BYTE;
            }
            case 9: {
                return T_SHORT;
            }
            case 10: {
                return T_INT;
            }
            case 11: {
                return T_LONG;
            }
            case 13: {
                return T_ARRAY;
            }
            case 14: {
                return T_OBJECT;
            }
        }
        if (!$assertionsDisabled) {
            throw new AssertionError((Object)"Check: Known type");
        }
        return null;
    }

    static {
        $assertionsDisabled = !TinyVMType.class.desiredAssertionStatus();
        T_REFERENCE = new TinyVMType(0, 4);
        T_BOOLEAN = new TinyVMType(4, 1);
        T_CHAR = new TinyVMType(5, 2);
        T_FLOAT = new TinyVMType(6, 4);
        T_DOUBLE = new TinyVMType(7, 8);
        T_BYTE = new TinyVMType(8, 1);
        T_SHORT = new TinyVMType(9, 2);
        T_INT = new TinyVMType(10, 4);
        T_LONG = new TinyVMType(11, 8);
        T_ARRAY = T_REFERENCE;
        T_OBJECT = T_REFERENCE;
    }
}

