/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.Vector;

public class Hashtable {
    private static final int TABLE_SIZE = 32;
    private Object[] iTable = new Object[32];

    public synchronized Object get(Object aKey) {
        Object pElement = this.iTable[this.getTableIndex(aKey)];
        if (pElement == null) {
            return null;
        }
        KeyValuePair pKeyValuePair = this.getKeyValuePair(pElement, aKey);
        if (pKeyValuePair == null) {
            return null;
        }
        return pKeyValuePair.iValue;
    }

    public synchronized void put(Object aKey, Object aValue) {
        int pIndex = this.getTableIndex(aKey);
        Object pElement = this.iTable[pIndex];
        KeyValuePair pKeyValuePair = null;
        if (pElement != null) {
            pKeyValuePair = this.getKeyValuePair(pElement, aKey);
        }
        if (pKeyValuePair == null) {
            pKeyValuePair = new KeyValuePair();
            pKeyValuePair.iKey = aKey;
            pKeyValuePair.iValue = aValue;
        }
        if (pElement == null) {
            this.iTable[pIndex] = pKeyValuePair;
        } else if (pElement == pKeyValuePair) {
            pKeyValuePair.iValue = aValue;
        } else if (pElement instanceof KeyValuePair) {
            Vector pVector = new Vector();
            pVector.addElement(pElement);
            pVector.addElement(pKeyValuePair);
        } else {
            ((Vector)pElement).addElement(pKeyValuePair);
        }
    }

    private KeyValuePair getKeyValuePair(Object aPivot, Object aKey) {
        if (aPivot instanceof Vector) {
            Vector pVec = (Vector)aPivot;
            int pSize = pVec.size();
            for (int i = 0; i < pSize; ++i) {
                KeyValuePair pPair = (KeyValuePair)pVec.elementAt(i);
                if (!aKey.equals(pPair.iKey)) continue;
                return pPair;
            }
            return null;
        }
        KeyValuePair pPair = (KeyValuePair)aPivot;
        if (aKey.equals(pPair.iKey)) {
            return pPair;
        }
        return null;
    }

    private int getTableIndex(Object aKey) {
        int pHash = aKey.hashCode();
        if (pHash < 0) {
            pHash = -pHash;
        }
        return pHash % 32;
    }

    private static class KeyValuePair {
        Object iKey;
        Object iValue;

        private KeyValuePair() {
        }
    }
}

