/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui;

import lejos.nxt.LCD;

public class Graphics {
    private static final byte HEIGHT = 64;
    private static final byte WIDTH = 100;
    private int[] buff = new int[200];
    private int rgbColor = 1;
    public static final int BLACK = 1;
    public static final int WHITE = 0;

    public void setPixel(int rgbColor, int x, int y) {
        if (x < 0 || x >= 100 || y < 0 || y >= 64) {
            return;
        }
        int xChar = x / 4;
        int yChar = y / 8;
        int index = yChar * 25 + xChar;
        int specificBit = y % 8 + x % 4 * 8;
        this.buff[index] = this.buff[index] | rgbColor << specificBit;
    }

    public void drawLine(int x0, int y0, int x1, int y1) {
        int stepx;
        int stepy;
        int dy = y1 - y0;
        int dx = x1 - x0;
        if (dy < 0) {
            dy = -dy;
            stepy = -1;
        } else {
            stepy = 1;
        }
        if (dx < 0) {
            dx = -dx;
            stepx = -1;
        } else {
            stepx = 1;
        }
        this.setPixel(this.rgbColor, x0, y0);
        if ((dx <<= 1) > (dy <<= 1)) {
            int fraction = dy - (dx >> 1);
            while (x0 != x1) {
                if (fraction >= 0) {
                    y0 += stepy;
                    fraction -= dx;
                }
                fraction += dy;
                this.setPixel(this.rgbColor, x0 += stepx, y0);
            }
        } else {
            int fraction = dx - (dy >> 1);
            while (y0 != y1) {
                if (fraction >= 0) {
                    x0 += stepx;
                    fraction -= dy;
                }
                fraction += dx;
                this.setPixel(this.rgbColor, x0, y0 += stepy);
            }
        }
    }

    public void drawArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        int endAngle = startAngle + arcAngle;
        if (endAngle < 0) {
            endAngle += 360;
        }
        if (endAngle > 360) {
            endAngle -= 360;
        }
        if (arcAngle < 0) {
            int temp = startAngle;
            startAngle = endAngle;
            endAngle = temp;
        }
        int xc = x + width / 2;
        int yc = y + height / 2;
        int a = width / 2;
        int b = height / 2;
        int xxx = 0;
        int yyy = b;
        int a2 = a * a;
        int b2 = b * b;
        int crit1 = -(a2 / 4 + a % 2 + b2);
        int crit2 = -(b2 / 4 + b % 2 + a2);
        int crit3 = -(b2 / 4 + b % 2);
        int t = -a2 * yyy;
        int dxt = 2 * b2 * xxx;
        int dyt = -2 * a2 * yyy;
        int d2xt = 2 * b2;
        int d2yt = 2 * a2;
        boolean count = false;
        while (yyy >= 0 && xxx <= a) {
            float angle = (float)Math.toDegrees(Math.atan2(yyy, xxx));
            if (startAngle < endAngle) {
                if (360.0f - angle >= (float)startAngle && 360.0f - angle <= (float)endAngle) {
                    this.setPixel(1, xc + xxx, yc + yyy);
                }
                if ((xxx != 0 || yyy != 0) && 180.0f - angle >= (float)startAngle && 180.0f - angle <= (float)endAngle) {
                    this.setPixel(1, xc - xxx, yc - yyy);
                }
                if (xxx != 0 && yyy != 0) {
                    if (angle >= (float)startAngle && angle <= (float)endAngle) {
                        this.setPixel(1, xc + xxx, yc - yyy);
                    }
                    if (180.0f + angle >= (float)startAngle && 180.0f + angle <= (float)endAngle) {
                        this.setPixel(1, xc - xxx, yc + yyy);
                    }
                }
            } else {
                if (360.0f - angle >= (float)startAngle) {
                    this.setPixel(1, xc + xxx, yc + yyy);
                }
                if ((xxx != 0 || yyy != 0) && 180.0f - angle <= (float)endAngle) {
                    this.setPixel(1, xc - xxx, yc - yyy);
                }
                if (xxx != 0 && yyy != 0) {
                    if (angle <= (float)endAngle) {
                        this.setPixel(1, xc + xxx, yc - yyy);
                    }
                    if (180.0f + angle >= (float)startAngle) {
                        this.setPixel(1, xc - xxx, yc + yyy);
                    }
                }
            }
            if (t + b2 * xxx <= crit1 || t + a2 * yyy <= crit3) {
                ++xxx;
                t += (dxt += d2xt);
                continue;
            }
            if (t - a2 * yyy > crit2) {
                --yyy;
                t += (dyt += d2yt);
                continue;
            }
            ++xxx;
            t += (dxt += d2xt);
            --yyy;
            t += (dyt += d2yt);
        }
    }

    public void drawRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        int xc = x + width / 2;
        int yc = y + height / 2;
        int a = arcWidth / 2;
        int b = arcHeight / 2;
        int translateX = width / 2 - arcWidth / 2;
        int translateY = height / 2 - arcHeight / 2;
        int xDiff = arcWidth / 2;
        int yDiff = arcHeight / 2;
        this.drawLine(x, y + yDiff, x, height - yDiff);
        this.drawLine(width, y + yDiff, width, height - yDiff);
        this.drawLine(x + xDiff, y, width - xDiff, y);
        this.drawLine(x + xDiff, height, width - xDiff, height);
        int xxx = 0;
        int yyy = b;
        int a2 = a * a;
        int b2 = b * b;
        int crit1 = -(a2 / 4 + a % 2 + b2);
        int crit2 = -(b2 / 4 + b % 2 + a2);
        int crit3 = -(b2 / 4 + b % 2);
        int t = -a2 * yyy;
        int dxt = 2 * b2 * xxx;
        int dyt = -2 * a2 * yyy;
        int d2xt = 2 * b2;
        int d2yt = 2 * a2;
        while (yyy >= 0 && xxx <= a) {
            this.setPixel(1, xc + xxx + translateX, yc + yyy + translateY);
            if (xxx != 0 || yyy != 0) {
                this.setPixel(1, xc - xxx - translateX, yc - yyy - translateY);
            }
            if (xxx != 0 && yyy != 0) {
                this.setPixel(1, xc + xxx + translateX, yc - yyy - translateY);
                this.setPixel(1, xc - xxx - translateX, yc + yyy + translateY);
            }
            if (t + b2 * xxx <= crit1 || t + a2 * yyy <= crit3) {
                ++xxx;
                t += (dxt += d2xt);
                continue;
            }
            if (t - a2 * yyy > crit2) {
                --yyy;
                t += (dyt += d2yt);
                continue;
            }
            ++xxx;
            t += (dxt += d2xt);
            --yyy;
            t += (dyt += d2yt);
        }
    }

    public void drawRect(int x, int y, int width, int height) {
        if (width < 0 || height < 0) {
            return;
        }
        if (height == 0 || width == 0) {
            this.drawLine(x, y, x + width, y + height);
        } else {
            this.drawLine(x, y, x + width - 1, y);
            this.drawLine(x + width, y, x + width, y + height - 1);
            this.drawLine(x + width, y + height, x + 1, y + height);
            this.drawLine(x, y + height, x, y + 1);
        }
    }

    public void fillRect(int x, int y, int width, int height) {
        if (width < 0 || height < 0) {
            return;
        }
        for (int i = y; i < y + height; ++i) {
            this.drawLine(x, i, x + width, i);
        }
    }

    public void drawString(String str, int x, int y) {
        LCD.drawString(str, x, y);
    }

    public void refresh() {
        LCD.setDisplay(this.buff);
        LCD.refresh();
    }

    public void clear() {
        for (int i = 0; i < this.buff.length; ++i) {
            this.buff[i] = 0;
        }
        this.refresh();
    }
}

