/*
 * Decompiled with CFR 0.152.
 */
package lejos.nxt;

import lejos.nxt.BasicMotorPort;

abstract class BasicMotor {
    int _mode = 4;
    int _power = 50;
    BasicMotorPort _port;

    BasicMotor() {
    }

    public void setPower(int power) {
        this._power = power;
        this._port.controlMotor(this._power, this._mode);
    }

    public int getPower() {
        return this._power;
    }

    public void forward() {
        this._mode = 1;
        this.updateState();
    }

    public boolean isForward() {
        return this._mode == 1;
    }

    public void backward() {
        this._mode = 2;
        this.updateState();
    }

    public boolean isBackward() {
        return this._mode == 2;
    }

    public void reverseDirection() {
        if (this._mode == 1 || this._mode == 2) {
            this._mode = 3 - this._mode;
            this.updateState();
        }
    }

    public boolean isMoving() {
        return this._mode == 1 || this._mode == 2;
    }

    public void flt() {
        this._mode = 4;
        this.updateState();
    }

    public boolean isFloating() {
        return this._mode == 4;
    }

    public void stop() {
        this._mode = 3;
        this.updateState();
    }

    public boolean isStopped() {
        return this._mode == 3;
    }

    void updateState() {
        this._port.controlMotor(this._power, this._mode);
    }

    public int getMode() {
        return this._mode;
    }
}

