/*
 * Decompiled with CFR 0.152.
 */
package lejos.nxt;

import lejos.nxt.ADSensorPort;
import lejos.nxt.SensorConstants;

public class LightSensor
implements SensorConstants {
    ADSensorPort port;
    private int _zero = 1023;
    private int _hundred = 0;

    public LightSensor(ADSensorPort port) {
        this.port = port;
        port.setTypeAndMode(5, 128);
    }

    public LightSensor(ADSensorPort port, boolean floodlight) {
        this.port = port;
        port.setTypeAndMode(floodlight ? 5 : 6, 128);
    }

    public void setFloodlight(boolean floodlight) {
        this.port.setType(floodlight ? 5 : 6);
    }

    public int readValue() {
        if (this._hundred == this._zero) {
            return 1023;
        }
        return 100 * (this.port.readRawValue() - this._zero) / (this._hundred - this._zero);
    }

    public int readNormalizedValue() {
        return 1023 - this.port.readRawValue();
    }

    public void calibrateLow() {
        this._zero = this.port.readRawValue();
    }

    public void calibrateHigh() {
        this._hundred = this.port.readRawValue();
    }
}

