/*
 * Decompiled with CFR 0.152.
 */
package lejos.nxt;

import lejos.nxt.Button;
import lejos.nxt.LCD;

public class TextMenu {
    private int _topIndex = 0;
    private int _selectedIndex = 0;
    private int _size = 8;
    private int _topRow = 0;
    private String[] _items;
    private String _selChar = ">";
    public static String blank = "                ";
    private String _title;

    public TextMenu(String[] items) {
        this._items = items;
    }

    public TextMenu(String[] items, int size, int topRow) {
        this(items);
        this._topRow = topRow;
        this._size = size;
    }

    public TextMenu(String[] items, int size, String title) {
        this(items, size, 1);
        this._title = title;
    }

    public int select() {
        if (this._items.length < this._size) {
            this._size = this._items.length;
        }
        int button = 0;
        this.display();
        while (true) {
            if (Button.readButtons() > 0) {
                Thread.yield();
                continue;
            }
            while (Button.readButtons() == 0) {
                Thread.yield();
            }
            try {
                Thread.sleep(20L);
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
            button = Button.readButtons();
            if (button == 1) {
                return this._selectedIndex;
            }
            if (button == 8) {
                return -1;
            }
            if (button == 4) {
                int diff;
                ++this._selectedIndex;
                if (this._selectedIndex >= this._items.length) {
                    this._selectedIndex -= this._items.length;
                }
                if ((diff = this._selectedIndex - this._topIndex) < 0 || diff >= this._size) {
                    this._topIndex = this._selectedIndex + 1 - this._size;
                }
            }
            if (button == 2) {
                int diff;
                --this._selectedIndex;
                if (this._selectedIndex < 0) {
                    this._selectedIndex += this._items.length;
                }
                if ((diff = this._selectedIndex - this._topIndex) < 0 || diff >= this._size) {
                    this._topIndex = this._selectedIndex;
                }
            }
            this.display();
        }
    }

    private void display() {
        if (this._title != null) {
            LCD.drawString(this._title, 0, 0);
        }
        for (int i = 0; i < this._size; ++i) {
            LCD.drawString(blank, 0, i + this._topRow);
            int indx = this.index(i);
            if (this._items[indx] == null) continue;
            LCD.drawString(this._items[indx], 1, i + this._topRow);
        }
        LCD.drawString(this._selChar, 0, this._selectedIndex - this._topIndex + this._topRow);
        LCD.refresh();
    }

    private int index(int row) {
        return (this._topIndex + row + this._items.length) % this._items.length;
    }
}

