/*
 * Decompiled with CFR 0.152.
 */
package lejos.nxt.comm;

import lejos.nxt.comm.BTConnection;

public class Bluetooth {
    public static final int MSG_BEGIN_INQUIRY = 0;
    public static final int MSG_CANCEL_INQUIRY = 1;
    public static final int MSG_CONNECT = 2;
    public static final int MSG_OPEN_PORT = 3;
    public static final int MSG_LOOKUP_NAME = 4;
    public static final int MSG_ADD_DEVICE = 5;
    public static final int MSG_REMOVE_DEVICE = 6;
    public static final int MSG_DUMP_LIST = 7;
    public static final int MSG_CLOSE_CONNECTION = 8;
    public static final int MSG_ACCEPT_CONNECTION = 9;
    public static final int MSG_PIN_CODE = 10;
    public static final int MSG_OPEN_STREAM = 11;
    public static final int MSG_START_HEART = 12;
    public static final int MSG_HEARTBEAT = 13;
    public static final int MSG_INQUIRY_RUNNING = 14;
    public static final int MSG_INQUIRY_RESULT = 15;
    public static final int MSG_INQUIRY_STOPPED = 16;
    public static final int MSG_LOOKUP_NAME_RESULT = 17;
    public static final int MSG_LOOKUP_NAME_FAILURE = 18;
    public static final int MSG_CONNECT_RESULT = 19;
    public static final int MSG_RESET_INDICATION = 20;
    public static final int MSG_REQUEST_PIN_CODE = 21;
    public static final int MSG_REQUEST_CONNECTION = 22;
    public static final int MSG_LIST_RESULT = 23;
    public static final int MSG_LIST_ITEM = 24;
    public static final int MSG_LIST_DUMP_STOPPED = 25;
    public static final int MSG_CLOSE_CONNECTION_RESULT = 26;
    public static final int MSG_PORT_OPEN_RESULT = 27;
    public static final int MSG_SET_DISCOVERABLE = 28;
    public static final int MSG_CLOSE_PORT = 29;
    public static final int MSG_CLOSE_PORT_RESULT = 30;
    public static final int MSG_PIN_CODE_ACK = 31;
    public static final int MSG_DISCOVERABLE_ACK = 32;
    public static final int MSG_SET_FRIENDLY_NAME = 33;
    public static final int MSG_SET_FRIENDLY_NAME_ACK = 34;
    public static final int MSG_GET_LINK_QUALITY = 35;
    public static final int MSG_LINK_QUALITY_RESULT = 36;
    public static final int MSG_SET_FACTORY_SETTINGS = 37;
    public static final int MSG_SET_FACTORY_SETTINGS_ACK = 38;
    public static final int MSG_GET_LOCAL_ADDR = 39;
    public static final int MSG_GET_LOCAL_ADDR_RESULT = 40;
    public static final int MSG_GET_FRIENDLY_NAME = 41;
    public static final int MSG_GET_DISCOVERABLE = 42;
    public static final int MSG_GET_PORT_OPEN = 43;
    public static final int MSG_GET_FRIENDLY_NAME_RESULT = 44;
    public static final int MSG_GET_DISCOVERABLE_RESULT = 45;
    public static final int MSG_GET_PORT_OPEN_RESULT = 46;
    public static final int MSG_GET_VERSION = 47;
    public static final int MSG_GET_VERSION_RESULT = 48;
    public static final int MSG_GET_BRICK_STATUSBYTE_RESULT = 49;
    public static final int MSG_SET_BRICK_STATUSBYTE_RESULT = 50;
    public static final int MSG_GET_BRICK_STATUSBYTE = 51;
    public static final int MSG_SET_BRICK_STATUSBYTE = 52;
    static byte[] sendBuf = new byte[256];
    static byte[] receiveBuf = new byte[128];

    private Bluetooth() {
    }

    public static native void btSend(byte[] var0, int var1);

    public static native void btReceive(byte[] var0);

    public static native void btSetCmdMode(int var0);

    public static native int btGetCmdMode();

    public static native void btStartADConverter();

    public static void sendCommand(byte[] cmd, int len) {
        int checkSum = 0;
        Bluetooth.sendBuf[0] = (byte)(len + 2);
        for (int i = 0; i < len; ++i) {
            Bluetooth.sendBuf[i + 1] = cmd[i];
            checkSum += cmd[i];
        }
        checkSum = -checkSum;
        Bluetooth.sendBuf[len + 2] = (byte)(checkSum >> 8 & 0xFF);
        Bluetooth.sendBuf[len + 3] = (byte)(checkSum & 0xFF);
        Bluetooth.btSend(sendBuf, len + 3);
    }

    public static int receiveReply(byte[] buf, int bufLen) {
        Bluetooth.btReceive(receiveBuf);
        int len = receiveBuf[0];
        buf[0] = (byte)len;
        if (len == 0) {
            return 0;
        }
        int checkSum = len;
        if (len - 1 <= bufLen) {
            for (int i = 1; i < len - 1; ++i) {
                buf[i] = receiveBuf[i];
                checkSum += buf[i] & 0xFF;
            }
            int negSum = (receiveBuf[len - 1] & 0xFF) << 8;
            if (checkSum + (negSum += receiveBuf[len] & 0xFF) == 65536) {
                return len - 1;
            }
            return 0;
        }
        return 0;
    }

    public static int readPacket(byte[] buf, int bufLen) {
        Bluetooth.btReceive(receiveBuf);
        int len = receiveBuf[0];
        if (len > 0 && len <= bufLen) {
            for (int i = 0; i < len; ++i) {
                buf[i] = receiveBuf[i + 2];
            }
            return len;
        }
        return 0;
    }

    public static void sendPacket(byte[] buf, int bufLen) {
        if (bufLen <= 254) {
            Bluetooth.sendBuf[0] = (byte)(bufLen & 0xFF);
            Bluetooth.sendBuf[1] = (byte)(bufLen >> 8 & 0xFF);
            for (int i = 0; i < bufLen; ++i) {
                Bluetooth.sendBuf[i + 2] = buf[i];
            }
            Bluetooth.btSend(sendBuf, bufLen + 2);
        }
    }

    public static BTConnection waitForConnection() {
        byte[] reply = new byte[32];
        byte[] dummy = new byte[32];
        byte[] msg = new byte[32];
        byte[] device = new byte[7];
        boolean cmdMode = true;
        BTConnection btc = null;
        Bluetooth.btSetCmdMode(1);
        Bluetooth.btStartADConverter();
        while (cmdMode) {
            int i;
            Bluetooth.receiveReply(reply, 32);
            if (reply[0] == 0) continue;
            if (reply[1] == 21) {
                for (i = 0; i < 7; ++i) {
                    device[i] = reply[i + 2];
                }
                msg[0] = 10;
                for (i = 0; i < 7; ++i) {
                    msg[i + 1] = device[i];
                }
                msg[8] = 49;
                msg[9] = 50;
                msg[10] = 51;
                msg[11] = 52;
                for (i = 0; i < 12; ++i) {
                    msg[i + 12] = 0;
                }
                Bluetooth.sendCommand(msg, 24);
            }
            if (reply[1] == 22) {
                for (i = 0; i < 7; ++i) {
                    device[i] = reply[i + 2];
                }
                msg[0] = 9;
                msg[1] = 1;
                Bluetooth.sendCommand(msg, 2);
            }
            if (reply[1] != 19) continue;
            try {
                Thread.sleep(300L);
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
            Bluetooth.receiveReply(dummy, 32);
            if (dummy[0] != 0) continue;
            btc = new BTConnection(reply[3]);
            msg[0] = 11;
            msg[1] = reply[3];
            Bluetooth.sendCommand(msg, 2);
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
            Bluetooth.btSetCmdMode(0);
            cmdMode = false;
        }
        return btc;
    }
}

