/**
 * Flash routine. Hardcodes the ARM7 bytecode for writing data to
 * flash memory in the downloader binary.
 *
 * Copyright 2006 David Anderson <david.anderson@calixo.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef __FLASH_ROUTINE_H__
#define __FLASH_ROUTINE_H__

/*
 * An array containing all the bits of the flash routine bytecode.
 */
static char flash_bin[] = { 
0x21, 0xd8, 0xa0, 0xe3, 0x00, 0x40, 0x2d, 0xe9, 0x00, 0x00, 0x00, 0xeb, 
0x00, 0x80, 0xbd, 0xe8, 0x00, 0x20, 0xe0, 0xe3, 0x97, 0x30, 0x12, 0xe5, 
0x01, 0x00, 0x13, 0xe3, 0xfc, 0xff, 0xff, 0x0a, 0x02, 0xc6, 0xa0, 0xe3, 
0x0c, 0x00, 0xa0, 0xe1, 0x21, 0x0c, 0x80, 0xe2, 0x02, 0xca, 0x8c, 0xe2, 
0x00, 0x10, 0xa0, 0xe3, 0x00, 0x33, 0x9c, 0xe5, 0x03, 0x33, 0x81, 0xe0, 
0x01, 0x21, 0x90, 0xe7, 0x03, 0x31, 0xa0, 0xe1, 0x01, 0x10, 0x81, 0xe2, 
0x01, 0x36, 0x83, 0xe2, 0x40, 0x00, 0x51, 0xe3, 0x00, 0x20, 0x83, 0xe5, 
0xf6, 0xff, 0xff, 0x1a, 0x00, 0x33, 0x9c, 0xe5, 0x03, 0x3b, 0xa0, 0xe1, 
0x23, 0x3b, 0xa0, 0xe1, 0x03, 0x34, 0xa0, 0xe1, 0x5a, 0x34, 0x83, 0xe2, 
0x01, 0x30, 0x83, 0xe2, 0x00, 0x20, 0xe0, 0xe3, 0x9b, 0x30, 0x02, 0xe5, 
0x97, 0x30, 0x12, 0xe5, 0x01, 0x00, 0x13, 0xe3, 0xfc, 0xff, 0xff, 0x0a, 
0x00, 0x00, 0xa0, 0xe3, 0x1e, 0xff, 0x2f, 0xe1 };

/*
 * The number of bytes in the above array.
 */
static unsigned long flash_len = 0x8C;

#endif /* __FLASH_ROUTINE_H__ */
