/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: cpu_config.c,v 1.14 2004/09/17 09:58:17 honda Exp $
 */

/*
 *	ץå¸⥸塼ARM4vTѡ
 */

#include "jsp_kernel.h"
#include "check.h"
#include <armv4.h>
#include "task.h"

#ifndef VECTOR_IN_ROM
/*
 * 㳰٥˽񤭹ޤ줿̿᤬Ȥ륢ɥ쥹
 * 
 */
UW *arm_vector_add[8];


/*
 * 㳰˱ϥɥεư
 */
UW arm_handler_add[8];

#endif /* VECTOR_IN_ROM */

/*
 * ߤΥͥȲΥ
 */
UW interrupt_count;


/*
 * CPU/ߥϥɥνǰŪ˻Ѥ륹å
 */
UW int_stack[INT_STACK_SIZE];

/*
 *  CPU㳰ϥɥ
 */
void
define_exc(EXCNO excno, FP exchdr)
{
#ifndef VECTOR_IN_ROM
    arm_install_handler(excno,exchdr);
#endif /* VECTOR_IN_ROM */
}


/*
 *  ̤㳰äν
 */
void
undef_exception(){
  syslog(LOG_EMERG, "Unregistered Exception occurs. UNDEF");
    while(1);
}

void
swi_exception(){
  syslog(LOG_EMERG, "Unregistered Exception occurs. SWI");
  while(1);
}

void
prefetch_exception(){
  syslog(LOG_EMERG, "Unregistered Exception occurs. PREFETCH");
  while(1);
}

void
data_abort_exception(){
  syslog(LOG_EMERG, "Unregistered Exception occurs. DATA ABORT");
  while(1);
}


void
irq_exception(){
  syslog(LOG_EMERG, "Unregistered Exception occurs. IRQ");
  while(1);
}

void
fiq_exception(){
  syslog(LOG_EMERG, "Unregistered Exception occurs. FIQ");
  while(1);
}



/*
 *  ץå¸ν
 */
void
cpu_initialize()
{
#ifndef VECTOR_IN_ROM
    UW i,vector_value;

    /*
     * 㳰٥ϿƤ̿ᤫ黲Ȥ륢ɥ쥹ȡ
     *Υɥ쥹(ϥɥμ¹)¸롥
     */
    for(i = 0; i <=7; i++){
        vector_value = *(volatile UW *)(i*4);
        vector_value &= 0x00000fff;
        arm_vector_add[i] =  (UW *)(vector_value + 8) + i;
        arm_handler_add[i] = *(arm_vector_add[i]);
    }
#endif /* VECTOR_IN_ROM */

	interrupt_count = 1;

}


/*
 *  ץå¸νλ
 */
void
cpu_terminate()
{
#ifndef VECTOR_IN_ROM
    UW i;
    /*  ٥ơ֥򸵤᤹*/
    for(i = 0; i <=7; i++)
        *arm_vector_add[i] = arm_handler_add[i];
#endif /* VECTOR_IN_ROM */
}
