/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2004 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2007-     by Monami Software Limited Partnership, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: cpu_config.h,v 1.19 2004/09/17 13:45:55 honda Exp $
 */

/*
 *  ץå¸⥸塼ARM4vTѡ
 *
 *  Υ󥯥롼ɥեϡt_config.h Τߤ饤󥯥롼ɤ롥
 *  ¾Υե뤫ľܥ󥯥롼ɤƤϤʤʤ
 */

#ifndef _CPU_CONFIG_H_
#define _CPU_CONFIG_H_

/*
 *  ͥ̾Υ͡
 */
#include "cpu_rename.h"

/*
 *  ץåü̿Υ饤ؿ
 */
#ifndef _MACRO_ONLY
#include <cpu_insn.h>
#endif /* _MACRO_ONLY */

/*
 * ƥ
 */
#include "sys_defs.h"

/*
 *  TCB Ϣ
 *
 *  cpu_context.h 쥬ȤȤΰ¸δطǡ
 *  cpu_context.h ˤʤ
 */

/*
 *  TCB ΥեɤΥӥå
 */
#define    TBIT_TCB_TSTAT       8    /* tstat եɤΥӥå */
#define    TBIT_TCB_PRIORITY    8    /* priority եɤΥӥå */

#ifndef _MACRO_ONLY
/*
 *  ƥȥ֥å
 */
typedef struct task_context_block {
    VP    sp;        /* åݥ */
    FP    pc;        /* ץ५ */
} CTXB;

/*
 * ߤΥͥȲΥ
 */
extern UW interrupt_count;


/*
 *  ƥֻ
 */
Inline UB
current_mode()
{
    return(current_sr() & CPSR_MODE_MASK);
}

Inline BOOL
sense_context()
{
    return(interrupt_count > 0);
}

Inline BOOL
sense_lock()
{
    return(current_sr() & CPSR_IRQ_BIT);
}

#define t_sense_lock    sense_lock
#define i_sense_lock    sense_lock


/*
 *  CPUåȤβ
 *
 */

#define t_lock_cpu      lock_cpu
#define i_lock_cpu      lock_cpu
#define t_unlock_cpu    unlock_cpu
#define i_unlock_cpu    unlock_cpu


Inline void
lock_cpu()
{
    disint();
}

Inline void
unlock_cpu()
{
    enaint();
}


/*
 *  ǥѥå
 */

/*
 *  ǹ̥ͥؤΥǥѥåcpu_support.S
 *
 *  dispatch ϡƥȤƤӽФ줿ӥ
 *  ǡCPUå֤ǸƤӽФʤФʤʤ
 */
extern void    dispatch(void);


/*
 *  ߤΥƥȤΤƤƥǥѥåcpu_support.S
 *
 *  exit_and_dispatch ϡCPUå֤ǸƤӽФʤФʤʤ
 */
extern void    exit_and_dispatch(void);

#ifndef VECTOR_IN_ROM
/*
 * 㳰٥˽񤭹ޤ줿̿᤬Ȥ륢ɥ쥹
 */
extern UW * arm_vector_add[8];


/*
 * 㳰˱ϥɥεư
 */
extern UW arm_handler_add[8];
#endif /* VECTOR_IN_ROM */

/*
 *  CPU㳰ϥɥ
 */
extern void define_exc(EXCNO excno, FP exchdr);


#ifndef VECTOR_IN_ROM
Inline void
arm_install_handler(EXCNO excno, FP exchdr)
{
    *arm_vector_add[excno] = (UW)exchdr;
}
#endif /* VECTOR_IN_ROM */

/*
 *  CPU㳰ϥɥν
 */


/*
 *  CPU㳰ϥɥνޥ
 *
 */
#define __EXCHDR_ENTRY(exchdr, stacktop)    \
extern void exchdr##_entry(VP sp);          \
asm(".text                             \n"  \
#exchdr "_entry:                       \n"  \
"       ldr   sp,.int_stack_"#exchdr"  \n"  /* åڤؤ        */\
"       sub   lr,lr,#4                 \n"  /* undefǤ⤳Ǥ?    */\
"       stmfd sp!, {r0 - r2,lr}        \n"  /* Ūint_stack   */ \
"       mrs   r1, spsr                 \n"  /* SVC⡼ɤڤؤ뤿 */ \
"       mov   r0, sp                   \n"  /* ¸                  */ \
"       mov   r2,#0xd3                 \n"  /* CPSRν񤭴(SVC⡼ɤ)*/ \
"       msr   cpsr,r2                  \n" \
"       ldr   r2,[r0,#0x0C]            \n"     /* load  PC            */\
"       stmfd sp!,{r2}                 \n"     /* Store PC            */\
"       stmfd sp!,{r3,ip,lr}           \n"     /* Store r3,ip,lr      */\
"       ldmfd r0!,{r2,ip,lr}           \n"     /* load  r0,r1,r2      */\
"       stmfd sp!,{r1,r2,ip,lr}        \n"     /* SPSR,Store r0,r1,r2 */\
"       ldr   r2, .interrupt_count_"#exchdr"\n" /* ¿ųߤȽ  */\
"       ldr   r3, [r2]                 \n" \
"       add   r0,r3,#1                 \n" \
"       str   r0, [r2]                 \n" \
"       mov   r0,sp                    \n" /* 㳰ϥɥؤΰ */\
"       cmp   r3, #0x00                \n" \
"       ldreq   sp,stack_"#exchdr"     \n" /* åѹ       */\
"       stmeqfd sp!,{r0}               \n" /* å¸ */\
"       and   r2, r1, #0xc0            \n" /* 㳰ȯCPUå(IRQ) */\
"       orr   r2, r2, #0x13            \n" /* FIQѾ. SVC⡼ */\
"       msr   cpsr,r2                  \n" \
"       bl    "#exchdr"                \n" /* ϥɥƤӽФ     */\
"       mrs   r2, cpsr                 \n" /* FIQѾ            */\
"       and   r2, r2, #0x40            \n" /*                      */\
"       orr   r2, r2, #0x93            \n" /* ߶ػ         */\
"       msr   cpsr,r2                  \n" \
"       ldr   r2,.interrupt_count_"#exchdr" \n"/* ߲   */\
"       ldr   r1, [r2]                 \n"     /* ǥ     */\
"       sub   r3,r1,#1                 \n"\
"       str   r3, [r2]                 \n"\
"       cmp   r3,#0x00                 \n" /* ߥͥȿ?    */\
"       bne   return_to_task_"#exchdr" \n" \
"       ldmfd sp!,{r0}                 \n" /* å */\
"       mov   sp, r0                   \n"\
"       ldr   r1, reqflg_"#exchdr"     \n" /* Check reqflg         */\
"       ldr   r0,[r1]                  \n"\
"       cmp   r0,#0                    \n"\
"       beq   return_to_task_"#exchdr" \n"\
"       mov   r0,#0                    \n"\
"       str   r0,[r1]                  \n" /* Clear reqflg   */\
"       b     _kernel_ret_exc          \n" /* ret_int      */\
"return_to_task_"#exchdr":             \n" \
"       ldmfd sp!,{r1}                 \n" /* CPSR r1 <- cpsr*/\
"       mrs   r2, cpsr                 \n" /* FIQѾ            */\
"       and   r2, r2, #0x40            \n" /*                      */\
"       and   r1, r1, #~0x40           \n" /*                      */\
"       orr   r1, r1, r2               \n" /*                      */\
"       msr   spsr, r1                 \n" /* ߵ   */\
"       ldmfd sp!,{r0-r3,ip,lr,pc}^    \n"\
"       .align 4                       \n"\
".int_stack_"#exchdr":                 \n"\
"       .long _kernel_int_stack + 6 * 4 \n"\
"reqflg_"#exchdr":                     \n"\
"       .long     _kernel_reqflg       \n"\
"stack_"#exchdr":                      \n"\
"       .long   " #stacktop "          \n"\
".interrupt_count_"#exchdr":            \n"\
"       .long   _kernel_interrupt_count \n")


#define _EXCHDR_ENTRY(exchdr, stacktop)    __EXCHDR_ENTRY(exchdr, stacktop)

#define EXCHDR_ENTRY(exchdr)    _EXCHDR_ENTRY(exchdr, STACKTOP)

#define EXC_ENTRY(exchdr) exchdr##_entry


/*
 *  CPU㳰ȯΥƥ֤λ
 */

/*
 *  CPU㳰ȯΥǥѥå
 */
Inline BOOL
exc_sense_context(VP p_excinf)
{
    return(interrupt_count > 1);    
}


/*
 *  CPU㳰ȯCPUå֤λ
 */
Inline BOOL
exc_sense_lock(VP p_excinf)
{
    return((*((UW *)p_excinf) & CPSR_IRQ_BIT) == CPSR_IRQ_BIT );
}


/*
 * ̤㳰ä
 */
extern void undef_exception();
extern void swi_exception();
extern void prefetch_exception();
extern void data_abort_exception();
extern void irq_abort_exception();
extern void fiq_abort_exception();


/*
 *  ץå¸ν
 */
extern void    cpu_initialize(void);


/*
 *  ץå¸νλ
 */
extern void    cpu_terminate(void);


/*
 * CPU/ߥϥɥνǰŪ˻Ѥ륹å
 */
#define INT_STACK_SIZE 6
extern UW int_stack[INT_STACK_SIZE];


#endif /* _MACRO_ONLY */
#if 0
#else /* patch */
#define COPYRIGHT_CPU \
"Copyright (C) 2007-     by Monami Software Limited Partnership, JAPAN\n"
#endif
#endif /* _CPU_CONFIG_H_ */
