/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2003      by Advanced Data Controls, Corp
 *  Copyright (C) 2004 by Embedded and Real-Time Systems Laboratory
 *              Graduate School of Information Science, Nagoya Univ., JAPAN  
 *  Copyright (C) 2006-2007 by GJ Business Division RICOH COMPANY,LTD. JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: at91sam7s.c,v 1.4 2007/02/25 11:32:22 roi Exp $
 *  
 */

/*
 * At91sam7s ǽѥɥ饤
 */
#include <s_services.h>
#include <at91sam7s.h>

#define BAUDRATE   115200

/*
 * ꥢI/OݡȽ֥å
 */
const SIOPINIB siopinib_table[TNUM_SIOP] = {
    {(VP)(TADR_DBGU_BASE),         (VP)(TADR_PIO_BASE+TOFF_PIO_PDR),
     (VP)0,
     (VW)((1<<9)|(1<<10)),         0
    }
#if TNUM_SIOP >= 2
    ,
    {(VP)(TADR_US_BASE+US_WINDOW), (VP)(TADR_PIO_BASE+TOFF_PIO_PDR),
     (VP)(TADR_PMC_BASE+TOFF_PMC_PCER),
     (VW)((1<<21)|(1<<22)),        1<<IRQ_US1_PID
    }

#endif /* TNUM_SIOP >= 2 */
};


/*
 *  ꥢI/Oݡȴ֥åΥꥢ
 */
SIOPCB  siopcb_table[TNUM_SIOP];


/*
 *  ꥢI/OݡID֥åФΥޥ
 */
#define INDEX_SIOP(siopid)  ((UINT)((siopid) - 1))
#define get_siopcb(siopid)  (&(siopcb_table[INDEX_SIOP(siopid)]))


/*
 * ʸ?
 */ 
Inline BOOL
uart_getready(SIOPCB *siopcb)
{
    return(((sil_rew_mem((VP)(siopcb->siopinib->uart_base+TOFF_US_CSR)) & US_RXRDY)!=0));
}

/*
 * ʸǤ뤫?
 */
Inline BOOL
uart_putready(SIOPCB *siopcb)
{
    return((sil_rew_mem((VP)(siopcb->siopinib->uart_base+TOFF_US_CSR)) & US_TXEMPTY)!=0);
}

/*
 *  ʸμФ
 */
Inline UB
uart_getchar(SIOPCB *siopcb)
{
    return(sil_rew_mem((VP)(siopcb->siopinib->uart_base+TOFF_US_RHR)));
}

/*
 *  ʸν񤭹
 */
Inline void
uart_putchar(SIOPCB *siopcb, UB c)
{
    sil_wrw_mem((VP)(siopcb->siopinib->uart_base+TOFF_US_THR),c);
}

/*
 *  ߵ
 */
Inline void
uart_enable_send(SIOPCB *siopcb)
{
    sil_wrw_mem((VP)(siopcb->siopinib->uart_base+TOFF_US_IER), 1<<1);
}

/*
 *  ߶ػ
 */
Inline void
uart_disable_send(SIOPCB *siopcb)
{
    sil_wrw_mem((VP)(siopcb->siopinib->uart_base+TOFF_US_IDR), 1<<1);
}


/*
 *  ߵ
 */
Inline void
uart_enable_rcv(SIOPCB *siopcb)
{
    sil_wrw_mem((VP)(siopcb->siopinib->uart_base+TOFF_US_IER), 1<<0);
}

/*
 *  ߶ػ
 */
Inline void
uart_disable_rcv(SIOPCB *siopcb)
{
    sil_wrw_mem((VP)(siopcb->siopinib->uart_base+TOFF_US_IDR), 1<<0);
}

/*
 *  SIOɥ饤Фν롼
 *  1ݡȤʤᡤޤ̣Ϥʤ
 */
void
uart_initialize()
{
    SIOPCB  *siopcb;
    UINT    i;

    /*
     *  ꥢI/Oݡȴ֥åν
     */
    for (siopcb = siopcb_table, i = 0; i < TNUM_SIOP; siopcb++, i++) {
        siopcb->siopinib = &(siopinib_table[i]);
        siopcb->openflag = FALSE;
        siopcb->sendflag = FALSE;
    }
}

/*
 * ץ󤷤ƤݡȤ뤫
 */
BOOL
uart_openflag(void)
{
    return(siopcb_table[0].openflag);
}

/*
 * ꥢI/OݡȤΥץ
 */
SIOPCB *
uart_opn_por(ID siopid, VP_INT exinf)
{
    unsigned int baud = ((MCK * 10) / (BAUDRATE * 16));

    SIOPCB      *siopcb;
    const SIOPINIB  *siopinib;

    siopcb = get_siopcb(siopid);
    siopinib = siopcb->siopinib;

    /*
     * Wait 롥
     */
    sil_dly_nse(5000);

    if(siopinib->pmc_pcer)
        sil_wrw_mem((VP)siopinib->pmc_pcer, siopinib->irq_bit);
    /* Disable Interrupt */
    sil_wrw_mem((VP)(siopinib->uart_base+TOFF_US_IDR), 0xFFFFFFFF);
    sil_wrw_mem((VP)(siopinib->uart_base+TOFF_US_CR), (US_RSTRX|US_RSTTX|US_RXDIS|US_TXDIS));
    sil_wrw_mem((VP)(siopinib->uart_base+TOFF_PDC_RCR), 0);
    sil_wrw_mem((VP)(siopinib->uart_base+TOFF_PDC_TCR), 0);
    sil_wrw_mem((VP)siopinib->linectrl_pdr, siopinib->pdr_bit);
    /* 8Data, 1Stop, No Parity */
    sil_wrw_mem((VP)(siopinib->uart_base+TOFF_US_MR), (US_CLKS_MCK|US_CHRL_8|US_PAR_NO|US_NBSTOP_1|US_CHMODE_NORMAL));
    /* 115200bps */
    if((baud % 10) >= 5)
        sil_wrw_mem((VP)(siopinib->uart_base+TOFF_US_BRGR), (baud/10)+1);
    else
        sil_wrw_mem((VP)(siopinib->uart_base+TOFF_US_BRGR), (baud/10));

    /*
     * ߴϢ
     */
    if(siopinib->pmc_pcer){
        sil_wrw_mem((VP)(siopinib->uart_base+TOFF_US_TTGR), 0);
        sil_wrw_mem((VP)(siopinib->uart_base+TOFF_US_CR), US_TXEN|US_RXEN);
        sil_wrw_mem((VP)(siopinib->uart_base+TOFF_US_IER), 1<<0);
    }
	else{
        /* å֥͡ */
        sil_wrw_mem((VP)(TADR_PMC_BASE+TOFF_PMC_PCER), (1<<IRQ_TC2_PID));
        /*  */
        sil_wrw_mem((VP)(TADR_TC_BASE+TC_WINDOW*2+TOFF_TC_CCR), TC_CLKDIS);
        sil_wrw_mem((VP)(TADR_TC_BASE+TC_WINDOW*2+TOFF_TC_IDR), 0xFFFFFFFF);
        /* ͤ򥻥å */
        sil_wrw_mem((VP)(TADR_TC_BASE+TC_WINDOW*2+TOFF_TC_CMR), TC_CLKS_MCK8);	/* 47,923,200Hz/8=5,990,400Hz */
        sil_wrw_mem((VP)(TADR_TC_BASE+TC_WINDOW*2+TOFF_TC_CMR), sil_rew_mem((VP)(TADR_TC_BASE+TC_WINDOW*2+TOFF_TC_CMR)) | TC_WAVESEL10);
        sil_wrw_mem((VP)(TADR_TC_BASE+TC_WINDOW*2+TOFF_TC_RC), 59900);			/* 10ms */
        /* ߤΥꥢ  */
        sil_wrw_mem((VP)(TADR_TC_BASE+TC_WINDOW*2+TOFF_TC_IER), TC_CPCS);
        /* ȥ   */
        sil_wrw_mem((VP)(TADR_TC_BASE+TC_WINDOW*2+TOFF_TC_CCR), (TC_CLKEN|TC_SWTRG));

        sil_wrw_mem((VP)(siopinib->uart_base+TOFF_US_CR), US_TXEN|US_RXEN);
    }
    sil_rew_mem((VP)(siopinib->uart_base+TOFF_US_RHR));

    siopcb->exinf = exinf;
    siopcb->getready = siopcb->putready = FALSE;
    siopcb->openflag = TRUE;

    return(siopcb);
}



/*
 *  ꥢI/OݡȤΥ
 */
void
uart_cls_por(SIOPCB *siopcb)
{
	sil_wrw_mem((VP)(TADR_DBGU_BASE+TOFF_US_CR), US_RSTRX|US_RSTTX|US_RXDIS|US_TXDIS);
    siopcb->openflag = FALSE;
}

/*
 *  ꥢI/OݡȤؤʸ
 */
BOOL
uart_snd_chr(SIOPCB *siopcb, char c)
{
    if(siopcb->siopinib->pmc_pcer == 0){
        while(!uart_putready(siopcb));
        uart_putchar(siopcb, c);
        return(TRUE);
    }
    else if (uart_putready(siopcb)){
        uart_putchar(siopcb, c);
        return(TRUE);
    }
    return(FALSE);
}

/*
 *  ꥢI/OݡȤʸ
 */
INT
uart_rcv_chr(SIOPCB *siopcb)
{
    if (uart_getready(siopcb)) {
        return((INT)(UB) uart_getchar(siopcb));
    }
    return(-1);
}

/*
 *  ꥢI/OݡȤΥХåε
 */
void
uart_ena_cbr(SIOPCB *siopcb, UINT cbrtn)
{
    switch (cbrtn) {
        case SIO_ERDY_SND:
            uart_enable_send(siopcb);
            break;
        case SIO_ERDY_RCV:
            uart_enable_rcv(siopcb);
            break;
    }
}


/*
 *  ꥢI/OݡȤΥХåζػ
 */
void
uart_dis_cbr(SIOPCB *siopcb, UINT cbrtn)
{
    switch (cbrtn) {
        case SIO_ERDY_SND:
            uart_disable_send(siopcb);
            break;
        case SIO_ERDY_RCV:
            uart_disable_rcv(siopcb);
            break;
    }
}



/*
 *  ꥢI/OݡȤФ߽
 */
static void
uart_isr_siop(SIOPCB *siopcb)
{
    if (uart_getready(siopcb)) {
        /*
         *  ΥХå롼ƤӽФ
         */
        uart_ierdy_rcv(siopcb->exinf);
    }
    if (uart_putready(siopcb)) {
        /*
         *  ǽХå롼ƤӽФ
         */
        uart_ierdy_snd(siopcb->exinf);
    }
}


/*
 *  SIOγߥӥ롼
 */
void
int_timer2()
{
    SIOPCB *siopcb = &(siopcb_table[0]);

    sil_rew_mem((VP)(TADR_TC_BASE+TC_WINDOW*2+TOFF_TC_SR));
    if (uart_getready(siopcb)) {
        /*
         *  ΥХå롼ƤӽФ
         */
        uart_ierdy_rcv(siopcb->exinf);
    }
}

#if TNUM_SIOP >= 2
void
uart_isr1()
{
    uart_isr_siop(&(siopcb_table[1]));
}
#endif
